/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.SASScope;
import com.sas.rio.MVASQLException;
import com.sas.rio.MVASQLWarning;
import com.sas.rio.MessageCode;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;

@SASScope
final class MVAConnectionProperties {
    private String userName;
    public static final String HOST = "host";
    public static final String PORT = "port";
    private static final String EMPTY_STRING = "";
    private static final Properties defaultProperties = new Properties();
    private static final Map<String, String> lowCaseProps;
    private static final int DEFAULT_CHUNK_SIZE = 256;
    private static final int MAX_CHUNK_SIZE = 32760;
    private Properties connProperties;
    private SQLWarning warnings;
    private static MVAConnectionProperties defaults;

    private MVAConnectionProperties() {
        this.connProperties = new Properties(defaultProperties);
    }

    @Nonnull
    static synchronized MVAConnectionProperties getDefaults() {
        if (defaults == null) {
            defaults = new MVAConnectionProperties();
        }
        return defaults;
    }

    public MVAConnectionProperties(Properties userSupplied, String url) throws SQLException {
        this(userSupplied);
        this.connProperties.setProperty(HOST, this.getHost(url));
        this.connProperties.setProperty(PORT, this.getPort(url));
        int qi = url.indexOf("?");
        if (qi >= 0) {
            String query = url.substring(++qi, url.length());
            StringTokenizer pairOff = new StringTokenizer(query, "&", false);
            while (pairOff.hasMoreTokens()) {
                String pair = pairOff.nextToken();
                char last = pair.charAt(pair.length() - 1);
                if (last == '\\') {
                    String realPair;
                    pair = realPair = pair.substring(0, pair.length() - 1) + "&" + pairOff.nextToken();
                }
                int pi = pair.indexOf("=");
                String propKey = pair.substring(0, pi);
                String propValue = pair.substring(pi + 1, pair.length());
                String canonicalForm = lowCaseProps.get(propKey.toLowerCase());
                if (canonicalForm == null) {
                    MVASQLWarning sqlw = new MVASQLWarning(MessageCode.MVADriver_InvalidProperty, propKey);
                    if (this.warnings == null) {
                        this.warnings = sqlw;
                        continue;
                    }
                    this.warnings.setNextWarning(sqlw);
                    continue;
                }
                this.connProperties.setProperty(canonicalForm, propValue);
            }
        }
    }

    public MVAConnectionProperties(Properties userSupplied) throws SQLException {
        int value = 0;
        this.connProperties = new Properties(defaultProperties);
        for (Map.Entry<Object, Object> entry : userSupplied.entrySet()) {
            String propKey = (String)entry.getKey();
            String propValue = (String)entry.getValue();
            String canonicalForm = lowCaseProps.get(propKey.toLowerCase());
            if ("user".equalsIgnoreCase(propKey)) {
                this.connProperties.put("userName", propValue);
                continue;
            }
            if ("dbms".equalsIgnoreCase(propKey)) {
                this.connProperties.put("dbms", propValue.toUpperCase());
                continue;
            }
            if ("segmentLength".equalsIgnoreCase(propKey)) {
                boolean error = true;
                try {
                    value = Integer.parseInt(propValue);
                    if (value <= 0) {
                        value = 256;
                    } else if (value > 32760) {
                        value = 32760;
                    } else {
                        error = false;
                    }
                }
                catch (NumberFormatException e) {
                    value = 256;
                }
                if (error) {
                    MVASQLWarning sqlw = new MVASQLWarning(MessageCode.MVADriver_InvalidChunkSize, propValue);
                    if (this.warnings == null) {
                        this.warnings = sqlw;
                    } else {
                        this.warnings.setNextWarning(sqlw);
                    }
                }
                this.connProperties.put("segmentLength", String.valueOf(value));
                continue;
            }
            if (canonicalForm != null) {
                this.connProperties.put(canonicalForm, propValue);
                continue;
            }
            this.connProperties.put(propKey, propValue);
            MVASQLWarning sqlw = new MVASQLWarning(MessageCode.MVADriver_InvalidProperty, propKey);
            if (this.warnings == null) {
                this.warnings = sqlw;
                continue;
            }
            this.warnings.setNextWarning(sqlw);
        }
    }

    public Properties getProperties() {
        return this.connProperties;
    }

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static Properties getNonDefaultProperties(MVAConnectionProperties userProps) {
        Properties nonDefault = new Properties();
        for (Map.Entry<Object, Object> entry : userProps.getProperties().entrySet()) {
            String userPropName = (String)entry.getKey();
            String userPropValue = (String)entry.getValue();
            String defaultPropValue = (String)defaultProperties.get(userPropName);
            if (defaultPropValue == null || defaultPropValue.equals(userPropValue)) continue;
            nonDefault.put(userPropName, userPropValue);
        }
        return nonDefault;
    }

    public String getHost() {
        return this.connProperties.getProperty(HOST);
    }

    public String getPort() {
        return this.connProperties.getProperty(PORT);
    }

    public String getUserName() {
        if (this.userName == null) {
            this.userName = this.connProperties.getProperty("userName");
        }
        return this.userName;
    }

    public String getPassword() {
        return this.connProperties.getProperty("password");
    }

    public String getDbms() {
        return this.connProperties.getProperty("dbms");
    }

    public String getDbmsOptions() {
        return this.connProperties.getProperty("dbmsOptions");
    }

    public boolean hasRemarks() {
        return Boolean.parseBoolean(this.connProperties.getProperty("remarks"));
    }

    public boolean isUndoPolicyNone() {
        return Boolean.parseBoolean(this.connProperties.getProperty("undoPolicyNone"));
    }

    public String getLibrefs() {
        return this.connProperties.getProperty("librefs");
    }

    public List<String> getLibnameStatements() {
        ArrayList<String> libnames = new ArrayList<String>();
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        boolean inParentheses = false;
        StringBuilder libname = new StringBuilder();
        String librefs = this.getLibrefs();
        char[] librefsArray = librefs.toCharArray();
        for (int i = 0; i < librefsArray.length; ++i) {
            char c = librefsArray[i];
            if (c == '\"') {
                if (i + 1 < librefsArray.length && librefsArray[i + 1] == '\'') {
                    ++i;
                } else {
                    inSingleQuote = !inSingleQuote;
                }
            } else if (c == '\'') {
                if (i + 1 < librefsArray.length && librefsArray[i + 1] == '\"') {
                    ++i;
                } else {
                    inDoubleQuote = !inDoubleQuote;
                }
            } else if (c == '(') {
                if (!inSingleQuote && !inDoubleQuote) {
                    inParentheses = true;
                }
            } else if (c == ')' && !inSingleQuote && !inDoubleQuote) {
                inParentheses = false;
            }
            if (!(c != ';' || inSingleQuote || inDoubleQuote || inParentheses)) {
                libnames.add(libname.toString());
                libname.setLength(0);
                continue;
            }
            libname.append(c);
        }
        if (libname.length() > 0) {
            libnames.add(libname.toString());
        }
        return libnames;
    }

    public Map<String, String> getLibrefMap() {
        LinkedHashMap<String, String> librefMap = new LinkedHashMap<String, String>();
        for (String libnameStatement : this.getLibnameStatements()) {
            boolean parsingLibref = true;
            boolean inSingleQuote = false;
            boolean inDoubleQuote = false;
            boolean inParentheses = false;
            StringBuilder libref = new StringBuilder();
            StringBuilder path = new StringBuilder();
            String stripped = libnameStatement.replaceAll("\\p{Cntrl}", EMPTY_STRING);
            char[] lsArray = stripped.toCharArray();
            for (int i = 0; i < lsArray.length; ++i) {
                char c = lsArray[i];
                if (c == ' ' || c == '(' || c == '\'' || c == '\"') {
                    if (parsingLibref && c == ' ') continue;
                    parsingLibref = false;
                }
                if (parsingLibref) {
                    libref.append(c);
                    continue;
                }
                if (c == '\'') {
                    if (i + 1 < lsArray.length && lsArray[i + 1] == '\'') {
                        path.append(c);
                        path.append(lsArray[i + 1]);
                        ++i;
                        continue;
                    }
                    if (inDoubleQuote || inParentheses) {
                        path.append(c);
                        continue;
                    }
                    inSingleQuote = !inSingleQuote;
                    continue;
                }
                if (c == '\"') {
                    if (i + 1 < lsArray.length && lsArray[i + 1] == '\"') {
                        path.append(c);
                        path.append(lsArray[i + 1]);
                        ++i;
                        continue;
                    }
                    if (inSingleQuote || inParentheses) {
                        path.append(c);
                        continue;
                    }
                    inDoubleQuote = !inDoubleQuote;
                    continue;
                }
                if (c == '(') {
                    if (!inSingleQuote && !inDoubleQuote) {
                        inParentheses = true;
                    }
                    path.append(c);
                    continue;
                }
                if (c == ')') {
                    if (!inSingleQuote && !inDoubleQuote) {
                        inParentheses = false;
                    }
                    path.append(c);
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    if (!inSingleQuote && !inDoubleQuote && !inParentheses) continue;
                    path.append(c);
                    continue;
                }
                path.append(c);
            }
            librefMap.put(libref.toString(), path.toString());
        }
        return librefMap;
    }

    public String getEncryptionPolicy() {
        return this.connProperties.getProperty("encryptionPolicy");
    }

    public String getEncryptionContent() {
        return this.connProperties.getProperty("encryptionContent");
    }

    public String getEncryptionAlgorithms() {
        return this.connProperties.getProperty("encryptionAlgorithms");
    }

    public boolean isApplyFormats() {
        return Boolean.parseBoolean(this.connProperties.getProperty("applyFormats"));
    }

    public String getApplyFormats() {
        return this.connProperties.getProperty("applyFormats");
    }

    public String getSasifyTableNames() {
        return this.connProperties.getProperty("sasifyTableNames");
    }

    public boolean isCoerceNumeric() {
        return Boolean.parseBoolean(this.connProperties.getProperty("coerceNumericTypes"));
    }

    public String getCoerceNumericTypes() {
        return this.connProperties.getProperty("coerceNumericTypes");
    }

    public String getSspi() {
        return this.connProperties.getProperty("useSspi");
    }

    public String getSpn() {
        return this.connProperties.getProperty("spn");
    }

    public String getSegmentLength() {
        return this.connProperties.getProperty("segmentLength");
    }

    private String getHost(String url) throws SQLException {
        int hoststart = 14;
        int hostend = url.indexOf(58, hoststart);
        if (hostend == -1) {
            throw new MVASQLException(MessageCode.MVAConnection_urlMustSpecifyServer, new Object[0]);
        }
        if (url.length() < hostend + 3) {
            throw new MVASQLException(MessageCode.MVAConnection_urlMustSpecifyServer, new Object[0]);
        }
        return url.substring(hoststart, hostend);
    }

    private String getPort(String url) throws SQLException {
        int hostend = url.indexOf(58, 14);
        if (hostend == -1) {
            throw new MVASQLException(MessageCode.MVAConnection_urlMustSpecifyServer, new Object[0]);
        }
        if (url.length() < hostend + 3) {
            throw new MVASQLException(MessageCode.MVAConnection_urlMustSpecifyServer, new Object[0]);
        }
        int portend = url.indexOf(63, hostend);
        int port = portend == -1 ? Integer.parseInt(url.substring(hostend + 1)) : Integer.parseInt(url.substring(hostend + 1, portend));
        return Integer.toString(port);
    }

    void setApplyFormats(boolean applyFormats) {
        if (applyFormats) {
            this.connProperties.setProperty("applyFormats", "true");
        } else {
            this.connProperties.setProperty("applyFormats", "false");
        }
    }

    void setRemarks(boolean remarks) {
        if (remarks) {
            this.connProperties.setProperty("remarks", "true");
        } else {
            this.connProperties.setProperty("remarks", "false");
        }
    }

    void setSasifyTableNames(String sasify) {
        this.connProperties.setProperty("sasifyTableNames", sasify);
    }

    SQLWarning getWarnings() {
        return this.warnings;
    }

    boolean isForeignDatabase() {
        String dbms = this.connProperties.getProperty("dbms");
        boolean foreignDbms = dbms != null && dbms.indexOf("SQLVIEW") == -1;
        return foreignDbms;
    }

    static {
        defaultProperties.setProperty(HOST, EMPTY_STRING);
        defaultProperties.setProperty(PORT, EMPTY_STRING);
        defaultProperties.setProperty("userName", EMPTY_STRING);
        defaultProperties.setProperty("password", EMPTY_STRING);
        defaultProperties.setProperty("dbms", "SQLVIEW");
        defaultProperties.setProperty("dbmsOptions", EMPTY_STRING);
        defaultProperties.setProperty("remarks", "false");
        defaultProperties.setProperty("undoPolicyNone", "true");
        defaultProperties.setProperty("librefs", EMPTY_STRING);
        defaultProperties.setProperty("encryptionPolicy", EMPTY_STRING);
        defaultProperties.setProperty("encryptionContent", EMPTY_STRING);
        defaultProperties.setProperty("encryptionAlgorithms", EMPTY_STRING);
        defaultProperties.setProperty("applyFormats", "false");
        defaultProperties.setProperty("sasifyTableNames", "default");
        defaultProperties.setProperty("coerceNumericTypes", "true");
        defaultProperties.setProperty("useSspi", "none");
        defaultProperties.setProperty("spn", EMPTY_STRING);
        defaultProperties.setProperty("segmentLength", String.valueOf(256));
        HashMap<String, String> mutableLowCaseProps = new HashMap<String, String>();
        for (Object propKeyObj : defaultProperties.keySet()) {
            String propKey = (String)propKeyObj;
            mutableLowCaseProps.put(propKey.toLowerCase(), propKey);
        }
        lowCaseProps = Collections.unmodifiableMap(mutableLowCaseProps);
    }
}

