/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb.brg;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.ORBBase;
import com.sas.iom.orb.SASURI;
import com.sas.iom.orb.SelectionHub;
import com.sas.iom.orb.brg.Conversation;
import com.sas.iom.orb.brg.Daemon;
import com.sas.iom.orb.brg.DelegateImpl;
import com.sas.iom.orb.brg.Engine;
import com.sas.iom.orb.brg.RB;
import com.sas.text.Message;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;

@SASScope
public class ORBImpl
extends ORBBase {
    private static final Pattern nvPattern = Pattern.compile("\\s*([^\\s=]+)\\s*(?:=\\s*(\\S*))?");
    private static final String dash = "-";
    private static final String daemonParmsKey = "daemonParms";
    public static final String _daemonParmsKey = "-daemonParms";

    public ORBImpl() {
        this(null);
    }

    public ORBImpl(SelectionHub hub) {
        super(hub);
    }

    public static void main(String[] argv) {
        ORBImpl orb = new ORBImpl();
        Properties p = ORBImpl.stringArrayToProperties(argv);
        String nvPairs = p.getProperty(daemonParmsKey);
        Daemon daemon = orb.getDaemon(nvPairs);
        daemon.start();
    }

    @Override
    public Object uri_to_object(SASURI uri) {
        if (uri == null) {
            return null;
        }
        String protocol = uri.getProtocol();
        if (protocol != null && !"BRIDGE".equals(protocol)) {
            return super.uri_to_object(uri);
        }
        SelectionHub hub = this.getSelectionHub();
        Conversation conversation = new Conversation(this, hub, uri);
        this.trackResource(conversation);
        ObjectImpl obj = Engine.initClient(conversation);
        return obj;
    }

    @Override
    public SASURI object_to_uri(Object obj) {
        Delegate delegate = ((ObjectImpl)obj)._get_delegate();
        if (!(delegate instanceof DelegateImpl)) {
            return super.object_to_uri(obj);
        }
        Conversation conversation = ((DelegateImpl)delegate).getConversation();
        SASURI uri = conversation.getURI();
        return uri;
    }

    public Daemon getDaemon(Properties daemonParms) {
        SelectionHub hub = this.getSelectionHub();
        Daemon daemon = new Daemon(this, hub, daemonParms);
        return daemon;
    }

    public Daemon getDaemon(String nvPairs) {
        Properties p = ORBImpl.nvPairsToProperties(nvPairs);
        Daemon d = this.getDaemon(p);
        return d;
    }

    private static Properties stringArrayToProperties(String[] argv) {
        Properties p = new Properties();
        if (argv == null) {
            return p;
        }
        int i = 0;
        while (i < argv.length) {
            String name = null;
            String value = null;
            if (argv[i] == null || argv[i].length() == 0) {
                ++i;
                continue;
            }
            if (argv[i].startsWith(dash) && argv[i].length() > 1) {
                name = argv[i++].substring(1);
                if (!(i >= argv.length || argv[i].startsWith(dash) && argv[i].length() > 1)) {
                    value = argv[i++];
                }
                if (value == null) {
                    value = "";
                }
                p.put(name, value);
                continue;
            }
            String messageIndex = "ORBImpl.002.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (java.lang.Object)argv[i]);
            throw new INITIALIZE(message);
        }
        return p;
    }

    private static Properties nvPairsToProperties(String nvPairs) {
        Properties p = new Properties();
        if (nvPairs == null) {
            return p;
        }
        Matcher nvMatcher = nvPattern.matcher(nvPairs);
        while (nvMatcher.find()) {
            String name = nvMatcher.group(1);
            String value = nvMatcher.group(2);
            if (value == null) {
                value = "";
            }
            p.put(name, value);
        }
        return p;
    }
}

