/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb.brg;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.SASURI;
import com.sas.iom.orb.brg.BufferManager;
import com.sas.iom.orb.brg.Conversation;
import com.sas.iom.orb.brg.Engine;
import com.sas.iom.orb.brg.Marshaller;
import com.sas.iom.orb.brg.ProtocolVersion;
import com.sas.iom.orb.brg.RB;
import com.sas.net.crypto.CipherInterface;
import com.sas.net.crypto.Crypto;
import com.sas.net.crypto.CryptoException;
import com.sas.text.Message;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.UNKNOWN;

@SASScope
public final class Engine0200
extends Engine {
    private static final byte[] padding = new byte[20];
    private static final byte[] oldPadding = new byte[16];
    private static final byte[] sasiMagic = new byte[]{83, 65, 83, 73};
    private static final byte GIOPMT_Request = 0;
    private static final byte GIOP_LE = 1;
    private static final byte GIOP_FRAGMENT = 2;
    private static final byte BR_FLAGS1_JAVA_DT = -128;
    private static final byte BR_FLAGS1_PC_MISS = 64;
    private static final byte BR_FLAGS1_SAS = 32;
    private static final byte BR_FLAGS1_VAX = 2;
    private static final byte BR_FLAGS1_IBM = 1;
    private static final byte BR_FLAGS1_IEEE = 0;
    private static final byte BR_FLAGS2_BY_NAME = -128;
    private static final byte BR_FLAGS2_COLUMN = 64;
    private static final byte BR_FLAGS2_REDIRECT = 32;
    private static final byte BR_FLAGS2_ENC_CRED = 16;
    private static final byte BR_FLAGS2_ENC_ALL = 8;
    private static final byte GIOP_FLAGS_SET = 3;
    private static final byte BR_FLAGS1_SET = -29;
    private static final byte BR_FLAGS2_SET = -8;
    private static final byte dblMask = 3;
    private static final byte cryptoMask = 24;
    private static final int giopHeaderSize = 8 + sasiMagic.length;
    private static final int reqsPayloadSize = 4 + padding.length;
    private static final int oldReqsPayloadSize = 8 + oldPadding.length;

    protected Engine0200() {
    }

    @Override
    protected Marshaller createMarshaller() {
        return new Marshaller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean flowSendReqs(Conversation conversation) {
        byte encrLevel = conversation.getEncryptionLevel();
        if (encrLevel != 0) {
            this.getCrypto(conversation);
        }
        String scheme = conversation.isConnectWithSSL() ? "IOMS" : "IOM";
        SASURI uri = conversation.getNegotiatedURI(scheme, omitAttrArr);
        String uriStr = uri.toString();
        Marshaller marshaller = this.getMarshaller();
        ByteBuffer uriBuf = marshaller.stringToBuffer(conversation, uriStr);
        short uriBufL = (short)uriBuf.remaining();
        int msgSize = reqsPayloadSize + uriBufL;
        int bufSize = giopHeaderSize + msgSize;
        ProtocolVersion pv = conversation.getProtocolVersion();
        byte pvMajor = pv.getMajor();
        byte pvMinor = pv.getMinor();
        byte flag2 = -128;
        if (conversation.isRedirected()) {
            flag2 = (byte)(flag2 | 0x20);
        }
        BufferManager bufferManager = conversation.getBufferManager();
        ByteBuffer reqs = bufferManager.checkout(bufSize);
        byte status = 0;
        try {
            reqs.put(sasiMagic);
            reqs.put(pvMajor);
            reqs.put(pvMinor);
            reqs.put((byte)0);
            reqs.put((byte)0);
            reqs.putInt(msgSize);
            reqs.put((byte)-128);
            reqs.put(flag2);
            reqs.putShort(uriBufL);
            reqs.put(padding);
            reqs.put(uriBuf);
            reqs.flip();
            status = this.sendReqs(conversation, reqs);
        }
        finally {
            bufferManager.checkin(reqs);
        }
        boolean done = this.handleStatus(conversation, status);
        return done;
    }

    @Override
    protected boolean flowReadReqs(Conversation conversation) {
        boolean done = false;
        try {
            SocketChannel channel = conversation.getChannel();
            ByteBuffer reqs = ByteBuffer.allocate(giopHeaderSize);
            for (int i = 0; i < sasiMagic.length; ++i) {
                byte b;
                if (reqs.remaining() >= giopHeaderSize - i) {
                    channel.read(reqs);
                }
                if ((b = reqs.get(i)) == sasiMagic[i]) continue;
                reqs.rewind();
                this.logData(conversation, reqs, "received data from peer");
                Locale locale = conversation.getLocale();
                if (i == 0 && b == 105) {
                    String messageIndex = "Engine0200.000.ex.txt";
                    String message = RB.getStringResource(messageIndex, locale);
                    throw new NO_IMPLEMENT(message);
                }
                String messageIndex = "Engine0200.001.ex.txt";
                String message = RB.getStringResource(messageIndex, locale);
                throw new UNKNOWN(message);
            }
            if (reqs.remaining() > 0) {
                Engine0200.readFully(conversation, reqs);
            } else {
                reqs.rewind();
            }
            this.logData(conversation, reqs, "received data from peer");
            reqs.position(sasiMagic.length);
            byte pvMajor = reqs.get();
            byte pvMinor = reqs.get();
            byte giopFlags = reqs.get();
            ByteOrder byteOrder = (giopFlags & 1) != 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
            reqs.order(byteOrder);
            BufferManager bufferManager = new BufferManager(byteOrder);
            conversation.setBufferManager(bufferManager);
            byte giopMT = reqs.get();
            int msgSize = reqs.getInt();
            reqs = bufferManager.allocate(msgSize);
            Engine0200.readFully(conversation, reqs);
            this.logData(conversation, reqs, "received data from peer");
            ByteBuffer reqsReply = null;
            if (pvMajor > 2 || pvMajor == 2 && pvMinor > 0) {
                ProtocolVersion pv = conversation.getProtocolVersion();
                pvMajor = pv.getMajor();
                pvMinor = pv.getMinor();
                reqsReply = bufferManager.allocate(3);
                reqsReply.put((byte)9);
                reqsReply.put(pvMajor);
                reqsReply.put(pvMinor);
                done = true;
            } else {
                byte brgFlags1 = reqs.get();
                byte brgFlags2 = reqs.get();
                short uriLen = reqs.getShort();
                byte localeBufLen = reqs.get();
                byte algBufLen = reqs.get();
                short serverBufLen = reqs.getShort();
                byte[] fluff = new byte[oldPadding.length];
                reqs.get(fluff);
                boolean sasDateTime = false;
                boolean columnMajor = false;
                boolean pcMiss = false;
                Locale locale = null;
                String algName = null;
                String serverName = null;
                SASURI uri = null;
                if (uriLen > 0) {
                    String uriStr = this.getMarshaller().decodeString(conversation, reqs, uriLen);
                    uri = SASURI.create(uriStr);
                    locale = uri.getLocale();
                    algName = uri.getEncryptionAlgorithms();
                    serverName = uri.getServerName();
                } else {
                    if (localeBufLen > 0) {
                        String localeName = this.getMarshaller().decodeString(conversation, reqs, localeBufLen);
                        locale = SASURI.parseLocaleName(localeName);
                    }
                    if (algBufLen > 0) {
                        algName = this.getMarshaller().decodeString(conversation, reqs, algBufLen);
                    }
                    if (serverBufLen > 0) {
                        serverName = this.getMarshaller().decodeString(conversation, reqs, serverBufLen);
                    }
                }
                boolean reject = false;
                if (giopMT != 0 || (giopFlags & 2) != 0) {
                    throw new INTERNAL();
                }
                if ((giopFlags & 0xFFFFFFFC) != 0) {
                    reject = true;
                    giopFlags = (byte)(giopFlags & 3);
                }
                if ((brgFlags1 & 0xFFFFFF80) == 0) {
                    if ((brgFlags1 & 0x20) != 0) {
                        reject = true;
                        brgFlags1 = (byte)(brgFlags1 | 0xFFFFFF80);
                    } else {
                        sasDateTime = true;
                    }
                }
                if ((brgFlags1 & 0x40) != 0) {
                    if ((brgFlags1 & 0x20) != 0) {
                        reject = true;
                        brgFlags1 = (byte)(brgFlags1 & 0xFFFFFFBF);
                    } else {
                        pcMiss = true;
                    }
                }
                if ((brgFlags1 & 3) != 0) {
                    reject = true;
                    brgFlags1 = (byte)(brgFlags1 & 0xFFFFFFFC);
                }
                if ((brgFlags1 & 0x1C) != 0) {
                    reject = true;
                    brgFlags1 = (byte)(brgFlags1 & 0xFFFFFFE3);
                }
                if ((brgFlags2 & 0xFFFFFF80) == 0) {
                    reject = true;
                    brgFlags2 = (byte)(brgFlags2 | 0xFFFFFF80);
                }
                if ((brgFlags2 & 0x40) != 0) {
                    columnMajor = true;
                }
                if ((brgFlags2 & 7) != 0) {
                    reject = true;
                    brgFlags2 = (byte)(brgFlags2 & 0xFFFFFFF8);
                }
                if (!Arrays.equals(fluff, oldPadding)) {
                    reject = true;
                }
                byte serverEncrLevel = conversation.getEncryptionLevel();
                byte clientEncrLevel = 0;
                if (uri == null) {
                    if ((brgFlags2 & 8) != 0) {
                        clientEncrLevel = 2;
                    } else if ((brgFlags2 & 0x10) != 0) {
                        clientEncrLevel = 1;
                    }
                } else {
                    String encrLevel = uri.getEncrLevel();
                    if ("everything".equals(encrLevel)) {
                        clientEncrLevel = 2;
                    } else if ("credentials".equals(encrLevel)) {
                        clientEncrLevel = 1;
                    }
                }
                if (reject) {
                    if (uri == null) {
                        brgFlags2 = (byte)(brgFlags2 & 0xFFFFFFE7);
                        int outBufSize = giopHeaderSize + oldReqsPayloadSize + 1;
                        reqsReply = bufferManager.allocate(outBufSize);
                        reqsReply.put((byte)10);
                        reqsReply.put(sasiMagic);
                        reqsReply.put(pvMajor);
                        reqsReply.put(pvMinor);
                        reqsReply.put(giopFlags);
                        reqsReply.put((byte)0);
                        reqsReply.putInt(oldReqsPayloadSize);
                        reqsReply.put(brgFlags1);
                        reqsReply.put(brgFlags2);
                        reqsReply.put((byte)0);
                        reqsReply.put((byte)0);
                        reqsReply.put((byte)0);
                        reqsReply.put((byte)0);
                        reqsReply.putShort((short)0);
                        reqsReply.put(oldPadding);
                    } else {
                        String host = uri.getHost();
                        conversation.setHost(host);
                        int port = uri.getPort();
                        conversation.setPort(port);
                        String classID = uri.getClassFactory();
                        conversation.setClassID(classID);
                        String className = uri.getClassName();
                        conversation.setClassName(className);
                        SASURI negotiatedUri = conversation.getNegotiatedURI("IOM", omitAttrArr);
                        String uriStr = negotiatedUri.toString();
                        ByteBuffer uriBuf = this.getMarshaller().stringToBuffer(conversation, uriStr);
                        int uriBufL = uriBuf.remaining();
                        brgFlags2 = (byte)(brgFlags2 & 0xFFFFFFE7);
                        int outBufSize = giopHeaderSize + reqsPayloadSize + uriBufL + 1;
                        reqsReply = bufferManager.allocate(outBufSize);
                        reqsReply.put((byte)10);
                        reqsReply.put(sasiMagic);
                        reqsReply.put(pvMajor);
                        reqsReply.put(pvMinor);
                        reqsReply.put(giopFlags);
                        reqsReply.put((byte)0);
                        int payloadL = reqsPayloadSize + uriBufL;
                        reqsReply.putInt(payloadL);
                        reqsReply.put(brgFlags1);
                        reqsReply.put(brgFlags2);
                        reqsReply.putShort((short)uriBufL);
                        reqsReply.put(padding);
                        if (uriBufL > 0) {
                            reqsReply.put(uriBuf);
                        }
                    }
                } else if (serverEncrLevel > clientEncrLevel) {
                    reqsReply = bufferManager.allocate(2);
                    reqsReply.put((byte)2);
                    reqsReply.put(serverEncrLevel);
                } else if (clientEncrLevel != 0) {
                    String[] algArray = conversation.getAlgArray();
                    Crypto crypto = null;
                    if (algArray != null) {
                        if (algName != null) {
                            algName = algName.toUpperCase(Locale.US);
                            for (int i = 0; i < algArray.length; ++i) {
                                if (!algName.equals(algArray[i])) continue;
                                crypto = Crypto.getCrypto((String)algName, (Properties)new Properties());
                                if (crypto == null) {
                                    String messageIndex = "Engine0200.002.ex.fmt";
                                    String messagePattern = RB.getStringResource(messageIndex, locale);
                                    String message = Message.format((String)messagePattern, (Object)algName);
                                    throw new INITIALIZE(message);
                                }
                                break;
                            }
                        }
                    } else if (algName != null) {
                        crypto = Crypto.getCrypto((String)algName, (Properties)new Properties());
                    }
                    if (crypto == null) {
                        ByteBuffer encodeBuf;
                        int l = 2;
                        ByteBuffer[] encodeBufArray = null;
                        if (algArray != null) {
                            encodeBufArray = new ByteBuffer[algArray.length];
                            for (int i = 0; i < algArray.length; ++i) {
                                encodeBuf = this.getMarshaller().stringToBuffer(conversation, algArray[i]);
                                l += encodeBuf.remaining() + 1;
                                encodeBufArray[i] = encodeBuf;
                            }
                        } else {
                            ByteBuffer encodeBuf2 = this.getMarshaller().stringToBuffer(conversation, "SASPROPRIETARY");
                            l += encodeBuf2.remaining() + 1;
                            encodeBufArray = new ByteBuffer[]{encodeBuf2};
                        }
                        reqsReply = bufferManager.allocate(l);
                        reqsReply.put((byte)1);
                        reqsReply.put((byte)encodeBufArray.length);
                        for (int i = 0; i < encodeBufArray.length; ++i) {
                            encodeBuf = encodeBufArray[i];
                            reqsReply.put((byte)encodeBuf.remaining());
                            reqsReply.put(encodeBuf);
                        }
                    } else {
                        conversation.setCrypto(crypto);
                        conversation.setEncryptionLevel(clientEncrLevel);
                    }
                }
                if (reqsReply == null) {
                    conversation.setFlowState(90);
                    reqsReply = bufferManager.allocate(1);
                    reqsReply.put((byte)0);
                    conversation.setColumnMajor(columnMajor);
                    conversation.setPCMiss(pcMiss);
                    conversation.setSASDateTime(sasDateTime);
                    conversation.setServerName(serverName);
                    if (locale != null) {
                        this.setLocale(conversation, locale);
                    }
                }
            }
            reqsReply.rewind();
            if (this.isLoggable(conversation, fineRecord)) {
                Engine0200.log(conversation, fineRecord, "received requirements from peer", null);
                byte status = reqsReply.get(0);
                String st = Engine0200.reqsStatusToString(status);
                Engine0200.log(conversation, fineRecord, "sending requirements status to peer: " + st, null);
                this.logData(conversation, reqsReply, "sending data to peer");
            }
            channel.write(reqsReply);
            Crypto crypto = conversation.getCrypto();
            if (crypto != null) {
                CipherInterface cipher = crypto.openCipher();
                conversation.setCipher(cipher);
            }
        }
        catch (IOException ioe) {
            COMM_FAILURE comm_failure = new COMM_FAILURE();
            comm_failure.initCause((Throwable)ioe);
            throw comm_failure;
        }
        catch (CryptoException ce) {
            MARSHAL marshal = new MARSHAL();
            marshal.initCause((Throwable)ce);
            throw marshal;
        }
        if (done) {
            this.abortConversation(conversation);
        }
        return done;
    }

    protected String normalizeURI(Conversation conversation, String encr, byte encrLevel) {
        conversation.setEncryptionAlgorithms(encr);
        conversation.setEncryptionLevel(encrLevel);
        SASURI uri = conversation.getNegotiatedURI("IOM", omitAttrArr);
        return uri.toString();
    }
}

