"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasCondition = exports.findConditions = void 0;
const section_1 = require("./section");
function findConditions(template, logicalId, props = {}) {
    const section = template.Conditions ?? {};
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (!result.match) {
        return {};
    }
    return result.matches;
}
exports.findConditions = findConditions;
function hasCondition(template, logicalId, props) {
    const section = template.Conditions ?? {};
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return 'No conditions found in the template';
    }
    return [
        `Template has ${result.analyzedCount} conditions, but none match as expected.`,
        section_1.formatFailure(result.closestResult),
    ].join('\n');
}
exports.hasCondition = hasCondition;
//# sourceMappingURL=data:application/json;base64,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