Build or run agent service deployments.

This command group consists of a number of functionalities for building service deployments, run locally stored service deployments, and run service deployments defined in the on-chain protocol. See the appropriate subcommands for more information.

### Options
  
`--env-file FILE`
:   File containing environment variable mappings

### Examples

If you have an `.env` file in the working directory, `autonomy deploy` will load the `.env` file automatically. If the file is not present in the working directory you can provide the path to the file using `--env-file` flag

```bash
autonomy deploy --env-file <path_to_dotenv> COMMAND [ARGS]
```

For loading the environment variables you can use a `json` file as well. While using a `json` file you can either use `json` serialized strings like 

```json title="env.json"
{
    "ALL_PARTICIPANTS": "[\"0x0000000000000000000000000000000000000000\"]"
}
```

Or the `json` objects

```json title="env.json"
{
    "ALL_PARTICIPANTS": ["0x0000000000000000000000000000000000000000"]
}
```

The framework will handle both of these cases automatically.

```bash
autonomy deploy --env-file <path_to_json> COMMAND [ARGS]
```

## `autonomy deploy build`

Build a service deployment.

This command must be executed within a service folder. That is, a folder containing the service configuration file (`service.yaml`). The deployment will be created in the subfolder `./abci_build`.

### Usage

```bash
autonomy deploy build [OPTIONS] [KEYS_FILE]
```

### Options

`--o PATH`
:   Path to output directory.

`--n INTEGER`
:   Number of agents.

`--docker`
:   Use docker as a backend.

`--kubernetes`
:   Use kubernetes as a backend.

`--dev`
:   Create development environment.

`--log-level [INFO|DEBUG|WARNING|ERROR|CRITICAL]`
:   Logging level for runtime.

`--packages-dir PATH`
:   Path to packages directory (Use with `dev` mode).

`--open-aea-dir PATH`
:   Path to open-aea repo (Use with `dev` mode).

`--open-autonomy-dir PATH`
:   Path to open-autonomy repo (Use with `dev` mode).

`--aev`
:   Apply environment variable when loading service config.

`--use-hardhat`
:   Include a hardhat node in the deployment setup.

`--use-acn`
:   Include an ACN node in the deployment setup.

`-ltm, --local-tm-setup`
:   Use local tendermint chain setup.

`--image-version TEXT`
:   Define runtime image version.

`--remote`
:   To use a remote registry.

`--local`
:   To use a local registry.

`-p`
:   Ask for password interactively.

`--password PASSWORD`
:   Set password for key encryption/decryption.

`--help`
:   Show the help message and exit.


### Examples

```bash
autonomy deploy build keys.json -ltm
```

Builds a service deployment using the keys stored in the file `keys.json` and applying environment variables to the service configuration file. The deployment will be generated by default for as many agents as keys are stored in `keys.json`. By default, the command searches for the file `keys.json`, if no file name is provided.


## `autonomy deploy run`

Run a service deployment locally stored.

This command is a wrapper around `docker-compose up` to run the service deployment. To execute this command you need to be located within the deployment environment subfolder (`./abci_build`), or specify it with the option `--build-dir`.

### Usage

```bash
autonomy deploy run [OPTIONS]
```

### Options

`--build-dir PATH`
:   Path where the deployment is located.

`--no-recreate`
:   If containers already exist, don not recreate them.

`--remove-orphans`
:   Remove containers for services not defined in the Compose file.

`--help`
:   Show the help message and exit.

### Examples
```bash
autonomy deploy run --build-dir ./abci_build
```

Runs the service deployment stored locally in the directory `./abci_build`.


## `autonomy deploy from-token`

Run a service deployment minted on-chain protocol.

This command allows to deploy services directly without having the need to explicitly fetch them locally (also known as "one-click deployment"). The command requires the `TOKEN_ID` which can be checked in the {{ autonolas_protocol_registry_dapp }}. See the [mint a service on-chain](../../guides/publish_mint_packages.md) guide for more information.

To understand how to use various chain profiles refer to `Chain Selection` section on the `autonomy mint` command documentation.

### Usage

```bash
autonomy deploy from-token [OPTIONS] TOKEN_ID KEYS_FILE
```

### Options

`--n INTEGER`
:   Number of agents to include in the build.

`--skip-image`
:   Skip building images.

`--aev`
:   Apply environment variable when loading service config.

`--docker`
:   Use docker as a backend.
  
`--kubernetes`
:   Use kubernetes as a backend.
  
`--no-deploy`
:   If set to true, the deployment won't run automatically

`--use-ethereum`
: Use `ethereum` chain to resolve the token id.

`--use-goerli`
: Use `goerli` chain to resolve the token id.

`--use-custom-chain`
: Use custom chain to resolve the token id.

`--use-local`
: Use local chain to resolve the token id.

`--help`
:   Show the help message and exit.


### Examples

```bash
autonomy deploy from-token --use-goerli 2 keys.json
```

Runs the service deployment registered with `TOKEN_ID`=2 in the Görli on-chain protocol. The deployment will be run for as many agents as keys are defined in the `keys.json` file. 
