from typing import NamedTuple


class SubtaskPromptConstraintsItem(NamedTuple):
    """A `tuple` generated by the `subtask_prompt_generator` prompt module.

    Inherits from `NamedTuple`, so the attributes can be accessed with dot notation. e.g.
    ```
    # item: SubtaskPromptConstraintsItem
    subtask_title: str = item.subtask
    subtask_tag:str = item.tag
    subtask_prompt_template: str = item.prompt_template
    subtask_constraints: list[str] = item.constraints
    ```

    Attributes:
        subtask (`str`): The subtask title / brief description.
        tag (`str`): The tag (variable name) that identifies this subtask.
        prompt_template (`str`): The prompt template for this subtask.
        constraints (`list[str]`): A list of constraints assigned to this subtask.
    """

    subtask: str
    tag: str
    prompt_template: str
    constraints: list[str]
