# EPIK8s Chart for {{ beamline }}

This documentaion is automatically generated by *epik8s-tools* ({{version}}), last update {{time}}.

## Table of Contents
- [Beamline](#beamline)
- [IO Controllers (IOCS)](#iocs)
- [EPIK8s Services](#services)
- [Application](#spplications)

## Beamline

**BEAMLINE**: `{{ beamline }}`

**BEAMLINE URL**: `{{ giturl }}`

**BEAMLINE REV**: `{{ gitrev }}`

**Services DNS**: `{{ epik8namespace }}`

**Namespace**: `{{ namespace }}`

**EPIK8s charts default revision**: `{{targetRevision}}`

**CA Gateway**: `{{cagatewayip}}`

**PVA Gateway**: `{{pvagatewayip}}`




---

## IOCs

| Name             | Type       | Group      | Prefix                   |Template    | OPI                   | OPI Main   | OPI Macros                   |Description                                         |
|------------------|------------|------------|--------------------------|------------|------------------------|-----------|-------------------------|----------------------------------------------------|
{%- for ioc in iocs %}
  {%- set opiurl = "-" %}
  {%- set opimain = "-" %}
  {%- set ctx_macro = "-" %}

  {%- if ioc.opi %}
  {%- set opiurl = ioc.opi.url %}
  {%- set opimain = ioc.opi.main %}
  {%- set ctx_macro = ioc.opi.macroinfo %}
  {%- endif %}
| {{ ioc.name.ljust(16)}} | {{ ioc.devtype.ljust(10) }} | {{ ioc.devgroup.ljust(10)}} | {{ (ioc.iocprefix ~":"~ ioc.iocroot).ljust(23) }} | {{ (ioc.iocdir | string).ljust(10)}} | {{ opiurl.ljust(22)}} | {{ opimain.ljust(10)}} | {{ ctx_macro.ljust(30)}} | {{ (ioc.asset | string).ljust(50)}} |

{%- endfor %}


---

---

## Services
| Name             | URL                            | Balancer      | Chart                          |Description                                         |
|------------------|--------------------------------|---------------|--------------------------------|----------------------------------------------------|
{%- for service, details in services.items() %}
  {%- set loadb = "-" %}
  {%- set ingress = "-" %}
  {%- if details.loadbalancer %}
    {%- set loadb = details.loadbalancer %}
  {%- endif %}
  {%- if details.enable_ingress %}
    {%- set ingress = "http://"~beamline~"-"~service~"."~epik8namespace %}
  {%- endif %}
  | {{ service.ljust(16)}} | {{ ingress.ljust(30) }} | {{ loadb.ljust(10)}} | {{ details.charturl.ljust(30) }} | {{ (details.asset | string).ljust(50)}} |
{%- endfor %}

---

## Applications
| Name             | App Repo                       | Image                          |Description                                         |
|------------------|--------------------------------|--------------------------------|----------------------------------------------------|
{%- for app in applications %}
  | {{ app.name.ljust(16)}} | {{ app.gitRepoApp.url.ljust(30) }} | {{ app.image.repository.ljust(30)}} | {{ (app.asset | string).ljust(50)}} |
{%- endfor %}

## Phoebus Settings
You can find phoebus settings for epik8s `{{ beamline }}` in **opi/settings.ini**


