# micromagnetictests

[Marijan Beg](https://github.com/marijanbeg)<sup>1,2</sup>, [Martin Lang](https://github.com/lang-m)<sup>2</sup>, [Samuel Holt](https://github.com/samjrholt)<sup>2,3</sup>, and [Hans Fangohr](https://github.com/fangohr)<sup>2,4,5</sup>

<sup>1</sup> *Department of Earth Science and Engineering, Imperial College London, London SW7 2AZ, UK*  
<sup>2</sup> *Faculty of Engineering and Physical Sciences, University of Southampton, Southampton SO17 1BJ, UK*  
<sup>3</sup> *Department of Physics, University of Warwick, Coventry CV4 7AL, UK*  
<sup>4</sup> *Max Planck Institute for the Structure and Dynamics of Matter, Luruper Chaussee 149, 22761 Hamburg, Germany*  
<sup>5</sup> *Center for Free-Electron Laser Science, Luruper Chaussee 149, 22761 Hamburg, Germany*  


| Description | Badge |
| --- | --- |
| Tests | [![Build status](https://github.com/ubermag/micromagnetictests/workflows/workflow/badge.svg)](https://github.com/ubermag/micromagnetictests/actions?query=workflow%3Aworkflow) |
|       | [![conda](https://github.com/ubermag/micromagnetictests/workflows/conda/badge.svg)](https://github.com/ubermag/micromagnetictests/actions?query=workflow%3Aconda) |
| Linting | [![pre-commit.ci status](https://results.pre-commit.ci/badge/github/ubermag/micromagnetictests/master.svg)](https://results.pre-commit.ci/latest/github/ubermag/micromagnetictests/master)
| Releases | [![PyPI version](https://badge.fury.io/py/micromagnetictests.svg)](https://badge.fury.io/py/micromagnetictests) |
|          | [![Anaconda-Server Badge](https://anaconda.org/conda-forge/micromagnetictests/badges/version.svg)](https://anaconda.org/conda-forge/micromagnetictests) |
| Coverage | [![codecov](https://codecov.io/gh/ubermag/micromagnetictests/branch/master/graph/badge.svg?token=hcK4fofmrL)](https://codecov.io/gh/ubermag/micromagnetictests) |
| Documentation | [![Documentation](https://img.shields.io/badge/Docs-ubermag.github.io-blue)](https://ubermag.github.io/documentation/micromagnetictests.html) |
| YouTube | [![YouTube](https://img.shields.io/badge/YouTube-ubermag-blue)](https://www.youtube.com/channel/UC7MSqVQSMFV42R1jAYmKGLg) |
| Binder | [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/ubermag/micromagnetictests/latest?urlpath=lab/tree/docs) |
| Platforms | [![Platforms](https://anaconda.org/conda-forge/micromagnetictests/badges/platforms.svg)](https://anaconda.org/conda-forge/micromagnetictests) |
| Downloads | [![Downloads](https://anaconda.org/conda-forge/micromagnetictests/badges/downloads.svg)](https://anaconda.org/conda-forge/micromagnetictests) |
| License | [![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](https://opensource.org/licenses/BSD-3-Clause) |
| DOI | [![DOI](https://zenodo.org/badge/67028400.svg)](https://zenodo.org/badge/latestdoi/67028400) |

## About

`micromagnetictests` is a Python package, integrated with Jupyter, providing:

- A collection of computational magnetism tests for testing different calculators


It is available on Windows, MacOS, and Linux. It requires Python 3.8+.

## Documentation

APIs and tutorials are available in the documentation. To access the documentation, use the badge in the table above.

## Installation, testing, and upgrade

We recommend installation using `conda` package manager. Instructions can be found in the [documentation](https://ubermag.github.io/installation.html).

## Binder

This package can be used in the cloud via Binder. To access Binder, use the badge in the table above.

## YouTube

YouTube video tutorials are available on the [Ubermag channel](https://www.youtube.com/channel/UC7MSqVQSMFV42R1jAYmKGLg).

## Support

If you require support, have questions, want to report a bug, or want to suggest an improvement, please raise an issue in [ubermag/help](https://github.com/ubermag/help) repository.

## Contributions

All contributions are welcome, however small they are. If you would like to contribute, please fork the repository and create a pull request. If you are not sure how to contribute, please contact us by raising an issue in [ubermag/help](https://github.com/ubermag/help) repository, and we are going to help you get started and assist you on the way.

**Contributors**:


## License

Licensed under the BSD 3-Clause "New" or "Revised" License. For details, please refer to the [LICENSE](LICENSE) file.

## How to cite

1. M. Beg, M. Lang, and H. Fangohr. Ubermag: Towards more effective micromagnetic workflows. [*IEEE Transactions on Magnetics* **58**, 7300205](https://doi.org/10.1109/TMAG.2021.3078896) (2022).

2. M. Beg, R. A. Pepper, and H. Fangohr. User interfaces for computational science: A domain specific language for OOMMF embedded in Python. [*AIP Advances* **7**, 56025](http://aip.scitation.org/doi/10.1063/1.4977225) (2017).

3. Marijan Beg, Martin Lang, Samuel Holt, and Hans Fangohr. micromagnetictests: Testing package for computational magnetism tools. DOI: [10.5281/zenodo.3707736](http://doi.org/10.5281/zenodo.3707736) (2022).

## Acknowledgements

- [OpenDreamKit](http://opendreamkit.org/) – Horizon 2020 European Research Infrastructure project (676541)

- EPSRC Programme Grant on [Skyrmionics](http://www.skyrmions.ac.uk) (EP/N032128/1)
