/*
 * Decompiled with CFR 0.152.
 */
import chemaxon.formats.MolExporter;
import chemaxon.marvin.calculations.MajorMicrospeciesPlugin;
import chemaxon.marvin.io.formats.MoleculeImporter;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GetMajorMicroSpecies {
    public static String run_one(String string, String string2, String string3, Float f, boolean bl, boolean bl2, boolean bl3) throws IOException, PluginException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        MoleculeImporter moleculeImporter = new MoleculeImporter((InputStream)byteArrayInputStream, string2);
        Molecule molecule = moleculeImporter.read();
        if (bl3) {
            molecule.dearomatize();
        }
        MajorMicrospeciesPlugin majorMicrospeciesPlugin = new MajorMicrospeciesPlugin();
        majorMicrospeciesPlugin.setpH((double)f.floatValue());
        majorMicrospeciesPlugin.setTakeMajorTatomericForm(bl);
        majorMicrospeciesPlugin.setKeepExplicitHydrogens(bl2);
        majorMicrospeciesPlugin.setMolecule(molecule);
        majorMicrospeciesPlugin.run();
        Molecule molecule2 = majorMicrospeciesPlugin.getMajorMicrospecies();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MolExporter molExporter = new MolExporter((OutputStream)byteArrayOutputStream, string3);
        molExporter.write(molecule2);
        String string4 = byteArrayOutputStream.toString();
        return string4;
    }

    public static String[] run_multiple(String[] stringArray, String string, String string2, Float f, boolean bl, boolean bl2, boolean bl3) throws IOException, PluginException {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = GetMajorMicroSpecies.run_one(stringArray[i], string, string2, f, bl, bl2, bl3);
        }
        return stringArray2;
    }
}

