# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['scalarstop']

package_data = \
{'': ['*']}

install_requires = \
['SQLAlchemy>=1.4.5,<2.0.0',
 'alembic>=1.7.1,<2.0.0',
 'cloudpickle>=1.6.0,<2.0.0',
 'log-with-context',
 'numpy',
 'pandas',
 'psycopg2-binary>=2.8.6,<3.0.0']

extras_require = \
{'tensorflow': ['tensorflow>=2.5'], 'tensorflow-gpu': ['tensorflow-gpu>=2.5']}

setup_kwargs = {
    'name': 'scalarstop',
    'version': '3.0.0',
    'description': 'A framework for managing machine learning experiments.',
    'long_description': '.. image:: https://static.neocrym.com/images/scalarstop/v1/1x/scalarstop-wordmark-color-black-on-white--1x.png\n\nKeep track of your machine learning experiments with ScalarStop.\n================================================================\n\nScalarStop is a Python framework for reproducible machine learning research.\n\nIt was written and open-sourced at `Neocrym <https://www.neocrym.com>`_, where it is used to train thousands of models every week.\n\nScalarStop can help you:\n\n* organize datasets and models with *content-addressable* names.\n* save/load datasets and models to/from the filesystem.\n* record hyperparameters and metrics to a relational database.\n\nSystem requirements\n-------------------\nScalarStop is a Python package that requires Python 3.8 or newer.\n\nCurrently, ScalarStop only supports tracking\n`tf.data.Dataset <https://www.tensorflow.org/api_docs/python/tf/data/Dataset>`_\ndatasets and `tf.keras.Model <https://www.tensorflow.org/api_docs/python/tf/keras/Model>`_\nmodels. As such, ScalarStop requires TensorFlow 2.5.0 or newer.\n\nWe encourage anybody that would like to add support for other\nmachine learning frameworks to ScalarStop. :)\n\nInstallation\n------------\n\nScalarStop is `available on PyPI <https://pypi.org/project/scalarstop/>`_.\n\nIf you are using TensorFlow on a CPU, you can install ScalarStop with the command:\n\n.. code:: bash\n\n    python3 -m pip install scalarstop[tensorflow]\n\nIf you are using TensorFlow with GPUs, you can install ScalarStop with the command:\n\n.. code:: bash\n\n    python3 -m pip install scalarstop[tensorflow-gpu]\n\nDevelopment\n-----------\n\nIf you would like to make changes to ScalarStop, you can `clone the repository <https://github.com/scalarstop/scalarstop>`_\nfrom GitHub.\n\n.. code:: bash\n\n    git clone https://github.com/scalarstop/scalarstop.git\n    cd scalarstop\n    python3 -m pip install .\n\nUsage\n-----\n\nRead the `ScalarStop Tutorial <https://github.com/scalarstop/scalarstop/blob/main/notebooks/tutorial.ipynb>`_ to learn the core concepts behind ScalarStop and how to structure your datasets and models.\n\nAfterwards, you might want to dig deeper into the `ScalarStop Documentation <https://docs.scalarstop.com>`_. In general, a typical ScalarStop workflow involves four steps:\n\n1. Organize your datasets with `scalarstop.datablob <https://www.scalarstop.com/en/latest/autoapi/scalarstop/datablob/#module-scalarstop.datablob>`_.\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n2. Describe your machine learning model architectures using `scalarstop.model_template <https://www.scalarstop.com/en/latest/autoapi/scalarstop/model_template/#module-scalarstop.model_template>`_.\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n3. Load, train, and save machine learning models with `scalarstop.model <https://www.scalarstop.com/en/latest/autoapi/scalarstop/model/#module-scalarstop.model>`_.\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n4. Save hyperparameters and training metrics to a SQLite or PostgreSQL database using `scalarstop.train_store <https://www.scalarstop.com/en/latest/autoapi/scalarstop/train_store/#module-scalarstop.train_store>`_.\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\nContributing to ScalarStop\n--------------------------\n\nWe warmly welcome contributions to ScalarStop. Here are the technical details for getting started with adding code to ScalarStop.\n\nGetting started\n^^^^^^^^^^^^^^^\nFirst, clone this repository from GitHub. All development happens on the ``main`` branch.\n\n.. code:: bash\n\n    git clone https://github.com/scalarstop/scalarstop.git\n\nThen, run ``make install`` to install Python dependencies in a Poetry virtualenv.\n\nYou can run ``make help`` to see the other commands that are available.\n\nChecking your code\n^^^^^^^^^^^^^^^^^^\nRun ``make fmt`` to automatically format code.\n\nRun ``make lint`` to run Pylint and MyPy to check for errors.\n\nGenerating documentation\n^^^^^^^^^^^^^^^^^^^^^^^^\nDocumentation is important! Here is how to add to it.\n\nGenerating Sphinx documentation\n"""""""""""""""""""""""""""""""\n\nYou can generate a local copy of our Sphinx documentation at `scalarstop.com <https://www.scalarstop.com/en/latest/>`_ with ``make docs``.\n\nThe generated documentation can be found at ``docs/_build/dirhtml``. To view it, you should start an HTTP server in this directory, such as:\n\n.. code:: bash\n\n    make docs\n    cd docs/_build/dirhtml\n    python3 -m http.server 5000\n\nThen visit http://localhost:5000 in your browser to preview changes to the documentation.\n\nIf you want to use Sphinx\'s ability to automatically generate hyperlinks to the Sphinx documentation of other Python projects, then you should configure `intersphinx <https://www.sphinx-doc.org/en/master/usage/extensions/intersphinx.html>`_ settings at the path docs/conf.py. If you need to download an objects.inv file, make sure to update the ``make update-sphinx`` command in the `Makefile <https://github.com/scalarstop/scalarstop/blob/main/Makefile>`_.\n\nEditing the tutorial notebook\n"""""""""""""""""""""""""""""\nThe main ScalarStop tutorial is `in a Jupyter notebook <https://github.com/scalarstop/scalarstop/blob/main/notebooks/tutorial.ipynb>`_. If you have made changes to ScalarStop, you should rerun the Jupyter notebook on your machine with your changes to make sure that it still runs without error.\n\nRunning unit tests\n^^^^^^^^^^^^^^^^^^\nRun ``make test`` to run all unit tests.\n\nIf you want to run a specific unit test, try running ``python3 -m poetry run python -m unittest -k {name of your test}``.\n\nUnit tests with SQLite3\n"""""""""""""""""""""""\nIf you are running tests using a Python interpreter that does not have the `SQLite3 JSON1 extension <https://www.sqlite.org/json1.html>`_, then `TrainStore <https://www.scalarstop.com/en/latest/autoapi/scalarstop/train_store/#module-scalarstop.train_store>`_ unit tests involving SQLite3 will be skipped. This is likely to happen if you are using Python 3.8 on Windows. If you suspect that you are missing the SQLite3 JSON1 extension, the `Django documentation has some suggestions <https://code.djangoproject.com/wiki/JSON1Extension>`_ for how to fix it.\n\nUnit tests with PostgreSQL\n""""""""""""""""""""""""""\nBy default, tests involving PostgreSQL are skipped. To enable PostgreSQL, run ``make test`` in a shell where the environment variable ``TRAIN_STORE_CONNECTION_STRING`` is set to a `SQLAlchemy database connection URL <https://docs.sqlalchemy.org/en/14/core/engines.html>`_--which looks something like ``"postgresql://scalarstop:changeme@localhost:5432/train_store"``. The connection URL should point to a working PostgreSQL database with an existing database and user.\n\nThe docker-compose.yml file in the root of this directory can set up a PostgreSQL instance on your local machine. If you have `Docker <https://docs.docker.com/get-docker/>`_ and `Docker Compose <https://docs.docker.com/compose/install/>`_ installed, you can start the PostgreSQL database by running ``docker-compose up`` in the same directory as the docker-compose.yml file.\n\nMeasuring test coverage\n"""""""""""""""""""""""\nYou can run ``make test-with-coverage`` to collect Python line and branch coverage information. Afterwards, run ``make coverage-html`` to generate an HTML report of unit test coverage. You can view the report in a web browser at the path ``htmlcov/index.html``.\n\nCredits\n-------\nScalarStop\'s documentation is built with `Sphinx <https://www.sphinx-doc.org/>`_ using `@pradyunsg <https://pradyunsg.me>`_\'s `Furo <https://github.com/pradyunsg/furo>`_ theme and is hosted by `Read the Docs <https://readthedocs.org/>`_.\n',
    'author': 'Neocrym Records Inc',
    'author_email': 'engineering@neocrym.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://www.scalarstop.com',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
