# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['Certifik8',
 'Certifik8.constants',
 'Certifik8.examples',
 'Certifik8.installer',
 'Certifik8.modules',
 'Certifik8.modules.converter',
 'Certifik8.modules.generator',
 'Certifik8.modules.handler',
 'Certifik8.modules.selector',
 'Certifik8.tests']

package_data = \
{'': ['*']}

install_requires = \
['Pillow==9.3.0',
 'PyPDF2==2.11.1',
 'beautifulsoup4>=4.11.1,<5.0.0',
 'openpyxl>=3.0.10,<4.0.0',
 'pandas==1.5.2',
 'pdfkit==1.0.0',
 'setuptools==65.6.3',
 'tqdm>=4.64.1,<5.0.0']

entry_points = \
{'console_scripts': ['certifik8 = Certifik8.main:run']}

setup_kwargs = {
    'name': 'certifik8',
    'version': '0.2.4',
    'description': 'Certifik8 é um gerador de certificados automático criado em Python. O projeto busca facilitar a geração massiva de documentos a serem emitidos após algum evento.',
    'long_description': '# 2022-2-Certifik8\n\n<a name="readme-top"></a>\n\n<div align="center">\n\n[![Contributors](https://img.shields.io/github/contributors/fga-eps-mds/2022-2-Certifik8.svg?style=for-the-badge&color=e703f7)](https://github.com/fga-eps-mds/2022-2-Certifik8/graphs/contributors)\n[![Issues](https://img.shields.io/github/issues/fga-eps-mds/2022-2-Certifik8.svg?style=for-the-badge&color=e703f7)](https://github.com/fga-eps-mds/2022-2-Certifik8/issues)\n[![MIT License](https://img.shields.io/github/license/fga-eps-mds/2022-2-Certifik8.svg?style=for-the-badge&color=e703f7)](https://github.com/fga-eps-mds/2022-2-Certifik8/blob/main/LICENSE)\n\n[![Maintainability](https://api.codeclimate.com/v1/badges/e00e7a4c51d3c657319d/maintainability)](https://codeclimate.com/github/fga-eps-mds/2022-2-Certifik8/maintainability) \n[![Test Coverage](https://api.codeclimate.com/v1/badges/e00e7a4c51d3c657319d/test_coverage)](https://codeclimate.com/github/fga-eps-mds/2022-2-Certifik8/test_coverage)\n\n</div>\n\n<br />\n<div align="center">\n  <a href="https://github.com/fga-eps-mds/2022-2-Certifik8">\n    <img src="https://github.com/fga-eps-mds/2022-2-Certifik8/blob/main/docs/imagens/logo.png" width="300" height="300">\n  </a>\n\n<h3 align="center">Certifik8</h3>\n\n<p align="center">\n   Gerador Automatico de Certificados \n    <br />\n    <a href="docs">Documentos</a>\n    -\n    <a href="https://github.com/fga-eps-mds/2022-2-Certifik8/blob/main/docs/SECURITY.md#pol%C3%ADtica-de-seguran%C3%A7a">Reportar Bug</a>\n    -\n    <a href="https://github.com/fga-eps-mds/2022-2-Certifik8/issues">Recomendar Feature</a>\n  </p>\n</div>\n\n<!-- TABLE OF CONTENTS -->\n\n<details>\n  <summary>Conteúdo</summary>\n  <ol>\n    <li>\n      <a href="#-sobre-o-projeto">📝 Sobre o projeto</a>\n      <ul>\n        <li><a href="#-tecnologias">💻 Tecnologias</a></li>\n      </ul>\n    </li>\n    <li><a href="#-funcionalidade">🤖 Funcionalidade</a></li>\n    <li><a href="#-requisitos">❗ Requisitos</a></li>\n    <li><a href="#-como-rodar">\U0001f6de Como executar</a>\n\t<ul>\n        <li><a href="#---usuário">👩\u200d🦰 Usuário</a></li>\n        </ul>\n\t<ul>\n        <li><a href="#--%EF%B8%8F-desenvolvimento-local">🧙🏼\u200d♀️ Desenvolvimento local</a></li>\n        </ul>  \n    </li>\n    <li><a href="#-desenvolvedores">👨\u200d💻 Desenvolvedores</a></li>\n  </ol>\n</details>\n\n## 📝 Sobre o projeto\nCertifik8 é um gerador de certificados automático criado em Python. O projeto busca facilitar a geração massiva de documentos a serem emitidos após algum evento ou curso na Semana Universitária da UnB. \n\n## 💻 Tecnologias\n\n#### Tecnologias utilizadas neste projeto:\n\n<p align="center">\n\t<a href="https://skillicons.dev">\n\t\t<img src="https://skillicons.dev/icons?i=python,html,css"/>\n\t</a>\n</p>\n\n## 🤖 Funcionalidade\nO Certifik8 precisa apenas que o usuário escolha uma tabela excel .xlsx em algum de seus arquivos para em seguida escolher o local na qual a pasta com os certificados, de modelo já definido, ficarão salvos. Após essa escolha, a geração dos certificados em formato PDF acontece de forma que cada tabela escolhida possua uma pasta homônima no destino escolhido e cada pasta apresente subpastas que vão filtrar os participantes do evento de acordo com suas funções. \n\n\n**Exemplo**:\n\n\n<div align="center">\n  <a href="https://github.com/fga-eps-mds/2022-2-Certifik8/blob/main/Certifik8/examples/Melissa%20Ribeiro%20Araujo.png">\n    <img src="https://github.com/fga-eps-mds/2022-2-Certifik8/blob/main/Certifik8/examples/Melissa%20Ribeiro%20Araujo.png" width="413" height="291">\n  </a>\n</div>\n\n## ❗ Requisitos\n\nO Certifik8 só funciona em sistemas operacionais Linux.\n\nTestado no:\n\n- Linux Mint 21\n- Ubuntu 22.04.01\n\n<div align="center">\n\n![LinuxMint](https://img.shields.io/badge/Linux_Mint-87CF3E?style=for-the-badge&logo=linux-mint&logoColor=black)\n\n![Ubuntu](https://img.shields.io/static/v1?style=for-the-badge&message=Ubuntu&color=E95420&logo=Ubuntu&logoColor=FFFFFF&label=)\n\n</div>\n\n**Para conseguir executá-lo, o usuário precisa instalar:**\n  - **Python3 e Pip**\n    ```\n    sudo apt install python3 && sudo apt install python3-pip\n    ```\n\n## \U0001f6de Como executar/rodar\n\n### **- 👩\u200d🦰 Usuário**\n\n1. **Abra seu terminal e digite o comando para instalar o Certifik8 do Pypi:**\n```\npip install certifik8\n```\n\n2. **Comandos para instalar as dependências não presentes no Pypi**\n```\nsudo apt-get update -y\n```\n```\nsudo apt-get install -y zlib1g fontconfig libxrender1 libfreetype6 libxext6 libx11-6\n```\n```\nsudo apt install -y wkhtmltopdf\n```\n```\nsudo apt-get install -y zenity\n```\n3. **Comando para acessar tutorial da aplicação**\n```\ncertifik8 --h\n```\t\n4. **As tabelas dos cursos devem seguir uma padronização, caso contrário elas não irão gerar certificados:**\n* Estrutura da tabela Excel ([Exemplo](Certifik8/examples/completa.xlsx)): \n\n| 1 |           Nome             |       CPF      |    Função    | Frequência |     Informações    |\n|---|----------------------------|----------------|--------------|------------|--------------------|\n| 2 |Samuel Barbosa Alves        |729.334.326-41  |PARTICIPANTE  |100         |Nome do Curso       |\n| 3 |Melissa Ribeiro Araujo      |201.544.482-30  |MONITOR       |97          |Carga Horaria       |\n| 4 |Gabrielly Rodrigues Castro  |451.016.912-40  |PARTICIPANTE  |80          |Nome do Professor   |\n| 5 |           ...              |      ...       |     ...      |    ...     |Nome do Departamento|\n| 6 |           ...              |      ...       |     ...      |    ...     |Data Inicial        |\n| 7 |           ...              |      ...       |     ...      |    ...     |Data Final          |\n| 8 |           ...              |      ...       |     ...      |    ...     |Nome Decano(a)      |\n|...|           ...              |      ...       |     ...      |    ...     |                    |\n\n*Obs.: As tabelas devem possuir essas cinco colunas com os mesmos nomes e em qualquer ordem. A coluna informações deve possuir seis linhas, e seus dados devem seguir a ordem da tabela de exemplo abaixo\n\n5. **Comando para rodar a aplicação**\n```\ncertifik8\n```\n\n6. **Selecione as tabelas que possuem as informações do certificado:**\n<div align="center">\n<img src="https://github.com/fga-eps-mds/2022-2-Certifik8/blob/flag-help/docs/imagens/escolhe_tabela.png" width="800">\n</div>\n\n\n7. **Selecione a pasta onde deseja guardar os certificados:**\n<div align="center">\n<img src="https://github.com/fga-eps-mds/2022-2-Certifik8/blob/flag-help/docs/imagens/escolhe_pastas.png" width="800">\n</div>\n\n<div align="center">\n\n</div>\n\t\n### **- 🧙🏼\u200d♀️ Desenvolvimento local**\n\n1. **Clone o repositório**\n\n```\ngit clone https://github.com/fga-eps-mds/2022-2-Certifik8.git\n```\n2. **Para instalar as dependências não advindas do Pypi, abra o repositório em seu computador e rode o comando:**\n```\ncd Certifik8/installer\n```\n```\n./dependencies.sh\n```\n\n2. **Para instalar as dependências no ambiente virtual, rode o comando no diretório raiz:**\n```\npoetry install\n```\n\t\n3 **Para acessar tutorial da aplicação, rode o comando no diretório raiz:**\n```\npoetry run certifik8 --h\n```\t\n\t\n4 **Para rodar a aplicação no diretório raiz:**\n```\npoetry run certifik8\n```\n\n\n## 👨\u200d💻 Desenvolvedores\n\n<center>\n<table style="margin-left: auto; margin-right: auto;">\n    <tr>\n        <td align="center">\n            <a href="https://github.com/PedroSampaioDias">\n                <img style="border-radius: 50%;" src="https://avatars.githubusercontent.com/u/90795603?v=4" width="150px;"/>\n                <h5 class="text-center">Pedro Sampaio</h5>\n            </a>\n        </td>\n        <td align="center">\n            <a href="https://github.com/phmelosilva">\n                <img style="border-radius: 50%;" src="https://avatars.githubusercontent.com/u/88786258?v=4" width="150px;"/>\n                <h5 class="text-center">Pedro Henrique</h5>\n            </a>\n        </td>\n        <td align="center">\n            <a href="https://github.com/Victor-oss">\n                <img style="border-radius: 50%;" src="https://avatars.githubusercontent.com/u/55855365?v=4" width="150px;"/>\n                <h5 class="text-center">Victório Lazaro</h5>\n            </a>\n        </td>\n        <td align="center">\n            <a href="https://github.com/daniel-de-sousa">\n                <img style="border-radius: 50%;" src="https://avatars.githubusercontent.com/u/95941136?v=4" width="150px;"/>\n                <h5 class="text-center">Daniel Sousa</h5>\n            </a>\n        </td>\n        <td align="center">\n            <a href="https://github.com/Leanddro13">\n                <img style="border-radius: 50%;" src="https://avatars.githubusercontent.com/u/86811628?v=4" width="150px;"/>\n                <h5 class="text-center">Leandro Silva</h5>\n            </a>\n        </td>\n        <td align="center">\n            <a href="https://github.com/BlimblimCFT">\n                <img style="border-radius: 50%;" src="https://avatars.githubusercontent.com/u/12275797?v=4" width="150px;"/>\n                <h5 class="text-center">Geovane Freitas</h5>\n            </a>\n        </td>\n</table>\n</center>\n',
    'author': 'Victorio',
    'author_email': 'victorio.lazaro15@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/fga-eps-mds/Certifik8',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
