# esmlouvy
Toto je datový konektor umožňující datovou výměnu mezi obchodní logikou aplikace eSMLOUVY a datovým serverem HCL Domino.  Ovládá se pomocí REST API 

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.1.0
- Package version: 1.1.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import esmlouvy_connector 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import esmlouvy_connector
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import esmlouvy_connector
from esmlouvy_connector.rest import ApiException
from pprint import pprint

# Configure API key authorization: apiKey
configuration = esmlouvy_connector.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = esmlouvy_connector.AdminsApi(esmlouvy_connector.ApiClient(configuration))

try:
    # získá konfiguraci konektoru
    api_response = api_instance.get_config()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->get_config: %s\n" % e)

# Configure API key authorization: apiKey
configuration = esmlouvy_connector.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = esmlouvy_connector.AdminsApi(esmlouvy_connector.ApiClient(configuration))

try:
    # získá konfiguraci databáze serveru Domino
    api_response = api_instance.get_profile()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->get_profile: %s\n" % e)

# Configure API key authorization: apiKey
configuration = esmlouvy_connector.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = esmlouvy_connector.AdminsApi(esmlouvy_connector.ApiClient(configuration))

try:
    # získá pomocný profil (řízené slovníky) konfigurace databáze serveru Domino
    api_response = api_instance.get_profile_dir()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->get_profile_dir: %s\n" % e)

# Configure API key authorization: apiKey
configuration = esmlouvy_connector.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = esmlouvy_connector.AdminsApi(esmlouvy_connector.ApiClient(configuration))

try:
    # získá pomocný profil (role) konfigurace databáze serveru Domino
    api_response = api_instance.get_profile_roles()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->get_profile_roles: %s\n" % e)

# Configure API key authorization: apiKey
configuration = esmlouvy_connector.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = esmlouvy_connector.AdminsApi(esmlouvy_connector.ApiClient(configuration))
body = esmlouvy_connector.ConfigBody() # ConfigBody |  (optional)

try:
    # aktualizuje hlavní konfiguraci konektoru
    api_response = api_instance.put_config(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->put_config: %s\n" % e)

# Configure API key authorization: apiKey
configuration = esmlouvy_connector.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = esmlouvy_connector.AdminsApi(esmlouvy_connector.ApiClient(configuration))
body = esmlouvy_connector.ProfileMain() # ProfileMain |  (optional)

try:
    # aktualizuje nebo vytvoří hlavní konfiguraci aplikace Domino
    api_response = api_instance.put_profile(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->put_profile: %s\n" % e)

# Configure API key authorization: apiKey
configuration = esmlouvy_connector.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = esmlouvy_connector.AdminsApi(esmlouvy_connector.ApiClient(configuration))
body = esmlouvy_connector.ProfileDirectory() # ProfileDirectory |  (optional)

try:
    # aktualizuje nebo vytvoří pomocný profil (řízené slovníky) konfigurace databáze serveru Domino
    api_response = api_instance.put_profile_dir(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->put_profile_dir: %s\n" % e)

# Configure API key authorization: apiKey
configuration = esmlouvy_connector.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = esmlouvy_connector.AdminsApi(esmlouvy_connector.ApiClient(configuration))
body = esmlouvy_connector.ProfileRoles() # ProfileRoles |  (optional)

try:
    # aktualizuje nebo vytvoří pomocný profil (role) konfigurace databáze serveru Domino
    api_response = api_instance.put_profile_roles(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->put_profile_roles: %s\n" % e)

# Configure API key authorization: apiKey
configuration = esmlouvy_connector.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = esmlouvy_connector.AdminsApi(esmlouvy_connector.ApiClient(configuration))
body = esmlouvy_connector.ReplaceName() # ReplaceName |  (optional)

try:
    # Zamění jméno ve všech dokumentech a polích, kde se vyskytuje
    api_response = api_instance.replace_name(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->replace_name: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://virtserver.swaggerhub.com/SYSNET/eSMLOUVY/1.1.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdminsApi* | [**get_config**](docs/AdminsApi.md#get_config) | **GET** /config | získá konfiguraci konektoru
*AdminsApi* | [**get_profile**](docs/AdminsApi.md#get_profile) | **GET** /profile | získá konfiguraci databáze serveru Domino
*AdminsApi* | [**get_profile_dir**](docs/AdminsApi.md#get_profile_dir) | **GET** /profile_dir | získá pomocný profil (řízené slovníky) konfigurace databáze serveru Domino
*AdminsApi* | [**get_profile_roles**](docs/AdminsApi.md#get_profile_roles) | **GET** /profile_roles | získá pomocný profil (role) konfigurace databáze serveru Domino
*AdminsApi* | [**put_config**](docs/AdminsApi.md#put_config) | **PUT** /config | aktualizuje hlavní konfiguraci konektoru
*AdminsApi* | [**put_profile**](docs/AdminsApi.md#put_profile) | **PUT** /profile | aktualizuje nebo vytvoří hlavní konfiguraci aplikace Domino
*AdminsApi* | [**put_profile_dir**](docs/AdminsApi.md#put_profile_dir) | **PUT** /profile_dir | aktualizuje nebo vytvoří pomocný profil (řízené slovníky) konfigurace databáze serveru Domino
*AdminsApi* | [**put_profile_roles**](docs/AdminsApi.md#put_profile_roles) | **PUT** /profile_roles | aktualizuje nebo vytvoří pomocný profil (role) konfigurace databáze serveru Domino
*AdminsApi* | [**replace_name**](docs/AdminsApi.md#replace_name) | **POST** /replace_name | Zamění jméno ve všech dokumentech a polích, kde se vyskytuje
*AttachmentsApi* | [**delete_attachment**](docs/AttachmentsApi.md#delete_attachment) | **DELETE** /attachment/{identifier} | odstraní přílohu i s metadaty
*AttachmentsApi* | [**get_attachment**](docs/AttachmentsApi.md#get_attachment) | **GET** /attachment/download/{identifier} | vrací soubor přílohy
*AttachmentsApi* | [**get_attachment_list**](docs/AttachmentsApi.md#get_attachment_list) | **GET** /attachment | získá seznam příloh
*AttachmentsApi* | [**get_attachment_list_container**](docs/AttachmentsApi.md#get_attachment_list_container) | **GET** /atachment/container/{container} | vrací seznam příloh v kontejneru
*AttachmentsApi* | [**get_attachment_list_document**](docs/AttachmentsApi.md#get_attachment_list_document) | **GET** /atachment/document/{document} | vrací seznam příloh v dokumentu
*AttachmentsApi* | [**get_attachment_metadata**](docs/AttachmentsApi.md#get_attachment_metadata) | **GET** /attachment/{identifier} | vrací metadata přílohy
*AttachmentsApi* | [**post_attachment**](docs/AttachmentsApi.md#post_attachment) | **POST** /attachment | uploaduje novou přílohu (Crud)
*AttachmentsApi* | [**put_attachment**](docs/AttachmentsApi.md#put_attachment) | **PUT** /attachment/{identifier} | aktualizuje metadata přílohy
*DevelopersApi* | [**info_api**](docs/DevelopersApi.md#info_api) | **GET** /info | vrací servisní informace
*PublicApi* | [**delete_budget_category**](docs/PublicApi.md#delete_budget_category) | **DELETE** /budget_category/{identifier} | odstraní položku rozpočtového zařazení s daným identifikátorem (cruD)
*PublicApi* | [**delete_container**](docs/PublicApi.md#delete_container) | **DELETE** /container/{identifier} | odstraní dokumentový kontejner s daným identifikátorem (cruD)
*PublicApi* | [**delete_cover**](docs/PublicApi.md#delete_cover) | **DELETE** /cover/{identifier} | odstraní krycí list s daným identifikátorem (cruD)
*PublicApi* | [**delete_payment_event**](docs/PublicApi.md#delete_payment_event) | **DELETE** /payment_event/{identifier} | odstraní položku platebního kalenáře s daným identifikátorem (cruD)
*PublicApi* | [**delete_registration**](docs/PublicApi.md#delete_registration) | **DELETE** /registration/{identifier} | odstraní evidenční list s daným identifikátorem (cruD)
*PublicApi* | [**delete_standpoint**](docs/PublicApi.md#delete_standpoint) | **DELETE** /standpoint/{identifier} | odstraní stanovisko s daným identifikátorem (cruD)
*PublicApi* | [**get_budget_category**](docs/PublicApi.md#get_budget_category) | **GET** /budget_category/{identifier} | vrací položku rozpočtového zařazení s daným identifikátorem (cRud)
*PublicApi* | [**get_budget_category_list**](docs/PublicApi.md#get_budget_category_list) | **GET** /budget_category | vrací seznam rozpočtových zařazení
*PublicApi* | [**get_budget_category_list_by_dept**](docs/PublicApi.md#get_budget_category_list_by_dept) | **GET** /budget_category/dept/{dept} | vrací všechna rozpočtová opatření pro útvar
*PublicApi* | [**get_container**](docs/PublicApi.md#get_container) | **GET** /container/{identifier} | vrací dokumentový kontejner s daným identifikátorem (cRud)
*PublicApi* | [**get_container_content**](docs/PublicApi.md#get_container_content) | **GET** /container/items/{identifier} | vrací obsah kontejneru s daným identifikátorem
*PublicApi* | [**get_container_list**](docs/PublicApi.md#get_container_list) | **GET** /container | vrací seznam dokumentových kontejnerů
*PublicApi* | [**get_cover**](docs/PublicApi.md#get_cover) | **GET** /cover/{identifier} | vrací krycí list s daným identifikátorem (cRud)
*PublicApi* | [**get_cover_list**](docs/PublicApi.md#get_cover_list) | **GET** /cover | vrací seznam kycích listů
*PublicApi* | [**get_cover_list_container**](docs/PublicApi.md#get_cover_list_container) | **GET** /cover/container/{container} | vrací seznam kycích listů v kontejneru
*PublicApi* | [**get_payment_event**](docs/PublicApi.md#get_payment_event) | **GET** /payment_event/{identifier} | vrací položku platebního kalenáře s daným identifikátorem (cRud)
*PublicApi* | [**get_payment_event_list**](docs/PublicApi.md#get_payment_event_list) | **GET** /payment_event | vrací seznam položek platebního kalendáře
*PublicApi* | [**get_payment_event_list_parent**](docs/PublicApi.md#get_payment_event_list_parent) | **GET** /payment_event/parent/{parent} | vrací seznam položek platebního kalendáře pro nadřazený dokument
*PublicApi* | [**get_registration**](docs/PublicApi.md#get_registration) | **GET** /registration/{identifier} | vrací evidenční list s daným identifikátorem (cRud)
*PublicApi* | [**get_registration_list**](docs/PublicApi.md#get_registration_list) | **GET** /registration | vrací seznam registračních listů
*PublicApi* | [**get_registration_list_container**](docs/PublicApi.md#get_registration_list_container) | **GET** /registration/container/{container} | vrací seznam registračních listů v kontejneru
*PublicApi* | [**get_standpoint**](docs/PublicApi.md#get_standpoint) | **GET** /standpoint/{identifier} | vrací stanovisko s daným identifikátorem (cRud)
*PublicApi* | [**get_standpoint_list**](docs/PublicApi.md#get_standpoint_list) | **GET** /standpoint | vrací seznam stanovisek
*PublicApi* | [**get_standpoint_list_container**](docs/PublicApi.md#get_standpoint_list_container) | **GET** /standpoint/container/{container} | vrací seznam stanovisek v kontejneru
*PublicApi* | [**get_standpoint_list_parent**](docs/PublicApi.md#get_standpoint_list_parent) | **GET** /standpoint/parent/{parent} | vrací seznam stanovisek pro nadřízený dokument
*PublicApi* | [**post_budget_category**](docs/PublicApi.md#post_budget_category) | **POST** /budget_category | vytvoří novou položku rozpočtového zařazení (Crud)
*PublicApi* | [**post_container**](docs/PublicApi.md#post_container) | **POST** /container | vytvoří nový dokumentový kontejner (Crud)
*PublicApi* | [**post_cover**](docs/PublicApi.md#post_cover) | **POST** /cover | vytvoří nový krycí list (Crud)
*PublicApi* | [**post_payment_event**](docs/PublicApi.md#post_payment_event) | **POST** /payment_event | vytvoří novou položku platebního kalendáře (Crud)
*PublicApi* | [**post_registration**](docs/PublicApi.md#post_registration) | **POST** /registration | vytvoří nový evidenční list (Crud)
*PublicApi* | [**post_standpoint**](docs/PublicApi.md#post_standpoint) | **POST** /standpoint | vytvoří nové stanovisko (Crud)
*PublicApi* | [**put_budget_category**](docs/PublicApi.md#put_budget_category) | **PUT** /budget_category/{identifier} | aktualizuje položku rozpočtového zařazení s daným identifikátorem (crUd)
*PublicApi* | [**put_container**](docs/PublicApi.md#put_container) | **PUT** /container/{identifier} | aktualizuje dokumentový kontejner s daným identifikátorem (crUd)
*PublicApi* | [**put_cover**](docs/PublicApi.md#put_cover) | **PUT** /cover/{identifier} | aktualizuje krycí list s daným identifikátorem (crUd)
*PublicApi* | [**put_payment_event**](docs/PublicApi.md#put_payment_event) | **PUT** /payment_event/{identifier} | aktualizuje položku platebního kalenáře s daným identifikátorem (crUd)
*PublicApi* | [**put_registration**](docs/PublicApi.md#put_registration) | **PUT** /registration/{identifier} | aktualizuje evidenční list s daným identifikátorem (crUd)
*PublicApi* | [**put_standpoint**](docs/PublicApi.md#put_standpoint) | **PUT** /standpoint/{identifier} | aktualizuje stanovisko s daným identifikátorem (crUd)

## Documentation For Models

 - [Address](docs/Address.md)
 - [BaseDominoDocument](docs/BaseDominoDocument.md)
 - [BaseSheetDocument](docs/BaseSheetDocument.md)
 - [BudgetCategory](docs/BudgetCategory.md)
 - [Choice](docs/Choice.md)
 - [Company](docs/Company.md)
 - [ConfigBody](docs/ConfigBody.md)
 - [Container](docs/Container.md)
 - [CoverSheet](docs/CoverSheet.md)
 - [DocumentAcl](docs/DocumentAcl.md)
 - [DocumentAttachment](docs/DocumentAttachment.md)
 - [DocumentAttachmentEntry](docs/DocumentAttachmentEntry.md)
 - [DocumentAttachmentList](docs/DocumentAttachmentList.md)
 - [DocumentEntry](docs/DocumentEntry.md)
 - [DocumentEntryList](docs/DocumentEntryList.md)
 - [DocumentHeader](docs/DocumentHeader.md)
 - [DocumentHidden](docs/DocumentHidden.md)
 - [DocumentWorkflow](docs/DocumentWorkflow.md)
 - [DominoCommons](docs/DominoCommons.md)
 - [GeneralAcl](docs/GeneralAcl.md)
 - [PaymentEvent](docs/PaymentEvent.md)
 - [ProfileDirectory](docs/ProfileDirectory.md)
 - [ProfileMain](docs/ProfileMain.md)
 - [ProfileRoles](docs/ProfileRoles.md)
 - [RegistrationSheet](docs/RegistrationSheet.md)
 - [ReplaceName](docs/ReplaceName.md)
 - [Standpoint](docs/Standpoint.md)

## Documentation For Authorization


## apiKey

- **Type**: API key
- **API key parameter name**: X-API-KEY
- **Location**: HTTP header


## Author

info@sysnet.cz
