from distutils.core import setup
setup(
  name = 'athec',
  packages = ['athec'],
  version = '0.1',
  license='MIT',
  description = 'Computational aesthetic analysis of visual media in social science research',
  author = 'Yilang Peng',
  author_email = 'yilang.peng@uga.edu',
  url = 'https://github.com/yilangpeng/Athec',
  download_url = 'https://github.com/yilangpeng/Athec/archive/refs/tags/0.1.tar.gz',
  keywords = ['computer vision','computational aesthetics','image'],
  install_requires=[
          'validators',
          'beautifulsoup4',
          'numpy',
          'Pillow',
          'matplotlib',
          'opencv-contrib',
          'scipy',
          'scikit-image',
          'pyemd'],
  classifiers=['Development Status :: 3 - Alpha',
    'Intended Audience :: Science/Research',
    'Topic :: Scientific/Engineering :: Image Processing',
    'License :: OSI Approved :: MIT License',
    'Programming Language :: Python :: 3.9',
  ],
)