## -*- coding: utf-8 -*-
<%doc>

camcops_server/templates/menu/view_email.mako

===============================================================================

    Copyright (C) 2012-2020 Rudolf Cardinal (rudolf@pobox.com).

    This file is part of CamCOPS.

    CamCOPS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    CamCOPS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with CamCOPS. If not, see <http://www.gnu.org/licenses/>.

===============================================================================

</%doc>

<%inherit file="base_web.mako"/>

<%!
from markupsafe import escape
from camcops_server.cc_modules.cc_pyramid import Routes, ViewArg, ViewParam
%>

<%include file="db_user_info.mako"/>

<h1>${_("View e-mail generated by CamCOPS")}</h1>

<table>
    <tr>
        <th>Email ID</th>
        <td>${ email.id }</td>
    </tr>
    <tr>
        <th>Created at (UTC)</th>
        <td>${ email.created_at_utc }</td>
    </tr>

    <!-- Headers -->
    <tr>
        <th>Date</th>
        <td>${ email.date }</td>
    </tr>
    <tr>
        <th>From</th>
        <td>${ email.from_addr or "" | h }</td>
    </tr>
    <tr>
        <th>Reply-to</th>
        <td>${ email.reply_to or "" | h }</td>
    </tr>
    <tr>
        <th>To</th>
        <td>${ email.to or "" | h }</td>
    </tr>
    <tr>
        <th>CC</th>
        <td>${ email.cc or "" | h }</td>
    </tr>
    <tr>
        <th>BCC</th>
        <td>${ email.bcc or "" | h }</td>
    </tr>
    <tr>
        <th>Subject</th>
        <td>${ email.subject or "" | h }</td>
    </tr>

    <!-- Body, message -->
    <tr>
        <th>Body</th>
        <td><pre>${ email.body or "" | h }</pre></td>
    </tr>
    <tr>
        <th>Content type</th>
        <td>${ email.content_type or "" | h }</td>
    </tr>
    <tr>
        <th>Character set</th>
        <td>${ email.charset or "" | h }</td>
    </tr>
    <tr>
        <th>Message as a string (if saved)</th>
        <td><pre>${ email.msg_string or "" | h }</pre></td>
    </tr>

    <!-- Server -->
    <tr>
        <th>Host</th>
        <td>${ email.host or "" | h }</td>
    </tr>
    <tr>
        <th>Port</th>
        <td>${ email.port or "" | h }</td>
    </tr>
    <tr>
        <th>Username</th>
        <td>${ email.username or "" | h }</td>
    </tr>
    <tr>
        <th>Use TLS?</th>
        <td>${ email.use_tls | h }</td>
    </tr>

    <!-- Status -->
    <tr>
        <th>Sent?</th>
        <td>${ email.sent | h }</td>
    </tr>
    <tr>
        <th>Sent at (UTC)</th>
        <td>${ email.sent_at_utc }</td>
    </tr>
    <tr>
        <th>Reasons sending failed</th>
        <td>${ email.sending_failure_reason or "" | h }</td>
    </tr>

</table>

<%include file="to_main_menu.mako"/>
