#!/usr/bin/env python

"""
camcops_server/alembic/versions/0002_cisr_2018_01_29.py

===============================================================================

    Copyright (C) 2012-2020 Rudolf Cardinal (rudolf@pobox.com).

    This file is part of CamCOPS.

    CamCOPS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    CamCOPS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with CamCOPS. If not, see <http://www.gnu.org/licenses/>.

===============================================================================

CISR 2018-01-29
Revision ID: 0002
Revises: 0001
Creation date: 2018-01-29 20:31:56.440656
DATABASE REVISION SCRIPT
"""

# =============================================================================
# Imports
# =============================================================================

from alembic import op
import sqlalchemy as sa
# import cardinal_pythonlib.sqlalchemy.list_types
import camcops_server.cc_modules.cc_sqla_coltypes


# =============================================================================
# Revision identifiers, used by Alembic.
# =============================================================================

revision = '0002'
down_revision = '0001'
branch_labels = None
depends_on = None


# =============================================================================
# The upgrade/downgrade steps
# =============================================================================

# noinspection PyPep8,PyTypeChecker
def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('cisr',
        sa.Column('appetite1', sa.Integer(), nullable=True),
        sa.Column('weight1', sa.Integer(), nullable=True),
        sa.Column('weight2', sa.Integer(), nullable=True),
        sa.Column('weight3', sa.Integer(), nullable=True),
        sa.Column('appetite2', sa.Integer(), nullable=True),
        sa.Column('weight4', sa.Integer(), nullable=True),
        sa.Column('weight5', sa.Integer(), nullable=True),
        sa.Column('gp_year', sa.Integer(), nullable=True),
        sa.Column('disable', sa.Integer(), nullable=True),
        sa.Column('illness', sa.Integer(), nullable=True),
        sa.Column('somatic_mand1', sa.Integer(), nullable=True),
        sa.Column('somatic_pain1', sa.Integer(), nullable=True),
        sa.Column('somatic_pain2', sa.Integer(), nullable=True),
        sa.Column('somatic_pain3', sa.Integer(), nullable=True),
        sa.Column('somatic_pain4', sa.Integer(), nullable=True),
        sa.Column('somatic_pain5', sa.Integer(), nullable=True),
        sa.Column('somatic_mand2', sa.Integer(), nullable=True),
        sa.Column('somatic_dis1', sa.Integer(), nullable=True),
        sa.Column('somatic_dis2', sa.Integer(), nullable=True),
        sa.Column('somatic_dis3', sa.Integer(), nullable=True),
        sa.Column('somatic_dis4', sa.Integer(), nullable=True),
        sa.Column('somatic_dis5', sa.Integer(), nullable=True),
        sa.Column('somatic_dur', sa.Integer(), nullable=True),
        sa.Column('fatigue_mand1', sa.Integer(), nullable=True),
        sa.Column('fatigue_cause1', sa.Integer(), nullable=True),
        sa.Column('fatigue_tired1', sa.Integer(), nullable=True),
        sa.Column('fatigue_tired2', sa.Integer(), nullable=True),
        sa.Column('fatigue_tired3', sa.Integer(), nullable=True),
        sa.Column('fatigue_tired4', sa.Integer(), nullable=True),
        sa.Column('fatigue_mand2', sa.Integer(), nullable=True),
        sa.Column('fatigue_cause2', sa.Integer(), nullable=True),
        sa.Column('fatigue_energy1', sa.Integer(), nullable=True),
        sa.Column('fatigue_energy2', sa.Integer(), nullable=True),
        sa.Column('fatigue_energy3', sa.Integer(), nullable=True),
        sa.Column('fatigue_energy4', sa.Integer(), nullable=True),
        sa.Column('fatigue_dur', sa.Integer(), nullable=True),
        sa.Column('conc_mand1', sa.Integer(), nullable=True),
        sa.Column('conc_mand2', sa.Integer(), nullable=True),
        sa.Column('conc1', sa.Integer(), nullable=True),
        sa.Column('conc2', sa.Integer(), nullable=True),
        sa.Column('conc3', sa.Integer(), nullable=True),
        sa.Column('conc_dur', sa.Integer(), nullable=True),
        sa.Column('conc4', sa.Integer(), nullable=True),
        sa.Column('forget_dur', sa.Integer(), nullable=True),
        sa.Column('sleep_mand1', sa.Integer(), nullable=True),
        sa.Column('sleep_lose1', sa.Integer(), nullable=True),
        sa.Column('sleep_lose2', sa.Integer(), nullable=True),
        sa.Column('sleep_lose3', sa.Integer(), nullable=True),
        sa.Column('sleep_emw', sa.Integer(), nullable=True),
        sa.Column('sleep_cause', sa.Integer(), nullable=True),
        sa.Column('sleep_mand2', sa.Integer(), nullable=True),
        sa.Column('sleep_gain1', sa.Integer(), nullable=True),
        sa.Column('sleep_gain2', sa.Integer(), nullable=True),
        sa.Column('sleep_gain3', sa.Integer(), nullable=True),
        sa.Column('sleep_dur', sa.Integer(), nullable=True),
        sa.Column('irrit_mand1', sa.Integer(), nullable=True),
        sa.Column('irrit_mand2', sa.Integer(), nullable=True),
        sa.Column('irrit1', sa.Integer(), nullable=True),
        sa.Column('irrit2', sa.Integer(), nullable=True),
        sa.Column('irrit3', sa.Integer(), nullable=True),
        sa.Column('irrit4', sa.Integer(), nullable=True),
        sa.Column('irrit_dur', sa.Integer(), nullable=True),
        sa.Column('hypo_mand1', sa.Integer(), nullable=True),
        sa.Column('hypo_mand2', sa.Integer(), nullable=True),
        sa.Column('hypo1', sa.Integer(), nullable=True),
        sa.Column('hypo2', sa.Integer(), nullable=True),
        sa.Column('hypo3', sa.Integer(), nullable=True),
        sa.Column('hypo4', sa.Integer(), nullable=True),
        sa.Column('hypo_dur', sa.Integer(), nullable=True),
        sa.Column('depr_mand1', sa.Integer(), nullable=True),
        sa.Column('depr1', sa.Integer(), nullable=True),
        sa.Column('depr_mand2', sa.Integer(), nullable=True),
        sa.Column('depr2', sa.Integer(), nullable=True),
        sa.Column('depr3', sa.Integer(), nullable=True),
        sa.Column('depr4', sa.Integer(), nullable=True),
        sa.Column('depr_content', sa.Integer(), nullable=True),
        sa.Column('depr5', sa.Integer(), nullable=True),
        sa.Column('depr_dur', sa.Integer(), nullable=True),
        sa.Column('depth1', sa.Integer(), nullable=True),
        sa.Column('depth2', sa.Integer(), nullable=True),
        sa.Column('depth3', sa.Integer(), nullable=True),
        sa.Column('depth4', sa.Integer(), nullable=True),
        sa.Column('depth5', sa.Integer(), nullable=True),
        sa.Column('depth6', sa.Integer(), nullable=True),
        sa.Column('depth7', sa.Integer(), nullable=True),
        sa.Column('depth8', sa.Integer(), nullable=True),
        sa.Column('depth9', sa.Integer(), nullable=True),
        sa.Column('depth10', sa.Integer(), nullable=True),
        sa.Column('doctor', sa.Integer(), nullable=True),
        sa.Column('worry_mand1', sa.Integer(), nullable=True),
        sa.Column('worry_mand2', sa.Integer(), nullable=True),
        sa.Column('worry_cont1', sa.Integer(), nullable=True),
        sa.Column('worry2', sa.Integer(), nullable=True),
        sa.Column('worry3', sa.Integer(), nullable=True),
        sa.Column('worry4', sa.Integer(), nullable=True),
        sa.Column('worry5', sa.Integer(), nullable=True),
        sa.Column('worry_dur', sa.Integer(), nullable=True),
        sa.Column('anx_mand1', sa.Integer(), nullable=True),
        sa.Column('anx_mand2', sa.Integer(), nullable=True),
        sa.Column('anx_phobia1', sa.Integer(), nullable=True),
        sa.Column('anx_phobia2', sa.Integer(), nullable=True),
        sa.Column('anx2', sa.Integer(), nullable=True),
        sa.Column('anx3', sa.Integer(), nullable=True),
        sa.Column('anx4', sa.Integer(), nullable=True),
        sa.Column('anx5', sa.Integer(), nullable=True),
        sa.Column('anx_dur', sa.Integer(), nullable=True),
        sa.Column('phobias_mand', sa.Integer(), nullable=True),
        sa.Column('phobias_type1', sa.Integer(), nullable=True),
        sa.Column('phobias1', sa.Integer(), nullable=True),
        sa.Column('phobias2', sa.Integer(), nullable=True),
        sa.Column('phobias3', sa.Integer(), nullable=True),
        sa.Column('phobias4', sa.Integer(), nullable=True),
        sa.Column('phobias_dur', sa.Integer(), nullable=True),
        sa.Column('panic_mand', sa.Integer(), nullable=True),
        sa.Column('panic1', sa.Integer(), nullable=True),
        sa.Column('panic2', sa.Integer(), nullable=True),
        sa.Column('panic3', sa.Integer(), nullable=True),
        sa.Column('panic4', sa.Integer(), nullable=True),
        sa.Column('pansym_a', sa.Integer(), nullable=True),
        sa.Column('pansym_b', sa.Integer(), nullable=True),
        sa.Column('pansym_c', sa.Integer(), nullable=True),
        sa.Column('pansym_d', sa.Integer(), nullable=True),
        sa.Column('pansym_e', sa.Integer(), nullable=True),
        sa.Column('pansym_f', sa.Integer(), nullable=True),
        sa.Column('pansym_g', sa.Integer(), nullable=True),
        sa.Column('pansym_h', sa.Integer(), nullable=True),
        sa.Column('pansym_i', sa.Integer(), nullable=True),
        sa.Column('pansym_j', sa.Integer(), nullable=True),
        sa.Column('pansym_k', sa.Integer(), nullable=True),
        sa.Column('pansym_l', sa.Integer(), nullable=True),
        sa.Column('pansym_m', sa.Integer(), nullable=True),
        sa.Column('panic5', sa.Integer(), nullable=True),
        sa.Column('panic_dur', sa.Integer(), nullable=True),
        sa.Column('comp_mand1', sa.Integer(), nullable=True),
        sa.Column('comp1', sa.Integer(), nullable=True),
        sa.Column('comp2', sa.Integer(), nullable=True),
        sa.Column('comp3', sa.Integer(), nullable=True),
        sa.Column('comp4', sa.Integer(), nullable=True),
        sa.Column('comp_dur', sa.Integer(), nullable=True),
        sa.Column('obsess_mand1', sa.Integer(), nullable=True),
        sa.Column('obsess_mand2', sa.Integer(), nullable=True),
        sa.Column('obsess1', sa.Integer(), nullable=True),
        sa.Column('obsess2', sa.Integer(), nullable=True),
        sa.Column('obsess3', sa.Integer(), nullable=True),
        sa.Column('obsess4', sa.Integer(), nullable=True),
        sa.Column('obsess_dur', sa.Integer(), nullable=True),
        sa.Column('overall2', sa.Integer(), nullable=True),
        sa.Column('patient_id', sa.Integer(), nullable=False),
        sa.Column('firstexit_is_abort', sa.Boolean(), nullable=True),
        sa.Column('firstexit_is_finish', sa.Boolean(), nullable=True),
        sa.Column('when_created', camcops_server.cc_modules.cc_sqla_coltypes.PendulumDateTimeAsIsoTextColType(length=32), nullable=False),
        sa.Column('when_firstexit', camcops_server.cc_modules.cc_sqla_coltypes.PendulumDateTimeAsIsoTextColType(length=32), nullable=True),
        sa.Column('editing_time_s', sa.Float(), nullable=True),
        sa.Column('_predecessor_pk', sa.Integer(), nullable=True),
        sa.Column('_successor_pk', sa.Integer(), nullable=True),
        sa.Column('_device_id', sa.Integer(), nullable=False),
        sa.Column('_when_added_batch_utc', sa.DateTime(), nullable=True),
        sa.Column('_era', sa.String(length=32), nullable=False),
        sa.Column('_camcops_version', camcops_server.cc_modules.cc_sqla_coltypes.SemanticVersionColType(length=147), nullable=True),
        sa.Column('_removing_user_id', sa.Integer(), nullable=True),
        sa.Column('_when_removed_exact', camcops_server.cc_modules.cc_sqla_coltypes.PendulumDateTimeAsIsoTextColType(length=32), nullable=True),
        sa.Column('_pk', sa.Integer(), nullable=False),
        sa.Column('_preserving_user_id', sa.Integer(), nullable=True),
        sa.Column('_removal_pending', sa.Boolean(), nullable=True),
        sa.Column('when_last_modified', camcops_server.cc_modules.cc_sqla_coltypes.PendulumDateTimeAsIsoTextColType(length=32), nullable=True),
        sa.Column('_group_id', sa.Integer(), nullable=False),
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('_when_added_exact', camcops_server.cc_modules.cc_sqla_coltypes.PendulumDateTimeAsIsoTextColType(length=32), nullable=True),
        sa.Column('_manually_erasing_user_id', sa.Integer(), nullable=True),
        sa.Column('_when_removed_batch_utc', sa.DateTime(), nullable=True),
        sa.Column('_move_off_tablet', sa.Boolean(), nullable=True),
        sa.Column('_manually_erased_at', camcops_server.cc_modules.cc_sqla_coltypes.PendulumDateTimeAsIsoTextColType(length=32), nullable=True),
        sa.Column('_addition_pending', sa.Boolean(), nullable=False),
        sa.Column('_adding_user_id', sa.Integer(), nullable=True),
        sa.Column('_current', sa.Boolean(), nullable=False),
        sa.Column('_manually_erased', sa.Boolean(), nullable=True),
        sa.Column('_forcibly_preserved', sa.Boolean(), nullable=True),
        sa.ForeignKeyConstraint(['_adding_user_id'], ['_security_users.id'], name=op.f('fk_cisr__adding_user_id')),
        sa.ForeignKeyConstraint(['_device_id'], ['_security_devices.id'], name=op.f('fk_cisr__device_id')),
        sa.ForeignKeyConstraint(['_group_id'], ['_security_groups.id'], name=op.f('fk_cisr__group_id')),
        sa.ForeignKeyConstraint(['_manually_erasing_user_id'], ['_security_users.id'], name=op.f('fk_cisr__manually_erasing_user_id')),
        sa.ForeignKeyConstraint(['_preserving_user_id'], ['_security_users.id'], name=op.f('fk_cisr__preserving_user_id')),
        sa.ForeignKeyConstraint(['_removing_user_id'], ['_security_users.id'], name=op.f('fk_cisr__removing_user_id')),
        sa.PrimaryKeyConstraint('_pk', name=op.f('pk_cisr')),
        # mysql_charset='utf8mb4',
        # mysql_collate='utf8mb4_unicode_ci',
        mysql_charset='utf8mb4 COLLATE utf8mb4_unicode_ci',
        mysql_engine='InnoDB',
        mysql_row_format='DYNAMIC'
    )
    with op.batch_alter_table('cisr', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_cisr__current'), ['_current'], unique=False)
        batch_op.create_index(batch_op.f('ix_cisr__device_id'), ['_device_id'], unique=False)
        batch_op.create_index(batch_op.f('ix_cisr__era'), ['_era'], unique=False)
        batch_op.create_index(batch_op.f('ix_cisr__group_id'), ['_group_id'], unique=False)
        batch_op.create_index(batch_op.f('ix_cisr__pk'), ['_pk'], unique=False)
        batch_op.create_index(batch_op.f('ix_cisr_id'), ['id'], unique=False)
        batch_op.create_index(batch_op.f('ix_cisr_patient_id'), ['patient_id'], unique=False)
        batch_op.create_index(batch_op.f('ix_cisr_when_last_modified'), ['when_last_modified'], unique=False)

    # ### end Alembic commands ###


# noinspection PyPep8
def downgrade():
    op.drop_table('cisr')
