"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pass = exports.Result = void 0;
const chain_1 = require("../chain");
const fields_1 = require("../fields");
const state_type_1 = require("./private/state-type");
const state_1 = require("./state");
/**
 * The result of a Pass operation
 */
class Result {
    /**
     *
     * @param value result of the Pass operation
     */
    constructor(value) {
        this.value = value;
    }
    /**
     * The result of the operation is a string
     */
    static fromString(value) {
        return new Result(value);
    }
    /**
     * The result of the operation is a number
     */
    static fromNumber(value) {
        return new Result(value);
    }
    /**
     * The result of the operation is a boolean
     */
    static fromBoolean(value) {
        return new Result(value);
    }
    /**
     * The result of the operation is an object
     */
    static fromObject(value) {
        return new Result(value);
    }
    /**
     * The result of the operation is an array
     */
    static fromArray(value) {
        return new Result(value);
    }
}
exports.Result = Result;
/**
 * Define a Pass in the state machine
 *
 * A Pass state can be used to transform the current exeuction's state.
 */
class Pass extends state_1.State {
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        this.result = props.result;
        this.endStates = [this];
    }
    /**
     * Continue normal execution with the given state
     */
    next(next) {
        super.makeNext(next.startState);
        return chain_1.Chain.sequence(this, next);
    }
    /**
     * Return the Amazon States Language object for this state
     */
    toStateJson() {
        return {
            Type: state_type_1.StateType.PASS,
            Comment: this.comment,
            Result: this.result ? this.result.value : undefined,
            ResultPath: state_1.renderJsonPath(this.resultPath),
            ...this.renderInputOutput(),
            ...this.renderParameters(),
            ...this.renderNextEnd(),
        };
    }
    /**
     * Render Parameters in ASL JSON format
     */
    renderParameters() {
        return fields_1.FieldUtils.renderObject({
            Parameters: this.parameters,
        });
    }
}
exports.Pass = Pass;
//# sourceMappingURL=data:application/json;base64,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