"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeActivity = void 0;
/**
 * A Step Functions Task to invoke an Activity worker.
 *
 * An Activity can be used directly as a Resource.
 */
class InvokeActivity {
    constructor(activity, props = {}) {
        this.activity = activity;
        this.props = props;
    }
    bind(_task) {
        return {
            resourceArn: this.activity.activityArn,
            metricDimensions: { ActivityArn: this.activity.activityArn },
            heartbeat: this.props.heartbeat,
            // No IAM permissions necessary, execution role implicitly has Activity permissions.
            metricPrefixSingular: 'Activity',
            metricPrefixPlural: 'Activities',
        };
    }
}
exports.InvokeActivity = InvokeActivity;
//# sourceMappingURL=data:application/json;base64,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