"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EvaluateExpression = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const lambda = require("../../aws-lambda"); // Automatically re-written from '@aws-cdk/aws-lambda'
const sfn = require("../../aws-stepfunctions"); // Automatically re-written from '@aws-cdk/aws-stepfunctions'
const path = require("path");
/**
 * A Step Functions Task to evaluate an expression
 *
 * OUTPUT: the output of this task is the evaluated expression.
 *
 * @experimental
 */
class EvaluateExpression {
    constructor(props) {
        this.props = props;
    }
    bind(task) {
        const matches = this.props.expression.match(/\$[.\[][.a-zA-Z[\]0-9]+/g);
        let expressionAttributeValues = {};
        if (matches) {
            expressionAttributeValues = matches.reduce((acc, m) => ({
                ...acc,
                [m]: sfn.Data.stringAt(m),
            }), {});
        }
        const evalFn = createEvalFn(this.props.runtime || lambda.Runtime.NODEJS_10_X, task);
        const parameters = {
            expression: this.props.expression,
            expressionAttributeValues,
        };
        return {
            resourceArn: evalFn.functionArn,
            policyStatements: [new iam.PolicyStatement({
                    resources: [evalFn.functionArn],
                    actions: ['lambda:InvokeFunction'],
                })],
            parameters,
        };
    }
}
exports.EvaluateExpression = EvaluateExpression;
function createEvalFn(runtime, scope) {
    const code = lambda.Code.asset(path.join(__dirname, `eval-${runtime.name}-handler`));
    const lambdaPurpose = 'Eval';
    switch (runtime) {
        case lambda.Runtime.NODEJS_10_X:
            return new lambda.SingletonFunction(scope, 'EvalFunction', {
                runtime,
                handler: 'index.handler',
                uuid: 'a0d2ce44-871b-4e74-87a1-f5e63d7c3bdc',
                lambdaPurpose,
                code,
            });
        // TODO: implement other runtimes
        default:
            throw new Error(`The runtime ${runtime.name} is currently not supported.`);
    }
}
//# sourceMappingURL=data:application/json;base64,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