"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunEcsFargateTask = void 0;
const run_ecs_task_base_1 = require("./run-ecs-task-base");
/**
 * Start a service on an ECS cluster
 */
class RunEcsFargateTask extends run_ecs_task_base_1.EcsRunTaskBase {
    constructor(props) {
        if (!props.taskDefinition.isFargateCompatible) {
            throw new Error('Supplied TaskDefinition is not configured for compatibility with Fargate');
        }
        if (!props.taskDefinition.defaultContainer) {
            throw new Error('A TaskDefinition must have at least one essential container');
        }
        super({
            ...props,
            parameters: {
                LaunchType: 'FARGATE',
            },
        });
        this.configureAwsVpcNetworking(props.cluster.vpc, props.assignPublicIp, props.subnets, props.securityGroup);
    }
}
exports.RunEcsFargateTask = RunEcsFargateTask;
//# sourceMappingURL=data:application/json;base64,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