"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoUpdateItem = void 0;
const iam = require("../../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const sfn = require("../../../aws-stepfunctions"); // Automatically re-written from '@aws-cdk/aws-stepfunctions'
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const utils_1 = require("./private/utils");
/**
 * A StepFunctions task to call DynamoUpdateItem
 */
class DynamoUpdateItem extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: [
                    core_1.Stack.of(this).formatArn({
                        service: 'dynamodb',
                        resource: 'table',
                        resourceName: props.table.tableName,
                    }),
                ],
                actions: [`dynamodb:${utils_1.DynamoMethod.UPDATE}Item`],
            }),
        ];
    }
    renderTask() {
        return {
            Resource: utils_1.getDynamoResourceArn(utils_1.DynamoMethod.UPDATE),
            Parameters: sfn.FieldUtils.renderObject({
                Key: utils_1.transformAttributeValueMap(this.props.key),
                TableName: this.props.table.tableName,
                ConditionExpression: this.props.conditionExpression,
                ExpressionAttributeNames: this.props.expressionAttributeNames,
                ExpressionAttributeValues: utils_1.transformAttributeValueMap(this.props.expressionAttributeValues),
                ReturnConsumedCapacity: this.props.returnConsumedCapacity,
                ReturnItemCollectionMetrics: this.props.returnItemCollectionMetrics,
                ReturnValues: this.props.returnValues,
                UpdateExpression: this.props.updateExpression,
            }),
        };
    }
}
exports.DynamoUpdateItem = DynamoUpdateItem;
//# sourceMappingURL=data:application/json;base64,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