"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NonIpInstance = void 0;
const instance_1 = require("./instance");
const namespace_1 = require("./namespace");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Instance accessible using values other than an IP address or a domain name (CNAME).
 * Specify the other values in Custom attributes.
 *
 * @resource AWS::ServiceDiscovery::Instance
 */
class NonIpInstance extends instance_1.InstanceBase {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.service.namespace.type !== namespace_1.NamespaceType.HTTP) {
            throw new Error('This type of instance can only be registered for HTTP namespaces.');
        }
        if (props.customAttributes === undefined || Object.keys(props.customAttributes).length === 0) {
            throw new Error('You must specify at least one custom attribute for this instance type.');
        }
        const resource = new servicediscovery_generated_1.CfnInstance(this, 'Resource', {
            instanceId: props.instanceId || this.uniqueInstanceId(),
            serviceId: props.service.serviceId,
            instanceAttributes: {
                ...props.customAttributes,
            },
        });
        this.service = props.service;
        this.instanceId = resource.ref;
    }
}
exports.NonIpInstance = NonIpInstance;
//# sourceMappingURL=data:application/json;base64,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