import { IConstruct } from "../../core";
import { IPolicy } from './policy';
export declare function undefinedIfEmpty(f: () => string[]): string[];
/**
 * Used to generate a unique policy name based on the policy resource construct.
 * The logical ID of the resource is a great candidate as long as it doesn't exceed
 * 128 characters, so we take the last 128 characters (in order to make sure the hash
 * is there).
 */
export declare function generatePolicyName(scope: IConstruct, logicalId: string): string;
/**
 * Helper class that maintains the set of attached policies for a principal.
 */
export declare class AttachedPolicies {
    private policies;
    /**
     * Adds a policy to the list of attached policies.
     *
     * If this policy is already, attached, returns false.
     * If there is another policy attached with the same name, throws an exception.
     */
    attach(policy: IPolicy): void;
}
/**
 * Merge two dictionaries that represent IAM principals
 */
export declare function mergePrincipal(target: {
    [key: string]: string[];
}, source: {
    [key: string]: string[];
}): {
    [key: string]: string[];
};
