"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesResource = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Represents a resource within the Kubernetes system.
 *
 * Alternatively, you can use `cluster.addResource(resource[, resource, ...])`
 * to define resources on this cluster.
 *
 * Applies/deletes the resources using `kubectl` in sync with the resource.
 */
class KubernetesResource extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = props.cluster._kubectlProvider;
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: KubernetesResource.RESOURCE_TYPE,
            properties: {
                // `toJsonString` enables embedding CDK tokens in the manifest and will
                // render a CloudFormation-compatible JSON string (similar to
                // StepFunctions, CloudWatch Dashboards etc).
                Manifest: stack.toJsonString(props.manifest),
                ClusterName: props.cluster.clusterName,
                RoleArn: props.cluster._kubectlCreationRole.roleArn,
            },
        });
    }
}
exports.KubernetesResource = KubernetesResource;
/**
 * The CloudFormation reosurce type.
 */
KubernetesResource.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-KubernetesResource';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiazhzLXJlc291cmNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiazhzLXJlc291cmNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHFDQUE4RCxDQUFDLGdEQUFnRDtBQW1DL0c7Ozs7Ozs7R0FPRztBQUNILE1BQWEsa0JBQW1CLFNBQVEsZ0JBQVM7SUFLN0MsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE4QjtRQUNwRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLE1BQU0sS0FBSyxHQUFHLFlBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDN0IsTUFBTSxRQUFRLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQztRQUNoRCxJQUFJLHFCQUFjLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNqQyxZQUFZLEVBQUUsUUFBUSxDQUFDLFlBQVk7WUFDbkMsWUFBWSxFQUFFLGtCQUFrQixDQUFDLGFBQWE7WUFDOUMsVUFBVSxFQUFFO2dCQUNSLHVFQUF1RTtnQkFDdkUsNkRBQTZEO2dCQUM3RCw2Q0FBNkM7Z0JBQzdDLFFBQVEsRUFBRSxLQUFLLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUM7Z0JBQzVDLFdBQVcsRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLFdBQVc7Z0JBQ3RDLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLG9CQUFvQixDQUFDLE9BQU87YUFDdEQ7U0FDSixDQUFDLENBQUM7SUFDUCxDQUFDOztBQXJCTCxnREFzQkM7QUFyQkc7O0dBRUc7QUFDb0IsZ0NBQWEsR0FBRyx1Q0FBdUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCwgQ3VzdG9tUmVzb3VyY2UsIFN0YWNrIH0gZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG5pbXBvcnQgeyBDbHVzdGVyIH0gZnJvbSAnLi9jbHVzdGVyJztcbi8qKlxuICogUHJvcGVydGllcyBmb3IgS3ViZXJuZXRlc1Jlc291cmNlc1xuICovXG5leHBvcnQgaW50ZXJmYWNlIEt1YmVybmV0ZXNSZXNvdXJjZVByb3BzIHtcbiAgICAvKipcbiAgICAgKiBUaGUgRUtTIGNsdXN0ZXIgdG8gYXBwbHkgdGhpcyBjb25maWd1cmF0aW9uIHRvLlxuICAgICAqXG4gICAgICogW2Rpc2FibGUtYXdzbGludDpyZWYtdmlhLWludGVyZmFjZV1cbiAgICAgKi9cbiAgICByZWFkb25seSBjbHVzdGVyOiBDbHVzdGVyO1xuICAgIC8qKlxuICAgICAqIFRoZSByZXNvdXJjZSBtYW5pZmVzdC5cbiAgICAgKlxuICAgICAqIENvbnNpc3RzIG9mIGFueSBudW1iZXIgb2YgY2hpbGQgcmVzb3VyY2VzLlxuICAgICAqXG4gICAgICogV2hlbiB0aGUgcmVzb3VyY2UgaXMgY3JlYXRlZC91cGRhdGVkLCB0aGlzIG1hbmlmZXN0IHdpbGwgYmUgYXBwbGllZCB0byB0aGVcbiAgICAgKiBjbHVzdGVyIHRocm91Z2ggYGt1YmVjdGwgYXBwbHlgIGFuZCB3aGVuIHRoZSByZXNvdXJjZSBvciB0aGUgc3RhY2sgaXNcbiAgICAgKiBkZWxldGVkLCB0aGUgbWFuaWZlc3Qgd2lsbCBiZSBkZWxldGVkIHRocm91Z2ggYGt1YmVjdGwgZGVsZXRlYC5cbiAgICAgKlxuICAgICAqIEBleGFtcGxlXG4gICAgICpcbiAgICAgKiB7XG4gICAgICogICBhcGlWZXJzaW9uOiAndjEnLFxuICAgICAqICAga2luZDogJ1BvZCcsXG4gICAgICogICBtZXRhZGF0YTogeyBuYW1lOiAnbXlwb2QnIH0sXG4gICAgICogICBzcGVjOiB7XG4gICAgICogICAgIGNvbnRhaW5lcnM6IFsgeyBuYW1lOiAnaGVsbG8nLCBpbWFnZTogJ3BhdWxib3V3ZXIvaGVsbG8ta3ViZXJuZXRlczoxLjUnLCBwb3J0czogWyB7IGNvbnRhaW5lclBvcnQ6IDgwODAgfSBdIH0gXVxuICAgICAqICAgfVxuICAgICAqIH1cbiAgICAgKlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG1hbmlmZXN0OiBhbnlbXTtcbn1cbi8qKlxuICogUmVwcmVzZW50cyBhIHJlc291cmNlIHdpdGhpbiB0aGUgS3ViZXJuZXRlcyBzeXN0ZW0uXG4gKlxuICogQWx0ZXJuYXRpdmVseSwgeW91IGNhbiB1c2UgYGNsdXN0ZXIuYWRkUmVzb3VyY2UocmVzb3VyY2VbLCByZXNvdXJjZSwgLi4uXSlgXG4gKiB0byBkZWZpbmUgcmVzb3VyY2VzIG9uIHRoaXMgY2x1c3Rlci5cbiAqXG4gKiBBcHBsaWVzL2RlbGV0ZXMgdGhlIHJlc291cmNlcyB1c2luZyBga3ViZWN0bGAgaW4gc3luYyB3aXRoIHRoZSByZXNvdXJjZS5cbiAqL1xuZXhwb3J0IGNsYXNzIEt1YmVybmV0ZXNSZXNvdXJjZSBleHRlbmRzIENvbnN0cnVjdCB7XG4gICAgLyoqXG4gICAgICogVGhlIENsb3VkRm9ybWF0aW9uIHJlb3N1cmNlIHR5cGUuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBSRVNPVVJDRV9UWVBFID0gJ0N1c3RvbTo6QVdTQ0RLLUVLUy1LdWJlcm5ldGVzUmVzb3VyY2UnO1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBLdWJlcm5ldGVzUmVzb3VyY2VQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgICAgICBjb25zdCBzdGFjayA9IFN0YWNrLm9mKHRoaXMpO1xuICAgICAgICBjb25zdCBwcm92aWRlciA9IHByb3BzLmNsdXN0ZXIuX2t1YmVjdGxQcm92aWRlcjtcbiAgICAgICAgbmV3IEN1c3RvbVJlc291cmNlKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgICAgICAgIHNlcnZpY2VUb2tlbjogcHJvdmlkZXIuc2VydmljZVRva2VuLFxuICAgICAgICAgICAgcmVzb3VyY2VUeXBlOiBLdWJlcm5ldGVzUmVzb3VyY2UuUkVTT1VSQ0VfVFlQRSxcbiAgICAgICAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgICAgICAgICAvLyBgdG9Kc29uU3RyaW5nYCBlbmFibGVzIGVtYmVkZGluZyBDREsgdG9rZW5zIGluIHRoZSBtYW5pZmVzdCBhbmQgd2lsbFxuICAgICAgICAgICAgICAgIC8vIHJlbmRlciBhIENsb3VkRm9ybWF0aW9uLWNvbXBhdGlibGUgSlNPTiBzdHJpbmcgKHNpbWlsYXIgdG9cbiAgICAgICAgICAgICAgICAvLyBTdGVwRnVuY3Rpb25zLCBDbG91ZFdhdGNoIERhc2hib2FyZHMgZXRjKS5cbiAgICAgICAgICAgICAgICBNYW5pZmVzdDogc3RhY2sudG9Kc29uU3RyaW5nKHByb3BzLm1hbmlmZXN0KSxcbiAgICAgICAgICAgICAgICBDbHVzdGVyTmFtZTogcHJvcHMuY2x1c3Rlci5jbHVzdGVyTmFtZSxcbiAgICAgICAgICAgICAgICBSb2xlQXJuOiBwcm9wcy5jbHVzdGVyLl9rdWJlY3RsQ3JlYXRpb25Sb2xlLnJvbGVBcm4sXG4gICAgICAgICAgICB9LFxuICAgICAgICB9KTtcbiAgICB9XG59XG4iXX0=