"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceType = exports.InstanceSize = exports.InstanceClass = void 0;
/**
 * What class and generation of instance to use
 *
 * We have both symbolic and concrete enums for every type.
 *
 * The first are for people that want to specify by purpose,
 * the second one are for people who already know exactly what
 * 'R4' means.
 */
var InstanceClass;
(function (InstanceClass) {
    /**
     * Standard instances, 3rd generation
     */
    InstanceClass["STANDARD3"] = "m3";
    /**
     * Standard instances, 3rd generation
     */
    InstanceClass["M3"] = "m3";
    /**
     * Standard instances, 4th generation
     */
    InstanceClass["STANDARD4"] = "m4";
    /**
     * Standard instances, 4th generation
     */
    InstanceClass["M4"] = "m4";
    /**
     * Standard instances, 5th generation
     */
    InstanceClass["STANDARD5"] = "m5";
    /**
     * Standard instances, 5th generation
     */
    InstanceClass["M5"] = "m5";
    /**
     * Standard instances with local NVME drive, 5th generation
     */
    InstanceClass["STANDARD5_NVME_DRIVE"] = "m5d";
    /**
     * Standard instances with local NVME drive, 5th generation
     */
    InstanceClass["M5D"] = "m5d";
    /**
     * Standard instances based on AMD EPYC, 5th generation
     */
    InstanceClass["STANDARD5_AMD"] = "m5a";
    /**
     * Standard instances based on AMD EPYC, 5th generation
     */
    InstanceClass["M5A"] = "m5a";
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["STANDARD5_AMD_NVME_DRIVE"] = "m5ad";
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["M5AD"] = "m5ad";
    /**
     * Memory optimized instances, 3rd generation
     */
    InstanceClass["MEMORY3"] = "r3";
    /**
     * Memory optimized instances, 3rd generation
     */
    InstanceClass["R3"] = "r3";
    /**
     * Memory optimized instances, 4th generation
     */
    InstanceClass["MEMORY4"] = "r4";
    /**
     * Memory optimized instances, 4th generation
     */
    InstanceClass["R4"] = "r4";
    /**
     * Memory optimized instances, 5th generation
     */
    InstanceClass["MEMORY5"] = "r5";
    /**
     * Memory optimized instances, 5th generation
     */
    InstanceClass["R5"] = "r5";
    /**
     * Memory optimized instances for high performance computing, 5th generation
     */
    InstanceClass["MEMORY5_HIGH_PERFORMANCE"] = "r5n";
    /**
     * Memory optimized instances for high performance computing, 5th generation
     */
    InstanceClass["R5N"] = "r5n";
    /**
     * Memory optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["MEMORY5_NVME_DRIVE"] = "r5d";
    /**
     * Memory optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["R5D"] = "r5d";
    /**
     * Memory optimized instances with local NVME drive for high performance computing, 5th generation
     */
    InstanceClass["MEMORY5_NVME_DRIVE_HIGH_PERFORMANCE"] = "r5dn";
    /**
     * Memory optimized instances with local NVME drive for high performance computing, 5th generation
     */
    InstanceClass["R5DN"] = "r5dn";
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["MEMORY5_AMD"] = "r5a";
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["R5A"] = "r5a";
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["MEMORY5_AMD_NVME_DRIVE"] = "r5a";
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["R5AD"] = "r5a";
    /**
     * Compute optimized instances, 3rd generation
     */
    InstanceClass["COMPUTE3"] = "c3";
    /**
     * Compute optimized instances, 3rd generation
     */
    InstanceClass["C3"] = "c3";
    /**
     * Compute optimized instances, 4th generation
     */
    InstanceClass["COMPUTE4"] = "c4";
    /**
     * Compute optimized instances, 4th generation
     */
    InstanceClass["C4"] = "c4";
    /**
     * Compute optimized instances, 5th generation
     */
    InstanceClass["COMPUTE5"] = "c5";
    /**
     * Compute optimized instances, 5th generation
     */
    InstanceClass["C5"] = "c5";
    /**
     * Compute optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["COMPUTE5_NVME_DRIVE"] = "c5d";
    /**
     * Compute optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["C5D"] = "c5d";
    /**
     * Compute optimized instances for high performance computing, 5th generation
     */
    InstanceClass["COMPUTE5_HIGH_PERFORMANCE"] = "c5n";
    /**
     * Compute optimized instances for high performance computing, 5th generation
     */
    InstanceClass["C5N"] = "c5n";
    /**
     * Storage-optimized instances, 2nd generation
     */
    InstanceClass["STORAGE2"] = "d2";
    /**
     * Storage-optimized instances, 2nd generation
     */
    InstanceClass["D2"] = "d2";
    /**
     * Storage/compute balanced instances, 1st generation
     */
    InstanceClass["STORAGE_COMPUTE_1"] = "h1";
    /**
     * Storage/compute balanced instances, 1st generation
     */
    InstanceClass["H1"] = "h1";
    /**
     * I/O-optimized instances, 3rd generation
     */
    InstanceClass["IO3"] = "i3";
    /**
     * I/O-optimized instances, 3rd generation
     */
    InstanceClass["I3"] = "i3";
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation
     */
    InstanceClass["IO3_DENSE_NVME_DRIVE"] = "i3en";
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation
     */
    InstanceClass["I3EN"] = "i3en";
    /**
     * Burstable instances, 2nd generation
     */
    InstanceClass["BURSTABLE2"] = "t2";
    /**
     * Burstable instances, 2nd generation
     */
    InstanceClass["T2"] = "t2";
    /**
     * Burstable instances, 3rd generation
     */
    InstanceClass["BURSTABLE3"] = "t3";
    /**
     * Burstable instances, 3rd generation
     */
    InstanceClass["T3"] = "t3";
    /**
     * Burstable instances based on AMD EPYC, 3rd generation
     */
    InstanceClass["BURSTABLE3_AMD"] = "t3a";
    /**
     * Burstable instances based on AMD EPYC, 3rd generation
     */
    InstanceClass["T3A"] = "t3a";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["MEMORY_INTENSIVE_1"] = "x1";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["X1"] = "x1";
    /**
     * Memory-intensive instances, extended, 1st generation
     */
    InstanceClass["MEMORY_INTENSIVE_1_EXTENDED"] = "x1e";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["X1E"] = "x1e";
    /**
     * Instances with customizable hardware acceleration, 1st generation
     */
    InstanceClass["FPGA1"] = "f1";
    /**
     * Instances with customizable hardware acceleration, 1st generation
     */
    InstanceClass["F1"] = "f1";
    /**
     * Graphics-optimized instances, 3rd generation
     */
    InstanceClass["GRAPHICS3"] = "g3";
    /**
     * Graphics-optimized instances, 3rd generation
     */
    InstanceClass["G3"] = "g3";
    /**
     * Graphics-optimized instances with NVME drive for high performance computing, 4th generation
     */
    InstanceClass["GRAPHICS4_NVME_DRIVE_HIGH_PERFORMANCE"] = "g4dn";
    /**
     * Graphics-optimized instances with NVME drive for high performance computing, 4th generation
     */
    InstanceClass["G4DN"] = "g4dn";
    /**
     * Parallel-processing optimized instances, 2nd generation
     */
    InstanceClass["PARALLEL2"] = "p2";
    /**
     * Parallel-processing optimized instances, 2nd generation
     */
    InstanceClass["P2"] = "p2";
    /**
     * Parallel-processing optimized instances, 3nd generation
     */
    InstanceClass["PARALLEL3"] = "p3";
    /**
     * Parallel-processing optimized instances, 3nd generation
     */
    InstanceClass["P3"] = "p3";
    /**
     * Arm processor based instances, 1st generation
     */
    InstanceClass["ARM1"] = "a1";
    /**
     * Arm processor based instances, 1st generation
     */
    InstanceClass["A1"] = "a1";
    /**
     * Arm processor based instances, 2nd generation
     */
    InstanceClass["STANDARD6_GRAVITON"] = "m6g";
    /**
     * Arm processor based instances, 2nd generation
     */
    InstanceClass["M6G"] = "m6g";
    /**
     * High memory and compute capacity instances, 1st generation
     */
    InstanceClass["HIGH_COMPUTE_MEMORY1"] = "z1d";
    /**
     * High memory and compute capacity instances, 1st generation
     */
    InstanceClass["Z1D"] = "z1d";
    /**
     * Inferentia Chips based instances for machine learning inference applications, 1st generation
     */
    InstanceClass["INFERENCE1"] = "inf1";
    /**
     * Inferentia Chips based instances for machine learning inference applications, 1st generation
     */
    InstanceClass["INF1"] = "inf1";
})(InstanceClass = exports.InstanceClass || (exports.InstanceClass = {}));
/**
 * What size of instance to use
 */
var InstanceSize;
(function (InstanceSize) {
    InstanceSize["NANO"] = "nano";
    InstanceSize["MICRO"] = "micro";
    InstanceSize["SMALL"] = "small";
    InstanceSize["MEDIUM"] = "medium";
    InstanceSize["LARGE"] = "large";
    InstanceSize["XLARGE"] = "xlarge";
    InstanceSize["XLARGE2"] = "2xlarge";
    InstanceSize["XLARGE4"] = "4xlarge";
    InstanceSize["XLARGE8"] = "8xlarge";
    InstanceSize["XLARGE9"] = "9xlarge";
    InstanceSize["XLARGE10"] = "10xlarge";
    InstanceSize["XLARGE12"] = "12xlarge";
    InstanceSize["XLARGE16"] = "16xlarge";
    InstanceSize["XLARGE18"] = "18xlarge";
    InstanceSize["XLARGE24"] = "24xlarge";
    InstanceSize["XLARGE32"] = "32xlarge";
    InstanceSize["METAL"] = "metal";
})(InstanceSize = exports.InstanceSize || (exports.InstanceSize = {}));
/**
 * Instance type for EC2 instances
 *
 * This class takes a literal string, good if you already
 * know the identifier of the type you want.
 */
class InstanceType {
    constructor(instanceTypeIdentifier) {
        this.instanceTypeIdentifier = instanceTypeIdentifier;
    }
    /**
     * Instance type for EC2 instances
     *
     * This class takes a combination of a class and size.
     *
     * Be aware that not all combinations of class and size are available, and not all
     * classes are available in all regions.
     */
    static of(instanceClass, instanceSize) {
        return new InstanceType(`${instanceClass}.${instanceSize}`);
    }
    /**
     * Return the instance type as a dotted string
     */
    toString() {
        return this.instanceTypeIdentifier;
    }
}
exports.InstanceType = InstanceType;
//# sourceMappingURL=data:application/json;base64,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