"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScalableTableAttribute = void 0;
const appscaling = require("../../aws-applicationautoscaling"); // Automatically re-written from '@aws-cdk/aws-applicationautoscaling'
/**
 * A scalable table attribute
 */
class ScalableTableAttribute extends appscaling.BaseScalableAttribute {
    /**
     * Scale out or in based on time
     */
    scaleOnSchedule(id, action) {
        super.doScaleOnSchedule(id, action);
    }
    /**
     * Scale out or in to keep utilization at a given level
     */
    scaleOnUtilization(props) {
        if (props.targetUtilizationPercent < 10 || props.targetUtilizationPercent > 90) {
            // tslint:disable-next-line:max-line-length
            throw new RangeError(`targetUtilizationPercent for DynamoDB scaling must be between 10 and 90 percent, got: ${props.targetUtilizationPercent}`);
        }
        const predefinedMetric = this.props.dimension.indexOf('ReadCapacity') === -1
            ? appscaling.PredefinedMetric.DYANMODB_WRITE_CAPACITY_UTILIZATION
            : appscaling.PredefinedMetric.DYNAMODB_READ_CAPACITY_UTILIZATION;
        super.doScaleToTrackMetric('Tracking', {
            policyName: props.policyName,
            disableScaleIn: props.disableScaleIn,
            scaleInCooldown: props.scaleInCooldown,
            scaleOutCooldown: props.scaleOutCooldown,
            targetValue: props.targetUtilizationPercent,
            predefinedMetric,
        });
    }
}
exports.ScalableTableAttribute = ScalableTableAttribute;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2NhbGFibGUtdGFibGUtYXR0cmlidXRlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic2NhbGFibGUtdGFibGUtYXR0cmlidXRlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLCtEQUErRCxDQUFDLHNFQUFzRTtBQUV0STs7R0FFRztBQUNILE1BQWEsc0JBQXVCLFNBQVEsVUFBVSxDQUFDLHFCQUFxQjtJQUN4RTs7T0FFRztJQUNJLGVBQWUsQ0FBQyxFQUFVLEVBQUUsTUFBa0M7UUFDakUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLEVBQUUsRUFBRSxNQUFNLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBQ0Q7O09BRUc7SUFDSSxrQkFBa0IsQ0FBQyxLQUE4QjtRQUNwRCxJQUFJLEtBQUssQ0FBQyx3QkFBd0IsR0FBRyxFQUFFLElBQUksS0FBSyxDQUFDLHdCQUF3QixHQUFHLEVBQUUsRUFBRTtZQUM1RSwyQ0FBMkM7WUFDM0MsTUFBTSxJQUFJLFVBQVUsQ0FBQyx5RkFBeUYsS0FBSyxDQUFDLHdCQUF3QixFQUFFLENBQUMsQ0FBQztTQUNuSjtRQUNELE1BQU0sZ0JBQWdCLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLGNBQWMsQ0FBQyxLQUFLLENBQUMsQ0FBQztZQUN4RSxDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLG1DQUFtQztZQUNqRSxDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLGtDQUFrQyxDQUFDO1FBQ3JFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxVQUFVLEVBQUU7WUFDbkMsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVO1lBQzVCLGNBQWMsRUFBRSxLQUFLLENBQUMsY0FBYztZQUNwQyxlQUFlLEVBQUUsS0FBSyxDQUFDLGVBQWU7WUFDdEMsZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLGdCQUFnQjtZQUN4QyxXQUFXLEVBQUUsS0FBSyxDQUFDLHdCQUF3QjtZQUMzQyxnQkFBZ0I7U0FDbkIsQ0FBQyxDQUFDO0lBQ1AsQ0FBQztDQUNKO0FBM0JELHdEQTJCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGFwcHNjYWxpbmcgZnJvbSBcIi4uLy4uL2F3cy1hcHBsaWNhdGlvbmF1dG9zY2FsaW5nXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtYXBwbGljYXRpb25hdXRvc2NhbGluZydcbmltcG9ydCB7IFV0aWxpemF0aW9uU2NhbGluZ1Byb3BzIH0gZnJvbSAnLi9zY2FsYWJsZS1hdHRyaWJ1dGUtYXBpJztcbi8qKlxuICogQSBzY2FsYWJsZSB0YWJsZSBhdHRyaWJ1dGVcbiAqL1xuZXhwb3J0IGNsYXNzIFNjYWxhYmxlVGFibGVBdHRyaWJ1dGUgZXh0ZW5kcyBhcHBzY2FsaW5nLkJhc2VTY2FsYWJsZUF0dHJpYnV0ZSB7XG4gICAgLyoqXG4gICAgICogU2NhbGUgb3V0IG9yIGluIGJhc2VkIG9uIHRpbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgc2NhbGVPblNjaGVkdWxlKGlkOiBzdHJpbmcsIGFjdGlvbjogYXBwc2NhbGluZy5TY2FsaW5nU2NoZWR1bGUpIHtcbiAgICAgICAgc3VwZXIuZG9TY2FsZU9uU2NoZWR1bGUoaWQsIGFjdGlvbik7XG4gICAgfVxuICAgIC8qKlxuICAgICAqIFNjYWxlIG91dCBvciBpbiB0byBrZWVwIHV0aWxpemF0aW9uIGF0IGEgZ2l2ZW4gbGV2ZWxcbiAgICAgKi9cbiAgICBwdWJsaWMgc2NhbGVPblV0aWxpemF0aW9uKHByb3BzOiBVdGlsaXphdGlvblNjYWxpbmdQcm9wcykge1xuICAgICAgICBpZiAocHJvcHMudGFyZ2V0VXRpbGl6YXRpb25QZXJjZW50IDwgMTAgfHwgcHJvcHMudGFyZ2V0VXRpbGl6YXRpb25QZXJjZW50ID4gOTApIHtcbiAgICAgICAgICAgIC8vIHRzbGludDpkaXNhYmxlLW5leHQtbGluZTptYXgtbGluZS1sZW5ndGhcbiAgICAgICAgICAgIHRocm93IG5ldyBSYW5nZUVycm9yKGB0YXJnZXRVdGlsaXphdGlvblBlcmNlbnQgZm9yIER5bmFtb0RCIHNjYWxpbmcgbXVzdCBiZSBiZXR3ZWVuIDEwIGFuZCA5MCBwZXJjZW50LCBnb3Q6ICR7cHJvcHMudGFyZ2V0VXRpbGl6YXRpb25QZXJjZW50fWApO1xuICAgICAgICB9XG4gICAgICAgIGNvbnN0IHByZWRlZmluZWRNZXRyaWMgPSB0aGlzLnByb3BzLmRpbWVuc2lvbi5pbmRleE9mKCdSZWFkQ2FwYWNpdHknKSA9PT0gLTFcbiAgICAgICAgICAgID8gYXBwc2NhbGluZy5QcmVkZWZpbmVkTWV0cmljLkRZQU5NT0RCX1dSSVRFX0NBUEFDSVRZX1VUSUxJWkFUSU9OXG4gICAgICAgICAgICA6IGFwcHNjYWxpbmcuUHJlZGVmaW5lZE1ldHJpYy5EWU5BTU9EQl9SRUFEX0NBUEFDSVRZX1VUSUxJWkFUSU9OO1xuICAgICAgICBzdXBlci5kb1NjYWxlVG9UcmFja01ldHJpYygnVHJhY2tpbmcnLCB7XG4gICAgICAgICAgICBwb2xpY3lOYW1lOiBwcm9wcy5wb2xpY3lOYW1lLFxuICAgICAgICAgICAgZGlzYWJsZVNjYWxlSW46IHByb3BzLmRpc2FibGVTY2FsZUluLFxuICAgICAgICAgICAgc2NhbGVJbkNvb2xkb3duOiBwcm9wcy5zY2FsZUluQ29vbGRvd24sXG4gICAgICAgICAgICBzY2FsZU91dENvb2xkb3duOiBwcm9wcy5zY2FsZU91dENvb2xkb3duLFxuICAgICAgICAgICAgdGFyZ2V0VmFsdWU6IHByb3BzLnRhcmdldFV0aWxpemF0aW9uUGVyY2VudCxcbiAgICAgICAgICAgIHByZWRlZmluZWRNZXRyaWMsXG4gICAgICAgIH0pO1xuICAgIH1cbn1cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZW5hYmxpbmcgRHluYW1vREIgY2FwYWNpdHkgc2NhbGluZ1xuICovXG5leHBvcnQgaW50ZXJmYWNlIEVuYWJsZVNjYWxpbmdQcm9wcyB7XG4gICAgLyoqXG4gICAgICogTWluaW11bSBjYXBhY2l0eSB0byBzY2FsZSB0b1xuICAgICAqL1xuICAgIG1pbkNhcGFjaXR5OiBudW1iZXI7XG4gICAgLyoqXG4gICAgICogTWF4aW11bSBjYXBhY2l0eSB0byBzY2FsZSB0b1xuICAgICAqL1xuICAgIG1heENhcGFjaXR5OiBudW1iZXI7XG59XG4iXX0=