"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobDefinitionImageConfig = void 0;
const ecs = require("../../aws-ecs"); // Automatically re-written from '@aws-cdk/aws-ecs'
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
/**
 * Batch Job Task Definition
 *
 * Defines a Batch Job Task Definition. The properties of this task definition mirrors
 * those of an {@link ecs.ContainerDefinition}. This class is a wrapper on that structure.
 */
class TaskDefinition {
    constructor(props) {
        this.executionRole = props.executionRole;
    }
    /**
     * Internal function to allow the Batch Job task defintion
     * to match the CDK requirements of an EC2 task definition.
     *
     * @internal
     */
    // tslint:disable-next-line: no-empty
    _linkContainer() { }
    /**
     * Retrieves the execution role for this task definition
     */
    obtainExecutionRole() {
        return this.executionRole;
    }
}
/**
 * The configuration for creating a batch container image.
 */
class JobDefinitionImageConfig {
    constructor(scope, container) {
        const config = this.bindImageConfig(scope, container);
        this.imageName = config.imageName;
    }
    bindImageConfig(scope, container) {
        return container.image.bind(scope, new ecs.ContainerDefinition(scope, 'Resource-Batch-Job-Container-Definition', {
            command: container.command,
            cpu: container.vcpus,
            image: container.image,
            environment: container.environment,
            linuxParameters: container.linuxParams,
            memoryLimitMiB: container.memoryLimitMiB,
            privileged: container.privileged,
            readonlyRootFilesystem: container.readOnly,
            gpuCount: container.gpuCount,
            user: container.user,
            taskDefinition: new TaskDefinition({
                executionRole: container.jobRole || new iam.LazyRole(scope, 'Resource-Batch-Task-Definition-Role', {
                    assumedBy: new iam.ServicePrincipal('batch.amazonaws.com'),
                }),
            }),
        }));
    }
}
exports.JobDefinitionImageConfig = JobDefinitionImageConfig;
//# sourceMappingURL=data:application/json;base64,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