"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcLink = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const apigateway_generated_1 = require("./apigateway.generated");
/**
 * Define a new VPC Link
 * Specifies an API Gateway VPC link for a RestApi to access resources in an Amazon Virtual Private Cloud (VPC).
 */
class VpcLink extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.vpcLinkName ||
                core_1.Lazy.stringValue({ produce: () => this.node.uniqueId }),
        });
        this.targets = new Array();
        const cfnResource = new apigateway_generated_1.CfnVpcLink(this, 'Resource', {
            name: this.physicalName,
            description: props.description,
            targetArns: core_1.Lazy.listValue({ produce: () => this.renderTargets() }),
        });
        this.vpcLinkId = cfnResource.ref;
        if (props.targets) {
            this.addTargets(...props.targets);
        }
    }
    /**
     * Import a VPC Link by its Id
     */
    static fromVpcLinkId(scope, id, vpcLinkId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.vpcLinkId = vpcLinkId;
            }
        }
        return new Import(scope, id);
    }
    addTargets(...targets) {
        this.targets.push(...targets);
    }
    validate() {
        if (this.targets.length === 0) {
            return ['No targets added to vpc link'];
        }
        return [];
    }
    renderTargets() {
        return this.targets.map(nlb => nlb.loadBalancerArn);
    }
}
exports.VpcLink = VpcLink;
//# sourceMappingURL=data:application/json;base64,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