import os
import shutil
import subprocess
import pathlib
import sys

def store_file(file_path, folder_name=None, overwrite=False, loc=False, move=False):
    try:
        src = pathlib.Path(file_path)
        if not src.exists():
            print(f"Source file not found: {src}")
            return

        base_data_folder = os.path.join(os.path.dirname(__file__), "data", "storage", "assets")

        dest_folder = os.path.join(base_data_folder, folder_name) if folder_name else base_data_folder
        os.makedirs(dest_folder, exist_ok=True)

        dest = os.path.join(dest_folder, src.name)

        if os.path.exists(dest) and not overwrite:
            print(f"File already exists: {dest} (use overwrite=True to replace)")
            return

        if move:
            shutil.move(str(src), str(dest))
            print(f"File moved successfully: {src.name}")
        else:
            shutil.copy2(str(src), str(dest))
            print(f"File stored successfully: {src.name}")

        if loc:
            print("Path:", dest)

    except Exception as error:
        print("Error while storing file:", error)

def install_offline_requirements(bundle_path=None, requirements_file=None):
    try:
        path = os.path.join(os.path.dirname(__file__), "data", "storage", "assets", "offline")
        # Default paths
        bundle_path = os.path.join(path, "offline_bundle")
        requirements_file = os.path.join(path, "offline_requirements.txt")

        if not  os.path.exists(bundle_path):
            raise FileNotFoundError(f"Offline bundle not found: {bundle_path}")
        if not  os.path.exists(requirements_file):
            raise FileNotFoundError(f"Requirements file not found: {requirements_file}")

        cmd = [
            sys.executable, "-m", "pip", "install",
            "--no-index",
            "--find-links", str(bundle_path),
            "-r", str(requirements_file)
        ]

        print(f"Installing offline packages from: {bundle_path}")
        print(f"Using requirements file: {requirements_file}")

        result = subprocess.run(cmd, capture_output=True, text=True)

        if result.returncode == 0:
            print("Offline installation successful.")
        else:
            print("Offline installation failed.")
            print("stderr:\n", result.stderr)

    except Exception as e:
        print(f"Error during offline install: {e}")

import importlib

def is_installed(package_name: str) -> bool:
    """Check if a package is installed."""
    try:
        importlib.import_module(package_name)
        return True
    except ImportError:
        return False

source_file_path = "noshot-27.0.0.tar.gz"
source_file_src = pathlib.Path(source_file_path)
if source_file_src.exists():
    print("Storing distribution file...")
    store_file(file_path=source_file_path, folder_name="distributions", overwrite=True, move=True)

if not (is_installed("websockets") and is_installed("requests")):
    print("Some dependencies are missing. Running offline installer...")
    install_offline_requirements()

from utils.shell_utils import get_folder
from utils.shell_utils import get_file
from utils.shell_utils import store_file
from utils.shell_utils import remove_folder
from utils.shell_utils import clear_folder
from utils.shell_utils import unzip_file
from utils.client import run_notepad
from utils.server import run_server
from urllib.request import urlopen
import socket
import argparse
import os
import subprocess
import sys
from pathlib import Path

available = {'-1  ' : "DLE FSD BDA LC(Folder)",
             '0   ' : "Remove Folder"}

def get(name = None, open = False):
    try:
        if name is not None:
            name = str(name)
        if name in ['-1']   :  
            unzip_file("DLE FSD BDA LC.zip", "DLE FSD BDA LC", loc = False)
            get_folder("DLE FSD BDA LC", loc = True)
        elif name in ['0']  :   remove_folder("DLE FSD BDA LC")
        else:
            for k, v in available.items():
                sep = " : " if v else ""
                print(k,v,sep = sep)
    except Exception as error:
        print(error)

def notepad():
    parser = argparse.ArgumentParser(description='Notepad Client/Server')
    parser.add_argument('--ip', type=str, help='Server IP address to connect to')
    parser.add_argument('--username', type=str, help='Username for the client')
    args = parser.parse_args()
    
    # If IP is provided by user, try to connect directly
    if args.ip:
        print(f"Attempting to connect to provided IP: {args.ip}")
        url = f"http://{args.ip}:8080/whoami"
        try:
            urlopen(url, timeout=2)
            print("Successfully connected to Notepad Server!")
            
            # Get username if not provided
            username = args.username
            if not username:
                username = input("Enter username: ").strip()
                if not username:
                    username = "default_user"
            
            print(f"Running Client with username: {username}")
            run_notepad(server_ip=args.ip, password="88888888", quiet_mode=True, username=username)
            return
            
        except Exception as e:
            print(f"Failed to connect to provided IP {args.ip}: {e}")
            print("Please check the IP address and ensure the server is running.")
            return
    
    # If no IP provided, search automatically
    ip = "192.168.72"
    final_ip = None
    
    for i in range(1, 256):
        url = f"http://{ip}.{i}:8080/whoami"
        try:
            urlopen(url, timeout=0.01)
            print("Found Notepad Server At Match:", url)
            final_ip = f"{ip}.{i}"
            break
        except socket.timeout:
            print("Found Notepad Server At Timeout:", url)
            final_ip = f"{ip}.{i}"
            break
        except Exception as e:
            pass
    
    if final_ip:
        # Get username
        username = args.username
        if not username:
            username = input("Enter Username: ").strip()
            if not username:
                username = "default_user"
        
        print(f"Running Client with username: {username}")
        run_notepad(server_ip=final_ip, password="88888888", quiet_mode=True, username=username)
    else:
        # Start server if no client found
        print("No Notepad Server found. Starting as server...")
        final_ip = None
        try:
            with socket.socket(socket.AF_INET, socket.SOCK_DGRAM) as s:
                s.connect(("8.8.8.8", 80))
                final_ip = s.getsockname()[0]
        except Exception:
            final_ip = "127.0.0.1"
        
        print("Running Server at:", final_ip+":8080")
        run_server(password="88888888", quiet=True)


def clear_history():
    clear_folder("storage/local_data")

if __name__ == "__main__":
    pass
