# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['project_maker',
 'project_maker.maker',
 'project_maker.template.api',
 'project_maker.template.api.___project_name__snake___.cms',
 'project_maker.template.api.___project_name__snake___.cms.migrations',
 'project_maker.template.api.___project_name__snake___.core',
 'project_maker.template.api.___project_name__snake___.core.migrations',
 'project_maker.template.api.___project_name__snake___.django',
 'project_maker.template.api.___project_name__snake___.people',
 'project_maker.template.api.___project_name__snake___.people.migrations']

package_data = \
{'': ['*'],
 'project_maker': ['template/*',
                   'template/front/*',
                   'template/front/components/*',
                   'template/front/components/blocks/*',
                   'template/front/pages/*'],
 'project_maker.template.api.___project_name__snake___.cms': ['templates/*',
                                                              'templates/cms/*']}

install_requires = \
['Unidecode>=1.3.4,<2.0.0',
 'black>=22.8.0,<23.0.0',
 'isort>=5.10.1,<6.0.0',
 'monoformat>=0.1.0b3,<0.2.0',
 'node-edge>=0.1.0b2,<0.2.0',
 'pathspec>=0.10.2,<0.11.0',
 'rich>=12.5.1,<13.0.0',
 'tomlkit>=0.11.4,<0.12.0']

entry_points = \
{'console_scripts': ['project_maker = model_w.project_maker.__main__:__main__']}

setup_kwargs = {
    'name': 'modelw-project-maker',
    'version': '2022.10.0b2',
    'description': 'A tool to create Model-W-compliant projects',
    'long_description': '# Model&nbsp;W Project Maker\n\nThis project maker is the simplest way to start a\n[Model W](https://model-w.readthedocs.io/en/latest/) project.\n\nThe goal is to be extremely simple:\n\n```bash\ncurl -s https://pypi.run/modelw-project-maker/model_w.project_maker | python3.10\n```\n\nThis will ask you a few questions and create the project\'s directory for you.\n\n## Prerequisites\n\nIn order to execute the script, you need:\n\n-   Python 3.10 (you can use pyenv to load it in your current shell)\n-   Poetry (follow the instructions on\n    [their website](https://python-poetry.org/docs/#installation))\n-   Git (you know where to get it)\n-   Git Flow (`apt install git-flow` or `brew install git-flow` depending on\n    your OS)\n-   Node and NPM (get it your favorite way)\n-   PostgreSQL and Redis (if you enable the API side)\n\n## What to do next\n\nOnce the script is done, you\'ll have a directory with the project\'s name. You\ncan then `cd` into it and start working on it.\n\n### Environment setup\n\nYou can start by installing the dependencies:\n\n```bash\n# If you enabled the API\ncd api\npoetry install\ncd ..\n\n# If you enabled the frontend\ncd front\nnpm install\n```\n\nIf you enabled the API, you then need to create the database:\n\n```bash\nsudo -u postgres psql -c "CREATE DATABASE <project_name>"\nsudo -u postgres psql -c "CREATE USER <project_name> WITH LOGIN PASSWORD \'<project_name>\'"\nsudo -u postgres psql -c "GRANT ALL PRIVILEGES ON DATABASE <project_name> TO <project_name>"\n```\n\nFinally, have a look at `api/.env` and/or `front/.env` and make sure that values\nthere are correct.\n\nFor the Django side, until you add more settings by yourself to `settings.py`,\nyou can use all the settings from the\n[Model&nbsp;W Django Preset](https://modelw-django-preset.readthedocs.io/en/latest/).\n\nIf you\'ve enabled Wagtail, you need to configure the\n[storage environment variables](https://modelw-django-preset.readthedocs.io/en/latest/storage.html),\nwhich should be commented out in your `.env`. You need to check with someone in\ncharge of the infrastructure to get those values (if it\'s yourself, you\'re in\nluck).\n\n### Django models customization\n\nSomething important in Django is to customize the User model to your needs. Even\nif you don\'t need it right now, you\'ll eventually be happy that you did it\nbecause you\'ll _always_ need to add fields to it.\n\nThus one of the first things you should do is to go check in the `people` app\'s\nmodels the custom `User` model that is provided by default in this template.\nModify it to your needs.\n\nIf you\'ve enabled Wagtail, the same applies for the `Image` and `Document`\nmodels present in the `cms` app.\n\nStill in Wagtail, the root page is replaced by a `HomePage` (defined in\n`cms/models.py`) in one of the migrations generated by the template. If that\'s\nnot okay for you, now is the time to change it. However most likely it\'s going\nto be convenient for you, because otherwise you\'ll need to do it manually in\nWagtail\'s admin. The only drawback is that when you\'ll want to add fields to the\n`HomePage` you will have to figure default values.\n\nOnce you\'ve adjusted all the models to your needs, feel free to make the\nmigrations and run them:\n\n```bash\napi/pmanage makemigrations\napi/pmanage migrate\n```\n\n> **Note** &mdash; You\'ll notice that there is a `pmanage` script in addition of\n> the `manage.py` script. It\'s simply a wrapper to call `manage.py` through the\n> Poetry virtual environment.\n\n### Nuxt/Wagtail integration\n\nIf you have both a front-end and a back-end, you\'ll have a Nuxt/Wagtail\nintegration automatically enabled.\n\nAll depends on two things:\n\n-   The `*.vue` catchall page in Nuxt. It will catch all requests to the\n    front-end and will forward them to Wagtail if they don\'t match any known\n    route. Then it will download the code of those pages (or forward the\n    errors/redirections) and render it using...\n-   The `ServerTemplatedComponent`. See the inline documentation. It will\n    basically allow you to have Vue components getting their template from\n    Django-generated HTML. This allows to easily have Django send generated HTML\n    and to inject some dynamism in required places in each component.\n\nIn case you find the `ServerTemplatedComponent` thing too brittle (it is a bit)\nyou can decide to keep the same logic but instead of calling HTML pages you can\nget content from the API. The default is to use this mechanism because it\'s\neasier to generate from Django, especially if you want to generate image\nthumbnails. But well, it\'s your project, you can do whatever you want.\n\nThe default configuration, which depends a lot on the proxy configuration in\n`nuxt.config.js`, works seamlessly with Wagtail. As long as you access the\nWagtail URLs through the front-end, the proxy will be invoked when necessary and\nJS code will be run otherwise. The live previews work perfectly well and it\'s up\nto you to keep it working.\n\n## Contributing\n\nIf you\'re developing this package and you want to make a release, you can simply\nrun:\n\n```bash\nmake release VERSION=<version>\n```\n\nThen you\'ll still need to push the branches and tags.\n',
    'author': 'Rémy Sanchez',
    'author_email': 'remy.sanchez@hyperthese.net',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/ModelW/project-maker',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
