# Model&nbsp;W Project Maker

This project maker is the simplest way to start a
[Model W](https://model-w.readthedocs.io/en/latest/) project.

The goal is to be extremely simple:

```bash
curl -s https://pypi.run/modelw-project-maker/model_w.project_maker | python3.10
```

This will ask you a few questions and create the project's directory for you.

## Prerequisites

In order to execute the script, you need:

-   Python 3.10 (you can use pyenv to load it in your current shell)
-   Poetry (follow the instructions on
    [their website](https://python-poetry.org/docs/#installation))
-   Git (you know where to get it)
-   Git Flow (`apt install git-flow` or `brew install git-flow` depending on
    your OS)
-   Node and NPM (get it your favorite way)
-   PostgreSQL and Redis (if you enable the API side)

## What to do next

Once the script is done, you'll have a directory with the project's name. You
can then `cd` into it and start working on it.

### Environment setup

You can start by installing the dependencies:

```bash
# If you enabled the API
cd api
poetry install
cd ..

# If you enabled the frontend
cd front
npm install
```

If you enabled the API, you then need to create the database:

```bash
sudo -u postgres psql -c "CREATE DATABASE <project_name>"
sudo -u postgres psql -c "CREATE USER <project_name> WITH LOGIN PASSWORD '<project_name>'"
sudo -u postgres psql -c "GRANT ALL PRIVILEGES ON DATABASE <project_name> TO <project_name>"
```

Finally, have a look at `api/.env` and/or `front/.env` and make sure that values
there are correct.

For the Django side, until you add more settings by yourself to `settings.py`,
you can use all the settings from the
[Model&nbsp;W Django Preset](https://modelw-django-preset.readthedocs.io/en/latest/).

If you've enabled Wagtail, you need to configure the
[storage environment variables](https://modelw-django-preset.readthedocs.io/en/latest/storage.html),
which should be commented out in your `.env`. You need to check with someone in
charge of the infrastructure to get those values (if it's yourself, you're in
luck).

### Django models customization

Something important in Django is to customize the User model to your needs. Even
if you don't need it right now, you'll eventually be happy that you did it
because you'll _always_ need to add fields to it.

Thus one of the first things you should do is to go check in the `people` app's
models the custom `User` model that is provided by default in this template.
Modify it to your needs.

If you've enabled Wagtail, the same applies for the `Image` and `Document`
models present in the `cms` app.

Still in Wagtail, the root page is replaced by a `HomePage` (defined in
`cms/models.py`) in one of the migrations generated by the template. If that's
not okay for you, now is the time to change it. However most likely it's going
to be convenient for you, because otherwise you'll need to do it manually in
Wagtail's admin. The only drawback is that when you'll want to add fields to the
`HomePage` you will have to figure default values.

Once you've adjusted all the models to your needs, feel free to make the
migrations and run them:

```bash
api/pmanage makemigrations
api/pmanage migrate
```

> **Note** &mdash; You'll notice that there is a `pmanage` script in addition of
> the `manage.py` script. It's simply a wrapper to call `manage.py` through the
> Poetry virtual environment.

### Nuxt/Wagtail integration

If you have both a front-end and a back-end, you'll have a Nuxt/Wagtail
integration automatically enabled.

All depends on two things:

-   The `*.vue` catchall page in Nuxt. It will catch all requests to the
    front-end and will forward them to Wagtail if they don't match any known
    route. Then it will download the code of those pages (or forward the
    errors/redirections) and render it using...
-   The `ServerTemplatedComponent`. See the inline documentation. It will
    basically allow you to have Vue components getting their template from
    Django-generated HTML. This allows to easily have Django send generated HTML
    and to inject some dynamism in required places in each component.

In case you find the `ServerTemplatedComponent` thing too brittle (it is a bit)
you can decide to keep the same logic but instead of calling HTML pages you can
get content from the API. The default is to use this mechanism because it's
easier to generate from Django, especially if you want to generate image
thumbnails. But well, it's your project, you can do whatever you want.

The default configuration, which depends a lot on the proxy configuration in
`nuxt.config.js`, works seamlessly with Wagtail. As long as you access the
Wagtail URLs through the front-end, the proxy will be invoked when necessary and
JS code will be run otherwise. The live previews work perfectly well and it's up
to you to keep it working.

## Contributing

If you're developing this package and you want to make a release, you can simply
run:

```bash
make release VERSION=<version>
```

Then you'll still need to push the branches and tags.
