"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloneRepository = exports.Ec2Environment = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const cloud9_generated_1 = require("../lib/cloud9.generated");
/**
 * (experimental) A Cloud9 Environment with Amazon EC2.
 *
 * @experimental
 * @resource AWS::Cloud9::EnvironmentEC2
 */
class Ec2Environment extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _c, _d, _e;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_cloud9_Ec2EnvironmentProps(props);
        this.vpc = props.vpc;
        if (!props.subnetSelection && this.vpc.publicSubnets.length === 0) {
            throw new Error('no subnetSelection specified and no public subnet found in the vpc, please specify subnetSelection');
        }
        const vpcSubnets = (_c = props.subnetSelection) !== null && _c !== void 0 ? _c : { subnetType: ec2.SubnetType.PUBLIC };
        const c9env = new cloud9_generated_1.CfnEnvironmentEC2(this, 'Resource', {
            name: props.ec2EnvironmentName,
            description: props.description,
            instanceType: (_e = (_d = props.instanceType) === null || _d === void 0 ? void 0 : _d.toString()) !== null && _e !== void 0 ? _e : ec2.InstanceType.of(ec2.InstanceClass.BURSTABLE2, ec2.InstanceSize.MICRO).toString(),
            subnetId: this.vpc.selectSubnets(vpcSubnets).subnetIds[0],
            repositories: props.clonedRepositories ? props.clonedRepositories.map(r => ({
                repositoryUrl: r.repositoryUrl,
                pathComponent: r.pathComponent,
            })) : undefined,
        });
        this.environmentId = c9env.ref;
        this.ec2EnvironmentArn = c9env.getAtt('Arn').toString();
        this.ec2EnvironmentName = c9env.getAtt('Name').toString();
        this.ideUrl = `https://${this.stack.region}.console.aws.amazon.com/cloud9/ide/${this.environmentId}`;
    }
    /**
     * (experimental) import from EnvironmentEc2Name.
     *
     * @experimental
     */
    static fromEc2EnvironmentName(scope, id, ec2EnvironmentName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.ec2EnvironmentName = ec2EnvironmentName;
                this.ec2EnvironmentArn = cdk.Stack.of(this).formatArn({
                    service: 'cloud9',
                    resource: 'environment',
                    resourceName: this.ec2EnvironmentName,
                });
            }
        }
        return new Import(scope, id);
    }
}
exports.Ec2Environment = Ec2Environment;
_a = JSII_RTTI_SYMBOL_1;
Ec2Environment[_a] = { fqn: "@aws-cdk/aws-cloud9.Ec2Environment", version: "1.138.2" };
/**
 * (experimental) The class for different repository providers.
 *
 * @experimental
 */
class CloneRepository {
    constructor(repositoryUrl, pathComponent) {
        this.repositoryUrl = repositoryUrl;
        this.pathComponent = pathComponent;
    }
    /**
     * (experimental) import repository to cloud9 environment from AWS CodeCommit.
     *
     * @param repository the codecommit repository to clone from.
     * @param path the target path in cloud9 environment.
     * @experimental
     */
    static fromCodeCommit(repository, path) {
        return {
            repositoryUrl: repository.repositoryCloneUrlHttp,
            pathComponent: path,
        };
    }
}
exports.CloneRepository = CloneRepository;
_b = JSII_RTTI_SYMBOL_1;
CloneRepository[_b] = { fqn: "@aws-cdk/aws-cloud9.CloneRepository", version: "1.138.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW52aXJvbm1lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJlbnZpcm9ubWVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQSx3Q0FBd0M7QUFDeEMscUNBQXFDO0FBRXJDLDhEQUE0RDs7Ozs7OztBQWtDNUQsTUFBYSxjQUFlLFNBQVEsR0FBRyxDQUFDLFFBQVE7Ozs7SUE2QjlDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBMEI7O1FBQ2xFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7O1FBRWpCLElBQUksQ0FBQyxHQUFHLEdBQUcsS0FBSyxDQUFDLEdBQUcsQ0FBQztRQUNyQixJQUFJLENBQUMsS0FBSyxDQUFDLGVBQWUsSUFBSSxJQUFJLENBQUMsR0FBRyxDQUFDLGFBQWEsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO1lBQ2pFLE1BQU0sSUFBSSxLQUFLLENBQUMsb0dBQW9HLENBQUMsQ0FBQztTQUN2SDtRQUVELE1BQU0sVUFBVSxTQUFHLEtBQUssQ0FBQyxlQUFlLG1DQUFJLEVBQUUsVUFBVSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsTUFBTSxFQUFFLENBQUM7UUFDbEYsTUFBTSxLQUFLLEdBQUcsSUFBSSxvQ0FBaUIsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ3BELElBQUksRUFBRSxLQUFLLENBQUMsa0JBQWtCO1lBQzlCLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztZQUM5QixZQUFZLGNBQUUsS0FBSyxDQUFDLFlBQVksMENBQUUsUUFBUSxxQ0FBTSxHQUFHLENBQUMsWUFBWSxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsYUFBYSxDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxDQUFDLFFBQVEsRUFBRTtZQUNwSSxRQUFRLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxhQUFhLENBQUMsVUFBVSxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztZQUN6RCxZQUFZLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsa0JBQWtCLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDMUUsYUFBYSxFQUFFLENBQUMsQ0FBQyxhQUFhO2dCQUM5QixhQUFhLEVBQUUsQ0FBQyxDQUFDLGFBQWE7YUFDL0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVM7U0FDaEIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsR0FBRyxDQUFDO1FBQy9CLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLFFBQVEsRUFBRSxDQUFDO1FBQ3hELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDLFFBQVEsRUFBRSxDQUFDO1FBQzFELElBQUksQ0FBQyxNQUFNLEdBQUcsV0FBVyxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sc0NBQXNDLElBQUksQ0FBQyxhQUFhLEVBQUUsQ0FBQztLQUN0Rzs7Ozs7O0lBbERNLE1BQU0sQ0FBQyxzQkFBc0IsQ0FBQyxLQUFnQixFQUFFLEVBQVUsRUFBRSxrQkFBMEI7UUFDM0YsTUFBTSxNQUFPLFNBQVEsR0FBRyxDQUFDLFFBQVE7WUFBakM7O2dCQUNTLHVCQUFrQixHQUFHLGtCQUFrQixDQUFDO2dCQUN4QyxzQkFBaUIsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxTQUFTLENBQUM7b0JBQ3RELE9BQU8sRUFBRSxRQUFRO29CQUNqQixRQUFRLEVBQUUsYUFBYTtvQkFDdkIsWUFBWSxFQUFFLElBQUksQ0FBQyxrQkFBa0I7aUJBQ3RDLENBQUMsQ0FBQztZQUNMLENBQUM7U0FBQTtRQUNELE9BQU8sSUFBSSxNQUFNLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0tBQzlCOztBQVpILHdDQXFEQzs7Ozs7Ozs7QUFHRCxNQUFhLGVBQWU7SUFTMUIsWUFBb0MsYUFBcUIsRUFBa0IsYUFBcUI7UUFBNUQsa0JBQWEsR0FBYixhQUFhLENBQVE7UUFBa0Isa0JBQWEsR0FBYixhQUFhLENBQVE7S0FBSTs7Ozs7Ozs7SUFQN0YsTUFBTSxDQUFDLGNBQWMsQ0FBQyxVQUFrQyxFQUFFLElBQVk7UUFDM0UsT0FBTztZQUNMLGFBQWEsRUFBRSxVQUFVLENBQUMsc0JBQXNCO1lBQ2hELGFBQWEsRUFBRSxJQUFJO1NBQ3BCLENBQUM7S0FDSDs7QUFQSCwwQ0FVQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNvZGVjb21taXQgZnJvbSAnQGF3cy1jZGsvYXdzLWNvZGVjb21taXQnO1xuaW1wb3J0ICogYXMgZWMyIGZyb20gJ0Bhd3MtY2RrL2F3cy1lYzInO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDZm5FbnZpcm9ubWVudEVDMiB9IGZyb20gJy4uL2xpYi9jbG91ZDkuZ2VuZXJhdGVkJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBJRWMyRW52aXJvbm1lbnQgZXh0ZW5kcyBjZGsuSVJlc291cmNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBlYzJFbnZpcm9ubWVudE5hbWU6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGVjMkVudmlyb25tZW50QXJuOiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgRWMyRW52aXJvbm1lbnRQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBpbnN0YW5jZVR5cGU/OiBlYzIuSW5zdGFuY2VUeXBlO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHN1Ym5ldFNlbGVjdGlvbj86IGVjMi5TdWJuZXRTZWxlY3Rpb247XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdnBjOiBlYzIuSVZwYztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGVjMkVudmlyb25tZW50TmFtZT86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGVzY3JpcHRpb24/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAvLyByZWFkb25seSBjbG9uZWRSZXBvc2l0b3JpZXM/OiBDbG91ZDlSZXBvc2l0b3J5W107XG4gIHJlYWRvbmx5IGNsb25lZFJlcG9zaXRvcmllcz86IENsb25lUmVwb3NpdG9yeVtdO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgRWMyRW52aXJvbm1lbnQgZXh0ZW5kcyBjZGsuUmVzb3VyY2UgaW1wbGVtZW50cyBJRWMyRW52aXJvbm1lbnQge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBmcm9tRWMyRW52aXJvbm1lbnROYW1lKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGVjMkVudmlyb25tZW50TmFtZTogc3RyaW5nKTogSUVjMkVudmlyb25tZW50IHtcbiAgICBjbGFzcyBJbXBvcnQgZXh0ZW5kcyBjZGsuUmVzb3VyY2Uge1xuICAgICAgcHVibGljIGVjMkVudmlyb25tZW50TmFtZSA9IGVjMkVudmlyb25tZW50TmFtZTtcbiAgICAgIHB1YmxpYyBlYzJFbnZpcm9ubWVudEFybiA9IGNkay5TdGFjay5vZih0aGlzKS5mb3JtYXRBcm4oe1xuICAgICAgICBzZXJ2aWNlOiAnY2xvdWQ5JyxcbiAgICAgICAgcmVzb3VyY2U6ICdlbnZpcm9ubWVudCcsXG4gICAgICAgIHJlc291cmNlTmFtZTogdGhpcy5lYzJFbnZpcm9ubWVudE5hbWUsXG4gICAgICB9KTtcbiAgICB9XG4gICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBlYzJFbnZpcm9ubWVudE5hbWU6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBlYzJFbnZpcm9ubWVudEFybjogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgZW52aXJvbm1lbnRJZDogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBpZGVVcmw6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IHZwYzogZWMyLklWcGM7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEVjMkVudmlyb25tZW50UHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy52cGMgPSBwcm9wcy52cGM7XG4gICAgaWYgKCFwcm9wcy5zdWJuZXRTZWxlY3Rpb24gJiYgdGhpcy52cGMucHVibGljU3VibmV0cy5sZW5ndGggPT09IDApIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignbm8gc3VibmV0U2VsZWN0aW9uIHNwZWNpZmllZCBhbmQgbm8gcHVibGljIHN1Ym5ldCBmb3VuZCBpbiB0aGUgdnBjLCBwbGVhc2Ugc3BlY2lmeSBzdWJuZXRTZWxlY3Rpb24nKTtcbiAgICB9XG5cbiAgICBjb25zdCB2cGNTdWJuZXRzID0gcHJvcHMuc3VibmV0U2VsZWN0aW9uID8/IHsgc3VibmV0VHlwZTogZWMyLlN1Ym5ldFR5cGUuUFVCTElDIH07XG4gICAgY29uc3QgYzllbnYgPSBuZXcgQ2ZuRW52aXJvbm1lbnRFQzIodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgbmFtZTogcHJvcHMuZWMyRW52aXJvbm1lbnROYW1lLFxuICAgICAgZGVzY3JpcHRpb246IHByb3BzLmRlc2NyaXB0aW9uLFxuICAgICAgaW5zdGFuY2VUeXBlOiBwcm9wcy5pbnN0YW5jZVR5cGU/LnRvU3RyaW5nKCkgPz8gZWMyLkluc3RhbmNlVHlwZS5vZihlYzIuSW5zdGFuY2VDbGFzcy5CVVJTVEFCTEUyLCBlYzIuSW5zdGFuY2VTaXplLk1JQ1JPKS50b1N0cmluZygpLFxuICAgICAgc3VibmV0SWQ6IHRoaXMudnBjLnNlbGVjdFN1Ym5ldHModnBjU3VibmV0cykuc3VibmV0SWRzWzBdLFxuICAgICAgcmVwb3NpdG9yaWVzOiBwcm9wcy5jbG9uZWRSZXBvc2l0b3JpZXMgPyBwcm9wcy5jbG9uZWRSZXBvc2l0b3JpZXMubWFwKHIgPT4gKHtcbiAgICAgICAgcmVwb3NpdG9yeVVybDogci5yZXBvc2l0b3J5VXJsLFxuICAgICAgICBwYXRoQ29tcG9uZW50OiByLnBhdGhDb21wb25lbnQsXG4gICAgICB9KSkgOiB1bmRlZmluZWQsXG4gICAgfSk7XG4gICAgdGhpcy5lbnZpcm9ubWVudElkID0gYzllbnYucmVmO1xuICAgIHRoaXMuZWMyRW52aXJvbm1lbnRBcm4gPSBjOWVudi5nZXRBdHQoJ0FybicpLnRvU3RyaW5nKCk7XG4gICAgdGhpcy5lYzJFbnZpcm9ubWVudE5hbWUgPSBjOWVudi5nZXRBdHQoJ05hbWUnKS50b1N0cmluZygpO1xuICAgIHRoaXMuaWRlVXJsID0gYGh0dHBzOi8vJHt0aGlzLnN0YWNrLnJlZ2lvbn0uY29uc29sZS5hd3MuYW1hem9uLmNvbS9jbG91ZDkvaWRlLyR7dGhpcy5lbnZpcm9ubWVudElkfWA7XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIENsb25lUmVwb3NpdG9yeSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGZyb21Db2RlQ29tbWl0KHJlcG9zaXRvcnk6IGNvZGVjb21taXQuSVJlcG9zaXRvcnksIHBhdGg6IHN0cmluZyk6IENsb25lUmVwb3NpdG9yeSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHJlcG9zaXRvcnlVcmw6IHJlcG9zaXRvcnkucmVwb3NpdG9yeUNsb25lVXJsSHR0cCxcbiAgICAgIHBhdGhDb21wb25lbnQ6IHBhdGgsXG4gICAgfTtcbiAgfVxuXG4gIHByaXZhdGUgY29uc3RydWN0b3IocHVibGljIHJlYWRvbmx5IHJlcG9zaXRvcnlVcmw6IHN0cmluZywgcHVibGljIHJlYWRvbmx5IHBhdGhDb21wb25lbnQ6IHN0cmluZykge31cbn1cbiJdfQ==