# Generated by Django 3.0.3 on 2020-11-28 13:44

from django.db import migrations, models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Cargo',
            fields=[
                ('id', models.UUIDField(auto_created=True, default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('code', models.CharField(default='', help_text='商品料号', max_length=50, verbose_name='商品料号')),
                ('hs_code', models.CharField(max_length=10, verbose_name='商品编码')),
                ('ciq_code', models.CharField(blank=True, max_length=10, null=True, verbose_name='商检编码')),
                ('name', models.CharField(help_text='货名', max_length=100, verbose_name='货名')),
                ('declare_elements', models.TextField(help_text='申报要素（商品规格型号、品牌）', verbose_name='申报要素（商品规格型号、品牌）')),
                ('source_area', models.CharField(default='', help_text='原产地（国）', max_length=50, verbose_name='原产地（国）')),
                ('natcd', models.CharField(help_text='国别', max_length=10, verbose_name='国别')),
                ('unit', models.CharField(blank=True, help_text='数量单位', max_length=20, null=True, verbose_name='数量单位')),
                ('g_unit', models.CharField(blank=True, help_text='申报单位', max_length=20, null=True, verbose_name='申报单位')),
                ('unit_1', models.CharField(blank=True, help_text='法定单位', max_length=20, null=True, verbose_name='法定单位')),
                ('unit_2', models.CharField(blank=True, help_text='法定第二单位', max_length=20, null=True, verbose_name='法定第二单位')),
                ('image_path', models.ImageField(blank=True, max_length=200, null=True, upload_to='cargo/images/', verbose_name='图片地址')),
                ('weight', models.DecimalField(blank=True, decimal_places=4, max_digits=10, null=True, verbose_name='重量/单位')),
                ('volume', models.DecimalField(blank=True, decimal_places=5, max_digits=10, null=True, verbose_name='体积/单位')),
                ('specs_quantity', models.DecimalField(decimal_places=2, default=0, help_text='规格量', max_digits=10, verbose_name='规格量')),
                ('specs_unit', models.CharField(default='', help_text='规格单位', max_length=100, verbose_name='规格单位')),
                ('pack_quantity', models.DecimalField(decimal_places=0, default=0, help_text='包装量', max_digits=10, verbose_name='包装量')),
                ('pack_unit', models.CharField(default='', help_text='包装单位', max_length=100, verbose_name='包装单位')),
                ('brand', models.CharField(blank=True, help_text='品牌', max_length=50, null=True, verbose_name='品牌')),
                ('name_en', models.CharField(blank=True, help_text='货物英文名', max_length=100, null=True, verbose_name='货物英文名')),
                ('gb_code', models.CharField(blank=True, help_text='国标号', max_length=20, null=True, verbose_name='国标号')),
                ('common_name', models.CharField(blank=True, help_text='通用名', max_length=40, null=True, verbose_name='通用名')),
                ('standard_name', models.CharField(blank=True, help_text='标准名称', max_length=40, null=True, verbose_name='标准名称')),
                ('common_standard_type', models.CharField(blank=True, help_text='通用标准中的类别名称', max_length=50, null=True, verbose_name='通用标准中的类别名称')),
                ('pack_type', models.CharField(blank=True, help_text='包装类型', max_length=50, null=True, verbose_name='包装类型')),
                ('duty_rate', models.CharField(blank=True, help_text='DutyRate', max_length=50, null=True, verbose_name='DutyRate')),
                ('if_automatic_license', models.BooleanField(default=True, verbose_name='是否需要自动进口许可证')),
                ('remark', models.TextField(blank=True, null=True, verbose_name='备注')),
                ('if_deleted', models.BooleanField(default=False, verbose_name='是否删除')),
            ],
            options={
                'verbose_name': '货物',
                'verbose_name_plural': '货物',
                'db_table': 'p_cargo',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Consignor',
            fields=[
                ('id', models.UUIDField(auto_created=True, default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(help_text='公司名称', max_length=40, verbose_name='公司名称')),
                ('code', models.CharField(help_text='委托公司代码', max_length=40, verbose_name='委托公司代码')),
                ('register_no', models.CharField(help_text='公司注册号', max_length=40, verbose_name='公司注册号')),
                ('register_address', models.CharField(help_text='公司注册地址', max_length=200, verbose_name='公司注册地址')),
                ('tax_id', models.CharField(help_text='税务登记号', max_length=40, verbose_name='税务登记号')),
                ('bank_account', models.CharField(help_text='银行账号', max_length=40, verbose_name='银行账号')),
                ('bank_name', models.CharField(help_text='开户行', max_length=40, verbose_name='开户行')),
                ('invoice_title', models.CharField(help_text='发票抬头', max_length=500, verbose_name='发票抬头')),
                ('contacts', models.CharField(help_text='联系人', max_length=40, verbose_name='联系人')),
                ('contact_num', models.CharField(help_text='联系电话', max_length=40, verbose_name='联系电话')),
                ('site_name', models.CharField(blank=True, help_text='仓储场地名称', max_length=200, null=True, verbose_name='仓储场地名称')),
                ('site_address', models.CharField(help_text='仓储场地地址', max_length=200, verbose_name='仓储场地地址')),
                ('if_package_storehouse', models.BooleanField(default=False, verbose_name='是否包仓')),
                ('pay_mode', models.IntegerField(choices=[(0, '现结'), (1, '月结'), (2, '海关')], verbose_name='结费方式')),
                ('if_customs', models.BooleanField(default=False, verbose_name='是否为海关')),
                ('if_deleted', models.BooleanField(default=False, verbose_name='是否删除')),
            ],
            options={
                'verbose_name': '委托公司',
                'verbose_name_plural': '委托公司',
                'db_table': 'p_consignor',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='CtnSize',
            fields=[
                ('id', models.UUIDField(auto_created=True, default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(help_text='尺寸名称', max_length=4, verbose_name='尺寸名称')),
                ('if_deleted', models.BooleanField(default=False, verbose_name='是否删除')),
            ],
            options={
                'verbose_name': '箱尺寸',
                'verbose_name_plural': '箱尺寸',
                'db_table': 'p_ctn_size',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='CtnType',
            fields=[
                ('id', models.UUIDField(auto_created=True, default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('code', models.CharField(help_text='类型代码', max_length=10, verbose_name='类型代码')),
                ('name', models.CharField(help_text='类型名称', max_length=10, verbose_name='类型名称')),
                ('if_deleted', models.BooleanField(default=False, verbose_name='是否删除')),
            ],
            options={
                'verbose_name': '箱类型',
                'verbose_name_plural': '箱类型',
                'db_table': 'p_ctn_type',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='DecMethod',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='方式名称', max_length=40, verbose_name='方式名称')),
                ('if_deleted', models.BooleanField(default=False, verbose_name='是否删除')),
            ],
            options={
                'verbose_name': '申报方式',
                'verbose_name_plural': '申报方式',
                'db_table': 'p_dec_method',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Forklift',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('no', models.CharField(max_length=30, verbose_name='编号')),
                ('forklift_type', models.CharField(choices=[('0', '堆高车'), ('1', '普通叉车'), ('2', '电动叉车')], default='0', max_length=1, verbose_name='叉车车辆类型')),
                ('if_deleted', models.BooleanField(default=False, verbose_name='是否删除')),
            ],
            options={
                'verbose_name': '叉车车辆',
                'verbose_name_plural': '叉车车辆',
                'db_table': 'p_forklift_type',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='ServiceProvider',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='服务商企业名称', max_length=100, verbose_name='服务商企业名称')),
                ('trade_code', models.CharField(help_text='企业编码', max_length=100, verbose_name='企业编码')),
                ('if_deleted', models.BooleanField(default=False, verbose_name='是否删除')),
            ],
            options={
                'verbose_name': '服务商',
                'verbose_name_plural': '服务商',
                'db_table': 'p_service_provider',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Supplier',
            fields=[
                ('id', models.UUIDField(auto_created=True, default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(help_text='公司名称', max_length=40, verbose_name='公司名称')),
                ('code', models.CharField(help_text='客户代码', max_length=40, verbose_name='客户代码')),
                ('register_no', models.CharField(help_text='公司注册号', max_length=40, verbose_name='公司注册号')),
                ('register_address', models.CharField(help_text='公司注册地址', max_length=200, verbose_name='公司注册地址')),
                ('tax_id', models.CharField(help_text='税务登记号', max_length=40, verbose_name='税务登记号')),
                ('bank_account', models.CharField(help_text='银行账号', max_length=40, verbose_name='银行账号')),
                ('bank_name', models.CharField(help_text='开户行', max_length=40, verbose_name='开户行')),
                ('invoice_title', models.CharField(help_text='发票抬头', max_length=500, verbose_name='发票抬头')),
                ('contacts', models.CharField(help_text='联系人', max_length=40, verbose_name='联系人')),
                ('contact_num', models.CharField(help_text='联系电话', max_length=40, verbose_name='联系电话')),
                ('if_deleted', models.BooleanField(default=False, verbose_name='是否删除')),
            ],
            options={
                'verbose_name': '供应商公司',
                'verbose_name_plural': '供应商公司',
                'db_table': 'p_supplier',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='UnPackType',
            fields=[
                ('id', models.UUIDField(auto_created=True, default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=4, unique=True, verbose_name='拆箱方式')),
                ('charge_mode', models.CharField(choices=[('0', '按箱尺寸'), ('1', '按重量')], default='0', max_length=1, verbose_name='计费方式')),
                ('if_deleted', models.BooleanField(default=False, verbose_name='是否删除')),
            ],
            options={
                'verbose_name': '拆箱方式',
                'verbose_name_plural': '拆箱方式',
                'db_table': 'p_unpack_type',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='WorkRoute',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='作业路线名称', max_length=20, verbose_name='作业路线名称')),
                ('if_deleted', models.BooleanField(default=False, verbose_name='是否删除')),
            ],
            options={
                'verbose_name': '作业路线',
                'verbose_name_plural': '作业路线',
                'db_table': 'p_work_route',
                'managed': False,
            },
        ),
    ]
