# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['target_bigquery', 'target_bigquery.tests']

package_data = \
{'': ['*']}

modules = \
['README', 'LICENSE']
install_requires = \
['google-cloud-bigquery[bqstorage]>=3.4.1,<4',
 'google-cloud-storage>=2.7.0,<3',
 'grpcio-status[grpc]>=1.51.1,<2',
 'grpcio-tools>=1.51.1,<2',
 'orjson>=3.7.2,<4',
 'requests>=2.25.1',
 'singer-sdk>=0.16.0',
 'tenacity>=8.0.1,<9']

entry_points = \
{'console_scripts': ['target-bigquery = '
                     'target_bigquery.target:TargetBigQuery.cli']}

setup_kwargs = {
    'name': 'z3-target-bigquery',
    'version': '0.5.6',
    'description': 'z3-target-bigquery is a Singer target for BigQuery. It supports storage write, GCS, streaming, and batch load methods. Built with the Meltano SDK.',
    'long_description': '<h1 align="center">Target-BigQuery</h1>\n\n<p align="center">\n<a href="https://github.com/z3z1ma/target-bigquery/actions/"><img alt="Actions Status" src="https://github.com/z3z1ma/target-bigquery/actions/workflows/ci.yml/badge.svg"></a>\n<a href="https://github.com/z3z1ma/target-bigquery/blob/main/LICENSE"><img alt="License: MIT" src="https://img.shields.io/badge/License-MIT-yellow.svg"></a>\n<a href="https://github.com/psf/black"><img alt="Code style: black" src="https://img.shields.io/badge/code%20style-black-000000.svg"></a>\n</p>\n\n**A rare 💎 you have stumbled upon**\n\n`target-bigquery` is a Singer target for BigQuery.\n\nIt is the most versatile target for BigQuery. Extremely performant, resource efficient, and fast in all configurations enabling over 8 different ingestion patterns. Denormalized variants indicate data is unpacked during load with a resultant schema in BigQuery based on the tap schema. Non-denormalized means we have a fixed schema which loads all data into an unstructured `JSON` column. They are both useful patterns. The latter allowing BigQuery to work with schemaless or rapidly changing sources such as MongoDB instantly, while the former is more performant and convenient to start modeling quickly.\n\n## Installation 📈\n\nThe package on pypi is named `z3-target-bigquery` but the executable it ships with is simply `target-bigquery`. This allows me to release work without concerns of naming conflicts on the package index.\n\n```bash\n# Use pipx or pip\npipx install z3-target-bigquery\n# Verify it is installed\ntarget-bigquery --version\n```\n\n## Features ✨\n\n- Autoscaling self-healing worker pool using either threads (default) or multiprocessing, configurable by the user for the _fastest_ possible data ingestion. Particularly when leveraging colocated compute in GCP.\n- Denormalized load pattern where data is unpacked in flight into a statically typed BigQuery schema derived from the input stream json schemas.\n- Fix schema load pattern where all data is loaded into a `JSON` column which has been GA in BigQuery since mid 2022.\n- Autogenerated `VIEW` support for fixed schema load patterns which essentially overlays a statically typed schema allowing you to get the best of both worlds when using fixed schema ingestion.\n- JIT compilation of protobuf schemas allowing the Storage Write API to use a denormalized load pattern. \n- BATCH message support 😎\n\n## Load Patterns 🏎\n\n- `Batch Load Job` ingestion pattern using in memory compression (fixed schema + denormalized)\n- `Storage Write API` ingestion pattern using gRPC and protocol buffers supporting both streaming and batch patterns. Capable of JIT compilation of BQ schemas to protobuf to enable denormalized loads of input structures only known at runtime. (fixed schema + denormalized 🎉)\n- `GCS Staging` ingestion pattern using in memory compression and a GCS staging layer which generates a well organized data lake which backs the data warehouse providing additional failsafes and data sources (fixed schema + denormalized)\n- `Legacy Streaming` ingestion pattern which emphasizes simplicity and fast start up / tear down. I would highly recommend the storage write API instead unless data volume is small (fixed schema + denormalized)\n\n\n**Choosing between denormalized and fixed schema (JSON support)?** 🙇🏾\u200d♂️\n\nThe gap between the methods is closed due in part to the target\'s ability to  automatically generating a `VIEW` which will unpack (or rather provide typing as a more accurate take) a JSON based ingestion source for you. Unless operating at tens of millions of rows with JSON objects containing multiple hundreds of keys, its quite performant. Particularly if accessing a small subset of keys. It does however fall off (quite hard) given enough scale as I mentioned (I\'ve pushed it to the limits). Denormalized is recommended for high volume where the schema is fairly consistent. Fixed is recommended for lower volume, inconsistent schemas or for taps which are inherently schemaless in which case its the ideal (only...) logical pattern. Fixed schema can also be used for taps which routinely break down on BQ due to json schemas being inexpressible in a static way (ie patternProperties, additionalProperties...)\n\n\n**Old Header (still true, here for posterity)** 🧪\n\nThis is the first truly unstructured sink for BigQuery leveraging the recent GA feature in BigQuery for JSON support. This allows this target to load from essentially any tap regardless of the quality or explicitness of its jsonschema. Observations in existing taps note things such as `patternProperties` used in jsonschema objects which break down on all existing BigQuery taps due to the previous need for strong typing. Also taps such as MongoDB which inherently deal with unstructured data are seamlessly enabled by this target without klutzy collection scraping of a sample of records which we _hope_ are repesentative of all documents.\n\n\nBuilt with the [Meltano Target SDK](https://sdk.meltano.com).\n\n\n## Configuration 🔨\n\n### Settings\n\nFirst a valid example to give context to the below including a nested key example (denoted via a `.` in the setting path) as seen with `column_name_transforms.snake_case`\n\n```json\n{\n    "project": "my-bq-project",\n    "method": "storage_write_api",\n    "denormalized": true,\n    "credentials_path": "...",\n    "dataset": "my_dataset",\n    "batch_size": 500,\n    "column_name_transforms": {\n      "snake_case": true\n    }\n}\n```\n\n\n| Setting             | Required | Default | Description |\n|:--------------------|:--------:|:-------:|:------------|\n| credentials_path    | False    | None    | The path to a gcp credentials json file. |\n| credentials_json    | False    | None    | A JSON string of your service account JSON file. |\n| project             | True     | None    | The target GCP project to materialize data into. |\n| dataset             | True     | None    | The target dataset to materialize data into. |\n| batch_size          | False    |  500    | The maximum number of rows to send in a single batch to the worker. This should be configured based on load method. For `storage_write_api` and `streaming_insert` it should be `<=500`, for the LoadJob sinks, it can be much higher, ie `>100,000` |\n| timeout             | False    |     600 | Default timeout for batch_job and gcs_stage derived LoadJobs. |\n| denormalized        | False    |       0 | Determines whether to denormalize the data before writing to BigQuery. A false value will write data using a fixed JSON column based schema, while a true value will write data using a dynamic schema derived from the tap. |\n| method              | True     | storage_write_api | The method to use for writing to BigQuery. Must be one of `batch_job`, `storage_write_api`, `gcs_stage`, `streaming_insert` |\n| generate_view       | False    |       0 | Determines whether to generate a view based on the SCHEMA message parsed from the tap. Only valid if denormalized=false meaning you are using the fixed JSON column based schema. |\n| bucket              | False    | None    | The GCS bucket to use for staging data. Only used if method is gcs_stage. |\n| cluster_on_key_properties| False    | False    | Indicates if we should use the key_properties from the tap to cluster our table. By default, tables created by this target cluster on `_sdc_batched_at`. |\n| partition_granularity| False    | "month"    | Indicates the granularity of the created table partitioning scheme which is based on `_sdc_batched_at`. By default the granularity is monthly. Must be one of: "hour", "day", "month", "year". |\n| column_name_transforms.lower| False    | None    | Lowercase column names. |\n| column_name_transforms.quote| False    | None    | Quote column names in any generated DDL. |\n| column_name_transforms.add_underscore_when_invalid| False    | None    | Add an underscore to the column name if it starts with a digit to make it valid. |\n| column_name_transforms.snake_case| False    | None    | Snake case all incoming column names. Does not apply to fixed schema loads but _does_ apply to the view auto-generated over them. |\n| options.storage_write_batch_mode| False    | None    | By default, we use the default stream (Committed mode) in the storage_write_api load method which results in streaming records which are immediately available and is generally fastest. If this is set to true, we will use the application created streams (Committed mode) to transactionally batch data on STATE messages and at end of pipe. |\n| options.process_pool | False    | None    | By default we use an autoscaling threadpool to write to BigQuery. If set to true, we will use a process pool. |\n| options.max_workers_per_stream| False    | None    | By default, each sink type has a preconfigured max worker limit. This sets an override for maximum number of workers per stream. |\n| stream_maps         | False    | None    | Config object for stream maps capability. For more information check out [Stream Maps](https://sdk.meltano.com/en/latest/stream_maps.html). |\n| stream_map_config   | False    | None    | User-defined config values to be used within map expressions. |\n| flattening_enabled  | False    | None    | \'True\' to enable schema flattening and automatically expand nested properties. |\n| flattening_max_depth| False    | None    | The max depth to flatten schemas. |\n\nA full list of supported settings and capabilities is available by running: `target-bigquery --about`\n\n### Configure using environment variables ✏️\n\nThis Singer target will automatically import any environment variables within the working directory\'s\n`.env` if the `--config=ENV` is provided, such that config values will be considered if a matching\nenvironment variable is set either in the terminal context or in the `.env` file.\n\n### Source Authentication and Authorization 👮🏽\u200d♂️\n\nAuthenticate via service account key file or Application Default Credentials (ADC)\nhttps://cloud.google.com/bigquery/docs/authentication\n\n## Capabilities ✨\n\n* `about`\n* `stream-maps`\n* `schema-flattening`\n* `batch`\n\n## Usage 👷\u200d♀️\n\nYou can easily run `target-bigquery` by itself or in a pipeline using [Meltano](https://meltano.com/).\n\n\n### Executing the Target Directly 🚧\n\n```bash\ntarget-bigquery --version\ntarget-bigquery --help\n# Test using the "Carbon Intensity" sample:\ntap-carbon-intensity | target-bigquery --config /path/to/target-bigquery-config.json\n```\n\n## Developer Resources 👩🏼\u200d💻\n\n\n### Initialize your Development Environment\n\n```bash\npipx install poetry\npoetry install\n```\n\n### Create and Run Tests\n\nCreate tests within the `target_bigquery/tests` subfolder and\n  then run:\n\n```bash\npoetry run pytest\n```\n\nYou can also test the `target-bigquery` CLI interface directly using `poetry run`:\n\n```bash\npoetry run target-bigquery --help\n```\n\n### Testing with [Meltano](https://meltano.com/)\n\n_**Note:** This target will work in any Singer environment and does not require Meltano.\nExamples here are for convenience and to streamline end-to-end orchestration scenarios._\n\nNext, install Meltano (if you haven\'t already) and any needed plugins:\n\n```bash\n# Install meltano\npipx install meltano\n# Initialize meltano within this directory\ncd target-bigquery\nmeltano install\n```\n\nNow you can test and orchestrate using Meltano:\n\n```bash\n# Test invocation:\nmeltano invoke target-bigquery --version\n# OR run a test `elt` pipeline with the Carbon Intensity sample tap:\nmeltano elt tap-carbon-intensity target-bigquery\n```\n\n### SDK Dev Guide\n\nSee the [dev guide](https://sdk.meltano.com/en/latest/dev_guide.html) for more instructions on how to use the Meltano SDK to\ndevelop your own Singer taps and targets.\n',
    'author': 'Alex Butler',
    'author_email': 'butler.alex2010@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/z3z1ma/target-bigquery',
    'packages': packages,
    'package_data': package_data,
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<3.11',
}


setup(**setup_kwargs)
