# face_picture_comparator

## Description. 

The package face_picture_comparator is used to:

	- Delimit face
	- Confront faces
	- Plot image
	- Plot result
	- Get image file

## Installation

Use the package manager [pip](https://pip.pypa.io/en/stable/) to install face_picture_comparator

```bash
pip install face_picture_comparator
```

## Usage

```python
from face_picture_comparator import load_img

image = load_img.get_image_file("my_image.jpg")
image = load_img.delimit_face(image)

# delimit_face returns an image with a rectangle delimiting the first face detected in the input image
```

```python
from face_picture_comparator import load_img
from face_picture_comparator import comparation
from face_picture_comparator import plot

image = load_img.get_image_file("my_image.jpg")
image_compare = load_img.get_image_file("other_image.jpg")
result_message = comparation.confront_faces(image, image_compare)

# confront_image returns a string informing whether or not the faces belong to the same person and the distance between them

plot.plot_result(image, image_compare, result_message)

# plot_result displays the images and the massage using matplotlib library
```

```python
from face_picture_comparator import load_img
from face_picture_comparator import plot
image = load_img.get_image_file("my_image.jpg")
plot.plot_image(image)

# plot_image displays the image using matplotlib library
```

## Author
Ronaldo Nunes

## License
[MIT](https://choosealicense.com/licenses/mit/)