import sys
from PyQt5.QtWidgets import *
from PyQt5.QtGui import *
from PyQt5.QtCore import *

class ProcessRunnable(QRunnable):
    def __init__(self, target, args):
        QRunnable.__init__(self)
        self.t = target
        self.args = args

    def run(self):
        self.t(*self.args)

    def start(self):
        QThreadPool.globalInstance().start(self)


import skvideo.io
def run(user_input, wind):

    import time
    start_time = time.time()
    file = "/home/giancos/Downloads/spotting_ui.mov"
    print(f"reading {file}")
    videogen = skvideo.io.FFmpegReader(file)
    print(f"read {file}")

    for i, frame in enumerate(videogen):

        text = f"{i} frame"
        print(text)

        h, w, ch = frame.shape
        bytesPerLine = ch * w
        qImage = QImage(
            frame.data, w, h, bytesPerLine, QImage.Format_RGB888)
        QMetaObject.invokeMethod(wind,
                                 "appendFrame", Qt.QueuedConnection,
                                 Q_ARG(QImage, qImage))

        print(i, "th frames - invoked Method")

class LogginOutput(QTextEdit):
    def __init__(self, parent=None):
        super(LogginOutput, self).__init__(parent)

        self.setReadOnly(True)
        self.setLineWrapMode(self.NoWrap)
        self.insertPlainText("")

    @pyqtSlot(str)
    def append(self, text):
        self.moveCursor(QTextCursor.End)
        current = self.toPlainText()

        if current == "":
            self.insertPlainText(text)
        else:
            self.insertPlainText("\n" + text)

        sb = self.verticalScrollBar()
        sb.setValue(sb.maximum())

class App(QWidget):
    def __init__(self):
        super().__init__()

        self.init_ui()

    def init_ui(self):
        label = QLabel('Amount')
        amount_input = QLineEdit()
        submit = QPushButton('Submit', self)
        self.box = LogginOutput(self)
        # slider = QSlider(self)
        self.frames = []

        submit.clicked.connect(lambda: self.changeLabel(self.box, amount_input))

        grid = QGridLayout()
        grid.addWidget(label, 0, 0)
        grid.addWidget(amount_input, 1, 0)
        grid.addWidget(submit, 1, 1)
        grid.addWidget(self.box, 2, 0, 5, 2)

        self.setLayout(grid)
        self.resize(350, 250)
        self.setWindowTitle('GetMeStuff Bot v0.1')
        self.show()

    def center(self):
        qr = self.frameGeometry()
        cp = QDesktopWidget().availableGeometry().center()
        qr.moveCenter(cp)
        self.move(qr.topLeft())

    def changeLabel(self, box, user_input):
        self.p = ProcessRunnable(target=run, args=(
            user_input.displayText(), self,))
        self.p.start()
        user_input.clear()

    @pyqtSlot(QImage)
    def appendFrame(self, frame):
        self.frames.append(frame)
        self.box.append(f"frame {len(self.frames)}")


if __name__ == '__main__':
    app = QApplication(sys.argv)
    widget = App()
    sys.exit(app.exec_())
