
# :flower_playing_cards: _wpgtk_

![PyPI](https://img.shields.io/pypi/v/wpgtk.svg?style=flat-square)
![license](https://img.shields.io/badge/license-GPLv2-green.svg?style=flat-square)
<a href="https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=X996W7Z8PW4VW"><img src="https://img.shields.io/badge/donate-paypal-green.svg?style=flat-square"></a>
<a href="https://www.irccloud.com/invite?channel=%23wpgtk&amp;hostname=irc.freenode.net&amp;port=6697&amp;ssl=1" target="_blank"><img src="https://img.shields.io/badge/IRC-%23wpgtk-1e72ff.svg?style=flat-square"  height="20"></a>
<a href="https://discord.gg/A9yTWv9rvn" target="_blank"><img src="https://img.shields.io/discord/846433943090757652?color=green&label=%23wpgtk&logo=discord&logoColor=white&style=flat-square"  height="20"></a>


<img align="left" src="https://i.imgur.com/ApSuntN.gif" width="450px"/>

`wpgtk` uses [pywal](https://github.com/dylanaraps/pywal) as its colorscheme generator, but builds upon it with a graphic user interface and other features such as the ability to edit the color-schemes generated and save them with their respective wallpapers, having light and dark themes for dynamic icons, hackable and fast GTK+ theme made specifically for `wpgtk`, custom keywords and values to replace in templates and auto color-scheme sorting to achieve more readable palettes.

In short, `wpgtk` is a color-scheme manager with a template system which lets you create templates from any text file and will replace keywords on it when you change your theme, delivering high customizing power.

And also, for those who are not into auto-generated color-schemes, you will be happy to know that `wpgtk` includes all the preset themes that `pywal` does, so that's around 200+ themes to play around with, that you can also _modify_ to get really readable and cool results!

## Wiki
If you prefer written documentation and want to know all the neat things you can do with `wpgtk` you can always go to the `wiki` and checkout the documentation for any of the features, as a user you can always contribute to this wiki to make it better.

###  [[Home](https://github.com/deviantfero/wpgtk/wiki)] [[Installation](https://github.com/deviantfero/wpgtk/wiki/Installation)] [[Colorschemes](https://github.com/deviantfero/wpgtk/wiki/Colorschemes)] [[Configuration](https://github.com/deviantfero/wpgtk/wiki/Configuration)] [[Custom Keywords](https://github.com/deviantfero/wpgtk/wiki/Custom-Keywords)] [[Templates](https://github.com/deviantfero/wpgtk/wiki/Templates)]

**_Warning_**: Users updating from versions older than `6.0.0` will have to update their templates to the new format, check the Templates section on the wiki for more information.

<br>

## Usage and Useful Links

- **Video tutorials:**
  * [Installation](https://www.youtube.com/watch?v=jmY5NEPI4RM)
  * [Advanced Features](https://www.youtube.com/watch?v=QXpMMP8fT0o)
  * [Command Line](https://www.youtube.com/watch?v=yjNipQZpOUc)
  * [Import/export Colorschemes](https://www.youtube.com/watch?v=P3D0jtG6G2s)
  * [Upgrade to 6.0.0 - feature overview](https://youtu.be/5V4Rb7ULEjM)

- **Other Repos:**
  * [wpgtk.vim](https://github.com/deviantfero/wpgtk.vim)
  * [ wpgtk-templates ](https://github.com/deviantfero/wpgtk-templates)
  * [wpgtk-colorschemes](https://github.com/deviantfero/wpgtk-colorschemes)

- **Gallery**
  * [User Gallery](https://imgur.com/a/EVIhGLj)
  * [Personal Gallery](https://imgur.com/a/0FFbz9F)

These are just some of the desktops of users I've managed to catch in the wild.  They're all pretty cool, I really love seeing these, but if anyone wants their desktop removed (or added) just send me an email or open an issue.



## Buy me a Coffee (or a soda)

If you found this project helpful and would like to give back in some way, you can donate here

<a href="https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=X996W7Z8PW4VW"><img src="https://img.shields.io/badge/donate-paypal-green.svg?style=flat-square"></a>

## License

This project is licensed under the GPLv2 License - see the [LICENSE](LICENSE) file for details
