import * as cdk from '@aws-cdk/core';
/**
 * CloudFormation equivalent of random_uuid.
 *
 * @schema CfnUuidProps
 */
export interface CfnUuidProps {
    /**
     * @schema CfnUuidProps#Keepers
     */
    readonly keepers?: KeepersDefinition[];
}
/**
 * Converts an object of type 'CfnUuidProps' to JSON representation.
 */
export declare function toJson_CfnUuidProps(obj: CfnUuidProps | undefined): Record<string, any> | undefined;
/**
 * @schema KeepersDefinition
 */
export interface KeepersDefinition {
    /**
     * @schema KeepersDefinition#MapKey
     */
    readonly mapKey: string;
    /**
     * @schema KeepersDefinition#MapValue
     */
    readonly mapValue: string;
}
/**
 * Converts an object of type 'KeepersDefinition' to JSON representation.
 */
export declare function toJson_KeepersDefinition(obj: KeepersDefinition | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `TF::Random::Uuid`.
 *
 * @external
 * @cloudformationResource TF::Random::Uuid
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
export declare class CfnUuid extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "TF::Random::Uuid";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnUuidProps;
    /**
     * Attribute `TF::Random::Uuid.tfcfnid`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrTfcfnid: string;
    /**
     * Attribute `TF::Random::Uuid.Id`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrId: string;
    /**
     * Attribute `TF::Random::Uuid.Result`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrResult: string;
    /**
     * Create a new `TF::Random::Uuid`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUuidProps);
}
