# Yoti Python Sandbox SDK

Welcome to the Yoti Python Sandbox SDK. This repo contains the tools you need to test your Python back-end integration.

## Requirements

### Python version
Please refer to [Travis](https://travis-ci.com/getyoti/yoti-python-sdk-sandbox) to see all compatible Python versions.

Please email [sdksupport@yoti.com](mailto:sdksupport@yoti.com) if you require a version which is not listed here.

## Installing the Sandbox

To import the Yoti Sandbox SDK inside your project, you can use your favourite dependency management system.
If you are using pip, you can use the following command to set the Yoti Sandbox SDK as a dependency:

```shell
pip install yoti-sandbox
```

## Configuration

* `CLIENT_SDK_ID` is the SDK identifier generated by Yoti Hub in the Key tab when you create your app.

* `/path/to/your-pem-file.pem` is the path to the application pem file. It can be downloaded only once from the Keys tab in your Yoti Hub.

Please do not open the pem file as this might corrupt the key and you will need to create a new application.

## Code Examples

In the examples folder there are snippets for:
- [Yoti App](/examples/profile.py)
- [Doc Scan](/examples/doc_scan.py)

## Additional Information

For more information about the Yoti Sandbox, please visit https://developers.yoti.com/yoti/sandbox-app
