# Generated by Django 5.1.12 on 2025-09-20 18:05

import django.core.validators
import django.db.models.deletion
import django.utils.timezone
import uuid
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Agent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('public_id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, help_text='External UUID for API references', unique=True, verbose_name='public ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('metadata', models.JSONField(blank=True, default=dict, help_text='Additional metadata for this record', verbose_name='metadata')),
                ('extension', models.CharField(max_length=10, unique=True, validators=[django.core.validators.RegexValidator(message='Extension must be between 3 and 10 digits', regex='^\\d{3,10}$')], verbose_name='extension')),
                ('status', models.CharField(choices=[('available', 'Available'), ('busy', 'Busy'), ('on_break', 'On Break'), ('after_call_work', 'After Call Work'), ('offline', 'Offline')], default='offline', max_length=20, verbose_name='status')),
                ('phone_number', models.CharField(blank=True, help_text="Agent's phone number for direct routing", max_length=20, validators=[django.core.validators.RegexValidator(message="Phone number must be entered in the format: '+999999999'. Up to 15 digits allowed.", regex='^\\+?1?\\d{9,15}$')], verbose_name='phone number')),
                ('skills', models.JSONField(blank=True, default=list, help_text='List of agent skills for routing', verbose_name='skills')),
                ('is_active', models.BooleanField(default=True, verbose_name='active')),
                ('max_concurrent_calls', models.IntegerField(default=1, validators=[django.core.validators.MinValueValidator(1)], verbose_name='max concurrent calls')),
                ('last_status_change', models.DateTimeField(default=django.utils.timezone.now, verbose_name='last status change')),
                ('total_talk_time', models.IntegerField(default=0, help_text='Total talk time in seconds', verbose_name='total talk time')),
                ('calls_handled_today', models.IntegerField(default=0, verbose_name='calls handled today')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='agent_profile', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Agent',
                'verbose_name_plural': 'Agents',
                'ordering': ['user__first_name', 'user__last_name'],
            },
        ),
        migrations.CreateModel(
            name='PhoneNumber',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('public_id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, help_text='External UUID for API references', unique=True, verbose_name='public ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('metadata', models.JSONField(blank=True, default=dict, help_text='Additional metadata for this record', verbose_name='metadata')),
                ('price', models.DecimalField(blank=True, decimal_places=4, help_text='Cost in the specified currency', max_digits=10, null=True, verbose_name='price')),
                ('price_unit', models.CharField(blank=True, default='USD', help_text='Currency code for the price', max_length=10, verbose_name='price unit')),
                ('twilio_sid', models.CharField(db_index=True, help_text='Twilio resource identifier', max_length=50, unique=True, verbose_name='Twilio SID')),
                ('phone_number', models.CharField(max_length=20, unique=True, validators=[django.core.validators.RegexValidator(message="Phone number must be entered in the format: '+999999999'. Up to 15 digits allowed.", regex='^\\+?1?\\d{9,15}$')], verbose_name='phone number')),
                ('friendly_name', models.CharField(blank=True, max_length=100, verbose_name='friendly name')),
                ('number_type', models.CharField(choices=[('local', 'Local'), ('toll_free', 'Toll Free'), ('mobile', 'Mobile'), ('international', 'International')], default='local', max_length=20, verbose_name='number type')),
                ('capabilities', models.JSONField(default=dict, help_text='Phone number capabilities (voice, SMS, MMS, fax)', verbose_name='capabilities')),
                ('is_active', models.BooleanField(default=True, verbose_name='active')),
                ('monthly_cost', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True, verbose_name='monthly cost')),
            ],
            options={
                'verbose_name': 'Phone Number',
                'verbose_name_plural': 'Phone Numbers',
                'ordering': ['-created_at'],
                'indexes': [models.Index(fields=['phone_number'], name='django_twil_phone_n_eaf232_idx'), models.Index(fields=['is_active', 'number_type'], name='django_twil_is_acti_21fe5a_idx')],
            },
        ),
        migrations.CreateModel(
            name='Queue',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('public_id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, help_text='External UUID for API references', unique=True, verbose_name='public ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('metadata', models.JSONField(blank=True, default=dict, help_text='Additional metadata for this record', verbose_name='metadata')),
                ('name', models.CharField(max_length=100, unique=True, verbose_name='name')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('routing_strategy', models.CharField(choices=[('fifo', 'First In First Out'), ('lifo', 'Last In First Out'), ('round_robin', 'Round Robin'), ('least_busy', 'Least Busy Agent'), ('skills_based', 'Skills Based')], default='fifo', max_length=20, verbose_name='routing strategy')),
                ('priority', models.IntegerField(default=0, help_text='Higher priority queues are processed first', validators=[django.core.validators.MinValueValidator(0)], verbose_name='priority')),
                ('max_size', models.IntegerField(default=100, help_text='Maximum number of calls in queue', validators=[django.core.validators.MinValueValidator(1)], verbose_name='max size')),
                ('timeout_seconds', models.IntegerField(default=300, help_text='Time in seconds before call times out in queue', validators=[django.core.validators.MinValueValidator(30)], verbose_name='timeout seconds')),
                ('music_url', models.URLField(blank=True, help_text='URL for hold music', verbose_name='hold music URL')),
                ('announcement_url', models.URLField(blank=True, help_text='URL for queue position announcement', verbose_name='announcement URL')),
                ('is_active', models.BooleanField(default=True, verbose_name='active')),
                ('required_skills', models.JSONField(blank=True, default=list, help_text='Skills required for agents to handle calls from this queue', verbose_name='required skills')),
                ('business_hours', models.JSONField(blank=True, default=dict, help_text='Business hours configuration for the queue', verbose_name='business hours')),
            ],
            options={
                'verbose_name': 'Queue',
                'verbose_name_plural': 'Queues',
                'ordering': ['-priority', 'name'],
                'indexes': [models.Index(fields=['name'], name='django_twil_name_b27660_idx'), models.Index(fields=['is_active', 'priority'], name='django_twil_is_acti_45c91e_idx')],
            },
        ),
        migrations.CreateModel(
            name='Call',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('public_id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, help_text='External UUID for API references', unique=True, verbose_name='public ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('metadata', models.JSONField(blank=True, default=dict, help_text='Additional metadata for this record', verbose_name='metadata')),
                ('price', models.DecimalField(blank=True, decimal_places=4, help_text='Cost in the specified currency', max_digits=10, null=True, verbose_name='price')),
                ('price_unit', models.CharField(blank=True, default='USD', help_text='Currency code for the price', max_length=10, verbose_name='price unit')),
                ('twilio_sid', models.CharField(db_index=True, help_text='Twilio resource identifier', max_length=50, unique=True, verbose_name='Twilio SID')),
                ('parent_call_sid', models.CharField(blank=True, help_text='SID of the parent call for transferred calls', max_length=50, verbose_name='Parent Call SID')),
                ('account_sid', models.CharField(max_length=50, verbose_name='Twilio Account SID')),
                ('from_number', models.CharField(db_index=True, max_length=20, verbose_name='from number')),
                ('from_formatted', models.CharField(blank=True, max_length=20, verbose_name='from formatted')),
                ('to_number', models.CharField(db_index=True, max_length=20, verbose_name='to number')),
                ('to_formatted', models.CharField(blank=True, max_length=20, verbose_name='to formatted')),
                ('direction', models.CharField(choices=[('inbound', 'Inbound'), ('outbound', 'Outbound')], db_index=True, max_length=10, verbose_name='direction')),
                ('status', models.CharField(choices=[('queued', 'Queued'), ('ringing', 'Ringing'), ('in-progress', 'In Progress'), ('completed', 'Completed'), ('failed', 'Failed'), ('busy', 'Busy'), ('no-answer', 'No Answer'), ('canceled', 'Canceled')], db_index=True, default='queued', max_length=20, verbose_name='status')),
                ('answered_by', models.CharField(blank=True, help_text='human, machine, or fax', max_length=20, verbose_name='answered by')),
                ('forwarded_from', models.CharField(blank=True, max_length=20, verbose_name='forwarded from')),
                ('caller_name', models.CharField(blank=True, max_length=100, verbose_name='caller name')),
                ('duration', models.IntegerField(default=0, help_text='Call duration in seconds', verbose_name='duration')),
                ('queue_time', models.IntegerField(default=0, help_text='Time spent in queue in seconds', verbose_name='queue time')),
                ('start_time', models.DateTimeField(blank=True, null=True, verbose_name='start time')),
                ('end_time', models.DateTimeField(blank=True, null=True, verbose_name='end time')),
                ('answered_at', models.DateTimeField(blank=True, null=True, verbose_name='answered at')),
                ('is_recorded', models.BooleanField(default=False, verbose_name='recorded')),
                ('recording_url', models.URLField(blank=True, verbose_name='recording URL')),
                ('transcription_text', models.TextField(blank=True, verbose_name='transcription')),
                ('voicemail_url', models.URLField(blank=True, verbose_name='voicemail URL')),
                ('conference_sid', models.CharField(blank=True, help_text='SID of conference if call is part of a conference', max_length=50, verbose_name='conference SID')),
                ('callback_source', models.CharField(blank=True, max_length=20, verbose_name='callback source')),
                ('agent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='calls', to='django_twilio_call.agent')),
                ('phone_number_used', models.ForeignKey(blank=True, help_text='The Twilio phone number used for this call', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='calls', to='django_twilio_call.phonenumber')),
                ('queue', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='calls', to='django_twilio_call.queue')),
            ],
            options={
                'verbose_name': 'Call',
                'verbose_name_plural': 'Calls',
                'ordering': ['-created_at'],
            },
        ),
        migrations.AddField(
            model_name='agent',
            name='queues',
            field=models.ManyToManyField(blank=True, help_text='Queues this agent can handle', related_name='agents', to='django_twilio_call.queue'),
        ),
        migrations.CreateModel(
            name='TaskExecution',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('public_id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, unique=True)),
                ('task_id', models.CharField(db_index=True, help_text='Celery task ID', max_length=50, unique=True, verbose_name='task ID')),
                ('task_name', models.CharField(db_index=True, help_text='Full task name', max_length=255, verbose_name='task name')),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('started', 'Started'), ('success', 'Success'), ('failure', 'Failure'), ('retry', 'Retry'), ('revoked', 'Revoked')], db_index=True, default='pending', max_length=20, verbose_name='status')),
                ('queue_name', models.CharField(db_index=True, help_text='Celery queue name', max_length=50, verbose_name='queue name')),
                ('worker_name', models.CharField(blank=True, help_text='Worker hostname', max_length=100, verbose_name='worker name')),
                ('retry_count', models.IntegerField(default=0, help_text='Number of retries attempted', verbose_name='retry count')),
                ('duration_seconds', models.FloatField(blank=True, help_text='Task execution duration in seconds', null=True, verbose_name='duration')),
                ('started_at', models.DateTimeField(blank=True, null=True, verbose_name='started at')),
                ('completed_at', models.DateTimeField(blank=True, null=True, verbose_name='completed at')),
                ('args', models.JSONField(blank=True, default=list, help_text='Task arguments', verbose_name='arguments')),
                ('kwargs', models.JSONField(blank=True, default=dict, help_text='Task keyword arguments', verbose_name='keyword arguments')),
                ('result', models.JSONField(blank=True, help_text='Task result or error information', null=True, verbose_name='result')),
                ('progress', models.JSONField(blank=True, default=dict, help_text='Task progress information', verbose_name='progress')),
                ('metadata', models.JSONField(blank=True, default=dict, help_text='Additional task metadata', verbose_name='metadata')),
            ],
            options={
                'verbose_name': 'Task Execution',
                'verbose_name_plural': 'Task Executions',
                'ordering': ['-created_at'],
                'indexes': [models.Index(fields=['task_id'], name='django_twil_task_id_293fb2_idx'), models.Index(fields=['task_name', 'status'], name='django_twil_task_na_6f1d08_idx'), models.Index(fields=['status', 'created_at'], name='django_twil_status_9c36ad_idx'), models.Index(fields=['queue_name', 'status'], name='django_twil_queue_n_f7e044_idx'), models.Index(fields=['worker_name', 'created_at'], name='django_twil_worker__545b24_idx'), models.Index(fields=['task_name', 'created_at', 'duration_seconds'], name='django_twil_task_na_f98a77_idx'), models.Index(fields=['status', 'retry_count', 'created_at'], name='django_twil_status_0db0bb_idx'), models.Index(condition=models.Q(('status__in', ['pending', 'started'])), fields=['created_at'], name='idx_active_tasks'), models.Index(condition=models.Q(('status', 'failure')), fields=['task_name', 'created_at'], name='idx_failed_tasks')],
            },
        ),
        migrations.CreateModel(
            name='WebhookLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('public_id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, unique=True)),
                ('webhook_type', models.CharField(db_index=True, help_text='Type of webhook (call-status, recording, etc.)', max_length=50, verbose_name='webhook type')),
                ('url', models.URLField(help_text='Target URL for webhook delivery', verbose_name='webhook URL')),
                ('payload', models.JSONField(help_text='Webhook payload data', verbose_name='payload')),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('delivered', 'Delivered'), ('failed', 'Failed'), ('retrying', 'Retrying'), ('abandoned', 'Abandoned')], db_index=True, default='pending', max_length=20, verbose_name='status')),
                ('http_status_code', models.IntegerField(blank=True, null=True, verbose_name='HTTP status code')),
                ('response_body', models.TextField(blank=True, verbose_name='response body')),
                ('retry_count', models.IntegerField(default=0, verbose_name='retry count')),
                ('next_retry_at', models.DateTimeField(blank=True, null=True, verbose_name='next retry at')),
                ('delivered_at', models.DateTimeField(blank=True, null=True, verbose_name='delivered at')),
                ('abandoned_at', models.DateTimeField(blank=True, null=True, verbose_name='abandoned at')),
                ('error_message', models.TextField(blank=True, verbose_name='error message')),
                ('metadata', models.JSONField(blank=True, default=dict, verbose_name='metadata')),
                ('related_call', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='webhook_logs', to='django_twilio_call.call')),
            ],
            options={
                'verbose_name': 'Webhook Log',
                'verbose_name_plural': 'Webhook Logs',
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='AgentActivity',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('public_id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, unique=True)),
                ('activity_type', models.CharField(choices=[('login', 'Login'), ('logout', 'Logout'), ('status_change', 'Status Change'), ('break_start', 'Break Start'), ('break_end', 'Break End'), ('call_start', 'Call Start'), ('call_end', 'Call End'), ('skill_update', 'Skill Update'), ('queue_join', 'Queue Join'), ('queue_leave', 'Queue Leave')], db_index=True, max_length=30, verbose_name='activity type')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('from_status', models.CharField(blank=True, max_length=20, verbose_name='from status')),
                ('to_status', models.CharField(blank=True, max_length=20, verbose_name='to status')),
                ('duration_seconds', models.IntegerField(blank=True, help_text='Duration for break or call activities', null=True, verbose_name='duration seconds')),
                ('metadata', models.JSONField(blank=True, default=dict, verbose_name='metadata')),
                ('agent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='activities', to='django_twilio_call.agent')),
                ('call', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='agent_activities', to='django_twilio_call.call')),
            ],
            options={
                'verbose_name': 'Agent Activity',
                'verbose_name_plural': 'Agent Activities',
                'ordering': ['-created_at'],
                'indexes': [models.Index(fields=['agent', 'activity_type'], name='django_twil_agent_i_6145b9_idx'), models.Index(fields=['created_at'], name='django_twil_created_b24b42_idx'), models.Index(fields=['agent', 'created_at'], name='django_twil_agent_i_29a2a8_idx'), models.Index(fields=['activity_type', 'created_at'], name='django_twil_activit_5fd8f1_idx'), models.Index(fields=['agent', 'activity_type', 'created_at'], name='django_twil_agent_i_167a1c_idx'), models.Index(fields=['agent', 'from_status', 'to_status', 'created_at'], name='django_twil_agent_i_47cc09_idx')],
            },
        ),
        migrations.CreateModel(
            name='CallLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('public_id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, unique=True)),
                ('event_type', models.CharField(choices=[('initiated', 'Call Initiated'), ('queued', 'Call Queued'), ('ringing', 'Call Ringing'), ('answered', 'Call Answered'), ('connected', 'Call Connected'), ('hold', 'Call On Hold'), ('unhold', 'Call Resumed'), ('transfer', 'Call Transferred'), ('conference', 'Call Conferenced'), ('completed', 'Call Completed'), ('failed', 'Call Failed'), ('recording_start', 'Recording Started'), ('recording_stop', 'Recording Stopped'), ('voicemail', 'Voicemail Left'), ('dtmf', 'DTMF Input'), ('speech', 'Speech Input'), ('error', 'Error Occurred')], db_index=True, max_length=30, verbose_name='event type')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('data', models.JSONField(blank=True, default=dict, help_text='Additional event-specific data', verbose_name='event data')),
                ('error_code', models.CharField(blank=True, max_length=20, verbose_name='error code')),
                ('error_message', models.TextField(blank=True, verbose_name='error message')),
                ('agent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='call_logs', to='django_twilio_call.agent')),
                ('call', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='logs', to='django_twilio_call.call')),
            ],
            options={
                'verbose_name': 'Call Log',
                'verbose_name_plural': 'Call Logs',
                'ordering': ['call', 'created_at'],
                'indexes': [models.Index(fields=['call', 'event_type'], name='django_twil_call_id_610a94_idx'), models.Index(fields=['created_at'], name='django_twil_created_28b2c5_idx'), models.Index(fields=['call', 'created_at'], name='django_twil_call_id_e14a14_idx'), models.Index(fields=['event_type', 'created_at'], name='django_twil_event_t_d7d253_idx'), models.Index(fields=['agent', 'event_type', 'created_at'], name='django_twil_agent_i_de81fc_idx'), models.Index(fields=['call', 'event_type', 'created_at'], name='django_twil_call_id_913f2a_idx')],
            },
        ),
        migrations.CreateModel(
            name='CallRecording',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('public_id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, unique=True)),
                ('twilio_sid', models.CharField(max_length=50, unique=True, verbose_name='Twilio Recording SID')),
                ('status', models.CharField(choices=[('in-progress', 'In Progress'), ('completed', 'Completed'), ('failed', 'Failed'), ('deleted', 'Deleted')], default='in-progress', max_length=20, verbose_name='status')),
                ('duration', models.IntegerField(default=0, help_text='Recording duration in seconds', verbose_name='duration')),
                ('channels', models.IntegerField(default=1, help_text='Number of audio channels', verbose_name='channels')),
                ('source', models.CharField(help_text='Recording source (e.g., RecordVerb, DialVerb)', max_length=20, verbose_name='source')),
                ('url', models.URLField(blank=True, verbose_name='recording URL')),
                ('file_size', models.IntegerField(blank=True, help_text='File size in bytes', null=True, verbose_name='file size')),
                ('encryption_details', models.JSONField(blank=True, default=dict, verbose_name='encryption details')),
                ('transcription', models.TextField(blank=True, verbose_name='transcription')),
                ('transcription_status', models.CharField(blank=True, max_length=20, verbose_name='transcription status')),
                ('call', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='recordings', to='django_twilio_call.call')),
            ],
            options={
                'verbose_name': 'Call Recording',
                'verbose_name_plural': 'Call Recordings',
                'ordering': ['-created_at'],
                'indexes': [models.Index(fields=['twilio_sid'], name='django_twil_twilio__8d5b27_idx'), models.Index(fields=['call', 'status'], name='django_twil_call_id_04ee0b_idx')],
            },
        ),
        migrations.AddIndex(
            model_name='call',
            index=models.Index(fields=['twilio_sid'], name='django_twil_twilio__c69c85_idx'),
        ),
        migrations.AddIndex(
            model_name='call',
            index=models.Index(fields=['status', 'direction'], name='django_twil_status_b81991_idx'),
        ),
        migrations.AddIndex(
            model_name='call',
            index=models.Index(fields=['from_number', 'to_number'], name='django_twil_from_nu_2ba4b2_idx'),
        ),
        migrations.AddIndex(
            model_name='call',
            index=models.Index(fields=['created_at', 'status'], name='django_twil_created_6ef0ff_idx'),
        ),
        migrations.AddIndex(
            model_name='call',
            index=models.Index(fields=['agent', 'status', 'created_at'], name='django_twil_agent_i_a27566_idx'),
        ),
        migrations.AddIndex(
            model_name='call',
            index=models.Index(fields=['queue', 'status', 'created_at'], name='django_twil_queue_i_4aad44_idx'),
        ),
        migrations.AddIndex(
            model_name='call',
            index=models.Index(fields=['status', 'created_at'], name='django_twil_status_24b0e4_idx'),
        ),
        migrations.AddIndex(
            model_name='call',
            index=models.Index(fields=['created_at', 'direction', 'status'], name='django_twil_created_62e5a5_idx'),
        ),
        migrations.AddIndex(
            model_name='call',
            index=models.Index(fields=['agent', 'created_at', 'duration'], name='django_twil_agent_i_080c40_idx'),
        ),
        migrations.AddIndex(
            model_name='call',
            index=models.Index(fields=['queue', 'created_at', 'queue_time'], name='django_twil_queue_i_53f6ec_idx'),
        ),
        migrations.AddIndex(
            model_name='call',
            index=models.Index(fields=['from_number', 'created_at'], name='django_twil_from_nu_bd8ca2_idx'),
        ),
        migrations.AddIndex(
            model_name='call',
            index=models.Index(fields=['to_number', 'created_at'], name='django_twil_to_numb_a2479e_idx'),
        ),
        migrations.AddIndex(
            model_name='call',
            index=models.Index(condition=models.Q(('status__in', ['queued', 'ringing', 'in-progress'])), fields=['created_at'], name='idx_active_calls'),
        ),
        migrations.AddIndex(
            model_name='call',
            index=models.Index(condition=models.Q(('status', 'queued')), fields=['queue', 'created_at'], name='idx_queued_calls'),
        ),
        migrations.AddIndex(
            model_name='agent',
            index=models.Index(fields=['extension'], name='django_twil_extensi_551608_idx'),
        ),
        migrations.AddIndex(
            model_name='agent',
            index=models.Index(fields=['status', 'is_active'], name='django_twil_status_710e69_idx'),
        ),
        migrations.AddIndex(
            model_name='agent',
            index=models.Index(fields=['is_active', 'status', 'last_status_change'], name='django_twil_is_acti_d9b27a_idx'),
        ),
        migrations.AddIndex(
            model_name='agent',
            index=models.Index(fields=['status', 'is_active', 'max_concurrent_calls'], name='django_twil_status_ad497d_idx'),
        ),
        migrations.AddIndex(
            model_name='agent',
            index=models.Index(condition=models.Q(('is_active', True), ('status', 'available')), fields=['last_status_change'], name='idx_available_agents'),
        ),
        migrations.AddIndex(
            model_name='webhooklog',
            index=models.Index(fields=['webhook_type', 'status'], name='django_twil_webhook_13d30f_idx'),
        ),
        migrations.AddIndex(
            model_name='webhooklog',
            index=models.Index(fields=['status', 'next_retry_at'], name='django_twil_status_97cbab_idx'),
        ),
        migrations.AddIndex(
            model_name='webhooklog',
            index=models.Index(fields=['related_call', 'webhook_type'], name='django_twil_related_ce0d2e_idx'),
        ),
        migrations.AddIndex(
            model_name='webhooklog',
            index=models.Index(fields=['created_at', 'status'], name='django_twil_created_30f3f4_idx'),
        ),
        migrations.AddIndex(
            model_name='webhooklog',
            index=models.Index(condition=models.Q(('status__in', ['failed', 'retrying'])), fields=['next_retry_at'], name='idx_retry_webhooks'),
        ),
    ]
