"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEcsDataPlane = void 0;
const aws_ecs_1 = require("aws-cdk-lib/aws-ecs");
const secretManager = require("aws-cdk-lib/aws-secretsmanager");
const KongDataPlane_1 = require("../KongDataPlane");
const kong_dataplane_service_1 = require("./kong-dataplane-service");
const kong_dataplane_taskdefinition_1 = require("./kong-dataplane-taskdefinition");
class KongEcsDataPlane extends KongDataPlane_1.KongDataPlane {
    constructor(scope, id, props) {
        super(scope, id);
        let secrets = {};
        if (props.licenseSecret) {
            const licenseSecret = secretManager.Secret.fromSecretNameV2(this, 'KongDPLicense', props.licenseSecret ?? '');
            secrets.KONG_LICENSE_DATA = aws_ecs_1.Secret.fromSecretsManager(licenseSecret, 'license');
        }
        const kongDataPlaneTaskDefinition = new kong_dataplane_taskdefinition_1.KongDataplaneTaskdefinition(scope, 'KongDPTaskDefinition', {
            cluster: props.cluster,
            image: props.image,
            cluster_dns: props.clusterDns,
            telemetry_dns: props.telemeteryDns,
            certificates: props.certificates,
            kongTaskProps: props.kongTaskProps,
            secrets: secrets,
        });
        new kong_dataplane_service_1.KongDataplaneService(scope, 'KongDPFargateService', {
            kongServiceProps: {
                cluster: props.cluster,
                taskDefinition: kongDataPlaneTaskDefinition,
                desiredCount: props.desiredCount,
            },
            nlb: props.nlb,
        });
    }
}
exports.KongEcsDataPlane = KongEcsDataPlane;
//# sourceMappingURL=data:application/json;base64,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