import { Cluster, FargateTaskDefinitionProps } from 'aws-cdk-lib/aws-ecs';
import { NetworkLoadBalancer } from 'aws-cdk-lib/aws-elasticloadbalancingv2';
import { Construct } from 'constructs';
import { Certificates } from 'kong-core';
import { KongDataPlane } from '../KongDataPlane';
export interface KongDPProps {
    readonly cluster: Cluster;
    readonly certificates: Certificates;
    readonly clusterDns: string;
    readonly telemeteryDns: string;
    readonly nlb: NetworkLoadBalancer;
    readonly image: string;
    readonly kongTaskProps: FargateTaskDefinitionProps;
    readonly licenseSecret?: string;
    readonly desiredCount: number;
}
export declare class KongEcsDataPlane extends KongDataPlane {
    constructor(scope: Construct, id: string, props: KongDPProps);
}
