"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Flow = exports.FlowProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const fnf_generated_1 = require("./fnf.generated");
Object.defineProperty(exports, "FlowProperty", { enumerable: true, get: function () { return fnf_generated_1.RosFlow; } });
/**
 * A ROS resource type:  `ALIYUN::FNF::Flow`
 */
class Flow extends ros.Resource {
    /**
     * Create a new `ALIYUN::FNF::Flow`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosFlow = new fnf_generated_1.RosFlow(this, id, {
            description: props.description,
            requestId: props.requestId,
            definition: props.definition,
            roleArn: props.roleArn,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosFlow;
        this.attrCreatedTime = rosFlow.attrCreatedTime;
        this.attrId = rosFlow.attrId;
        this.attrLastModifiedTime = rosFlow.attrLastModifiedTime;
        this.attrName = rosFlow.attrName;
    }
}
exports.Flow = Flow;
//# sourceMappingURL=data:application/json;base64,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