from __future__ import annotations, print_function

class Codon:
    # https://arxiv.org/ftp/arxiv/papers/1608/1608.00539.pdf
    # Dipeptides
    # https://books.google.ca/books?id=RkaaBQAAQBAJ&pg=PA104&lpg=PA104&dq=chart+of+dipeptides&source=bl&ots=Kvgd9w-hN1&sig=ACfU3U2pCvjrN4MqBgpN1npxzijpkdM2XA&hl=en&sa=X&ved=2ahUKEwjg-dW0z4rgAhUTE3wKHbxnCFM4ChDoATACegQICBAB#v=onepage&q=chart%20of%20dipeptides&f=false
    RNAcodonByHalfScaleInStrBitmap = {
        "000000": "UUU",
        "000001": "UUC",
        "000010": "UUA",
        "000011": "UUG",
        "000100": "CUU",
        "000101": "CUC",
        "000110": "CUA",
        "000111": "CUG",
        "001000": "AUU",
        "001001": "AUC",
        "001010": "AUA",
        "001011": "AUG",
        "001100": "GUU",
        "001101": "GUC",
        "001110": "GUA",
        "001111": "GUG",
        "010000": "UCU",
        "010001": "UCC",
        "010010": "UCA",
        "010011": "UCG",
        "010100": "CCU",
        "010101": "CCC",
        "010110": "CCA",
        "010111": "CCG",
        "011000": "ACU",
        "011001": "ACC",
        "011010": "ACA",
        "011011": "ACG",
        "011100": "GCU",
        "011101": "GCC",
        "011110": "GCA",
        "011111": "GCG",
        "100000": "UAU",
        "100001": "UAC",
        "100010": "UAA",
        "100011": "UAG",
        "100100": "CAU",
        "100101": "CAC",
        "100110": "CAA",
        "100111": "CAG",
        "101000": "AAU",
        "101001": "AAC",
        "101010": "AAA",
        "101011": "AAG",
        "101100": "GAU",
        "101101": "GAC",
        "101110": "GAA",
        "101111": "GAG",
        "110000": "UGU",
        "110001": "UGC",
        "110010": "UGA",
        "110011": "UGG",
        "110100": "CGU",
        "110101": "CGC",
        "110110": "CGA",
        "110111": "CGG",
        "111000": "AGU",
        "111001": "AGC",
        "111010": "AGA",
        "111011": "AGG",
        "111100": "GGU",
        "111101": "GGC",
        "111110": "GGA",
        "111111": "GGG",
    }
    RNAaminoShortByHalfScaleInStrBitmap = {
        "000000": "Phe",
        "000001": "Phe",
        "000010": "Leu",
        "000011": "Leu",
        "000100": "Leu",
        "000101": "Leu",
        "000110": "Leu",
        "000111": "Leu",
        "001000": "Ile",
        "001001": "Ile",
        "001010": "Ile",
        "001011": "Met",
        "001100": "Val",
        "001101": "Val",
        "001110": "Val",
        "001111": "Val",
        "010000": "Ser",
        "010001": "Ser",
        "010010": "Ser",
        "010011": "Ser",
        "010100": "Pro",
        "010101": "Pro",
        "010110": "Pro",
        "010111": "Pro",
        "011000": "Thr",
        "011001": "Thr",
        "011010": "Thr",
        "011011": "Thr",
        "011100": "Ala",
        "011101": "Ala",
        "011110": "Ala",
        "011111": "Ala",
        "100000": "Tyr",
        "100001": "Tyr",
        "100010": "Stp",
        "100011": "Stp",
        "100100": "His",
        "100101": "His",
        "100110": "Gln",
        "100111": "Gln",
        "101000": "Asn",
        "101001": "Asn",
        "101010": "Lys",
        "101011": "Lys",
        "101100": "Asp",
        "101101": "Asp",
        "101110": "Glu",
        "101111": "Glu",
        "110000": "Cys",
        "110001": "Cys",
        "110010": "Stp",
        "110011": "Trp",
        "110100": "Arg",
        "110101": "Arg",
        "110110": "Arg",
        "110111": "arg",
        "111000": "Ser",
        "111001": "Ser",
        "111010": "Arg",
        "111011": "Arg",
        "111100": "Gly",
        "111101": "Gly",
        "111110": "Gly",
        "111111": "Gly",
    }

    RNAaminoLongByHalfScaleInStrBitmap = {
        "000000": "Phenylalanine",
        "000001": "Phenylalanine",
        "000010": "Leucine",
        "000011": "Leucine",
        "000100": "Leucine",
        "000101": "Leucine",
        "000110": "Leucine",
        "000111": "Leucine",
        "001000": "Isoleucine",
        "001001": "Isoleucine",
        "001010": "Isoleucine",
        "001011": "Methionine",
        "001100": "Valine",
        "001101": "Valine",
        "001110": "Valine",
        "001111": "Valine",
        "010000": "Serine",
        "010001": "Serine",
        "010010": "Serine",
        "010011": "Serine",
        "010100": "Proline",
        "010101": "Proline",
        "010110": "Proline",
        "010111": "Proline",
        "011000": "Threonine",
        "011001": "Threonine",
        "011010": "Threonine",
        "011011": "Threonine",
        "011100": "Alanine",
        "011101": "Alanine",
        "011110": "Alanine",
        "011111": "Alanine",
        "100000": "Tyrosine",
        "100001": "Tyrosine",
        "100010": "Stop Codon",
        "100011": "Stop Codon",  # Pyrrolysine
        "100100": "Histidine",
        "100101": "Histidine",
        "100110": "Glutamine",
        "100111": "Glutamine",
        "101000": "Asparagine",
        "101001": "Asparagine",
        "101010": "Lysine",
        "101011": "Lysine",
        "101100": "Aspartic Acid",
        "101101": "Aspartic Acid",
        "101110": "Glutamic Acid",
        "101111": "Glutamic Acid",
        "110000": "Cysteine",
        "110001": "Cysteine",
        "110010": "Stop Codon",
        "110011": "Tryptophan",
        "110100": "Arginine",
        "110101": "Arginine",
        "110110": "Arginine",
        "110111": "Arginine",
        "111000": "Serine",
        "111001": "Serine",
        "111010": "Arginine",
        "111011": "Arginine",
        "111100": "Glycine",
        "111101": "Glycine",
        "111110": "Glycine",
        "111111": "Glycine",
    }
    DNAcodonByHalfScaleInStrBitmap = {
        "000000": "TTT",
        "000001": "TTC",
        "000010": "TTA",
        "000011": "TTG",
        "000100": "CTT",
        "000101": "CTC",
        "000110": "CTA",
        "000111": "CTG",
        "001000": "ATT",
        "001001": "ATC",
        "001010": "ATA",
        "001011": "ATG",
        "001100": "GTT",
        "001101": "GTC",
        "001110": "GTA",
        "001111": "GTG",
        "010000": "TCT",
        "010001": "TCC",
        "010010": "TCA",
        "010011": "TCG",
        "010100": "CCT",
        "010101": "CCC",
        "010110": "CCA",
        "010111": "CCG",
        "011000": "ACT",
        "011001": "ACC",
        "011010": "ACA",
        "011011": "ACG",
        "011100": "GCT",
        "011101": "GCC",
        "011110": "GCA",
        "011111": "GCG",
        "100000": "TAT",
        "100001": "TAC",
        "100010": "TAA",
        "100011": "TAG",
        "100100": "CAT",
        "100101": "CAC",
        "100110": "CAA",
        "100111": "CAG",
        "101000": "AAT",
        "101001": "AAC",
        "101010": "AAA",
        "101011": "AAG",
        "101100": "GAT",
        "101101": "GAC",
        "101110": "GAA",
        "101111": "GAG",
        "110000": "TGT",
        "110001": "TGC",
        "110010": "TGA",
        "110011": "TGG",
        "110100": "CGT",
        "110101": "CGC",
        "110110": "CGA",
        "110111": "CGG",
        "111000": "AGT",
        "111001": "AGC",
        "111010": "AGA",
        "111011": "AGG",
        "111100": "GGT",
        "111101": "GGC",
        "111110": "GGA",
        "111111": "GGG",
    }

    DNAaminoByHalfScaleInStrBitmap = {
        "000000": "Penylalanin",
        "000001": "Penylalanin",
        "000010": "Leucine",
        "000011": "Leucine",
        "000100": "Leucine",
        "000101": "Leucine",
        "000110": "Leucine",
        "000111": "Leucine",
        "001000": "Isoleucine",
        "001001": "Isoleucine",
        "001010": "Isoleucine",
        "001011": "Methionine (START)",
        "001100": "Valine",
        "001101": "Valine",
        "001110": "Valine",
        "001111": "Valine",
        "010000": "Serine",
        "010001": "Serine",
        "010010": "Serine",
        "010011": "Serine",
        "010100": "Proline",
        "010101": "Proline",
        "010110": "Proline",
        "010111": "Proline",
        "011000": "Threonine",
        "011001": "Threonine",
        "011010": "Threonine",
        "011011": "Threonine",
        "011100": "Alanine",
        "011101": "Alanine",
        "011110": "Alanine",
        "011111": "Alanine",
        "100000": "Tyrosine",
        "100001": "Tyrosine",
        "100010": "STOP",
        "100011": "STOP",
        "100100": "Histidine",
        "100101": "Histidine",
        "100110": "Glutamine",
        "100111": "Glutamine",
        "101000": "Asparagine",
        "101001": "Asparagine",
        "101010": "Lysine",
        "101011": "Lysine",
        "101100": "Aspartic Acid",
        "101101": "Aspartic Acid",
        "101110": "Glutamic Acid",
        "101111": "Glutamic Acid",
        "110000": "Cystenine",
        "110001": "Cystenine",
        "110010": "STOP",
        "110011": "Tryptophan",
        "110100": "Arginine",
        "110101": "Arginine",
        "110110": "Arginine",
        "110111": "Arginine",
        "111000": "Serine",
        "111001": "Serine",
        "111010": "Arginine",
        "111011": "Arginine",
        "111100": "Glycine",
        "111101": "Glycine",
        "111110": "Glycine",
        "111111": "Glycine",
    }