# -*- coding: utf-8 -*-
"""Convenience functions for mofdscribe."""

import sys
from typing import List

from loguru import logger

__all__ = ["enable_logging"]


def enable_logging() -> List[int]:
    """Set up the mofdscribe logging with sane defaults."""
    logger.enable("mofdscribe")

    config = dict(
        handlers=[
            dict(
                sink=sys.stderr,
                format="<green>{time:YYYY-MM-DD HH:mm:ss.SSS Z UTC}</>"
                " <red>|</> <lvl>{level}</> <red>|</> <cyan>{name}:{function}:{line}</>"
                " <red>|</> <lvl>{message}</>",
                level="INFO",
            ),
            dict(
                sink=sys.stderr,
                format="<red>{time:YYYY-MM-DD HH:mm:ss.SSS Z UTC} | {level} | {name}:{function}:{line} | {message}</>",
                level="WARNING",
            ),
        ]
    )
    return logger.configure(**config)
