/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang3.Validate;
import org.cyclopsgroup.jmxterm.io.CommandOutput;
import org.cyclopsgroup.jmxterm.io.RuntimeIOException;

public class WriterCommandOutput
extends CommandOutput {
    private final Writer messageOutput;
    private final Writer resultOutput;

    public WriterCommandOutput(Writer output) {
        this(output, output);
    }

    public WriterCommandOutput(Writer resultOutput, Writer messageOutput) {
        Validate.notNull(resultOutput, "Result output can't be NULL", new Object[0]);
        this.resultOutput = resultOutput;
        this.messageOutput = messageOutput == null ? new NullWriter() : messageOutput;
    }

    @Override
    public void print(String output) {
        if (output == null) {
            return;
        }
        try {
            this.resultOutput.write(output);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Can't print out result", e);
        }
    }

    @Override
    public void printError(Throwable e) {
        e.printStackTrace(new PrintWriter(this.messageOutput, true));
    }

    @Override
    public void printMessage(String message) {
        try {
            this.messageOutput.write(message);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Can't print out message", e);
        }
    }
}

