/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli.impl;

import com.google.common.base.Strings;
import org.cyclopsgroup.caff.format.FixLengthField;
import org.cyclopsgroup.caff.format.FixLengthType;
import org.cyclopsgroup.jcli.spi.Option;

@FixLengthType(length=256)
public class OptionHelp {
    private final Option option;

    OptionHelp(Option option) {
        this.option = option;
    }

    @FixLengthField(start=30, length=220)
    public String getDescription() {
        String desc = this.option.getDescription();
        if (!this.option.isFlag() && !Strings.isNullOrEmpty(this.option.getDefaultValue())) {
            desc = desc + "(Default value is " + this.option.getDefaultValue() + ")";
        }
        return desc;
    }

    @FixLengthField(start=20, length=9)
    public String getDisplayName() {
        return this.option.isFlag() ? null : "<" + this.option.getDisplayName() + ">";
    }

    @FixLengthField(start=3, length=16)
    public String getLongName() {
        return Strings.isNullOrEmpty(this.option.getLongName()) ? null : "--" + this.option.getLongName();
    }

    @FixLengthField(start=0, length=2)
    public String getName() {
        return "-" + this.option.getName();
    }
}

