/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.ref;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.cyclopsgroup.caff.ref.AccessFailureException;
import org.cyclopsgroup.caff.ref.ValueReference;

class FieldValueReference<T>
extends ValueReference<T> {
    private final Field field;
    private final boolean publicField;

    FieldValueReference(Field field) {
        this.field = Preconditions.checkNotNull(field, "An input field is required.");
        this.publicField = (field.getModifiers() & 1) > 0;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.field.getAnnotation(annotationType);
    }

    @Override
    public ImmutableList<AnnotatedElement> getAnontatedElements() {
        return ImmutableList.of(this.field);
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Class<?> getType() {
        return this.field.getType();
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return !Modifier.isFinal(this.field.getModifiers());
    }

    @Override
    public Object readValue(T owner) throws AccessFailureException {
        if (!this.publicField && !this.field.isAccessible()) {
            this.field.setAccessible(true);
        }
        try {
            return this.field.get(owner);
        }
        catch (IllegalAccessException e) {
            throw new AccessFailureException("Can't get field " + this.field + " of " + owner, e);
        }
    }

    @Override
    public void writeValue(Object value, T owner) throws AccessFailureException {
        if (value == null && this.field.getType().isPrimitive()) {
            return;
        }
        if (!this.publicField && !this.field.isAccessible()) {
            this.field.setAccessible(true);
        }
        try {
            this.field.set(owner, value);
        }
        catch (IllegalAccessException e) {
            throw new AccessFailureException("Can't set field " + this.field + " of " + owner + " to " + value, e);
        }
    }
}

