/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.interpol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.configuration2.interpol.DefaultLookups;
import org.apache.commons.configuration2.interpol.DummyLookup;
import org.apache.commons.configuration2.interpol.InterpolatorSpecification;
import org.apache.commons.configuration2.interpol.Lookup;
import org.apache.commons.configuration2.interpol.StringLookupAdapter;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.DefaultStringLookup;

public class ConfigurationInterpolator {
    private static final char PREFIX_SEPARATOR = ':';
    private static final String VAR_START = "${";
    private static final int VAR_START_LENGTH = "${".length();
    private static final String VAR_END = "}";
    private static final int VAR_END_LENGTH = "}".length();
    private static final Map<String, Lookup> DEFAULT_PREFIX_LOOKUPS;
    private final Map<String, Lookup> prefixLookups = new ConcurrentHashMap<String, Lookup>();
    private final List<Lookup> defaultLookups = new CopyOnWriteArrayList<Lookup>();
    private final StringSubstitutor substitutor = this.initSubstitutor();
    private volatile ConfigurationInterpolator parentInterpolator;

    private static ConfigurationInterpolator createInterpolator(InterpolatorSpecification spec) {
        ConfigurationInterpolator ci = new ConfigurationInterpolator();
        ci.addDefaultLookups(spec.getDefaultLookups());
        ci.registerLookups(spec.getPrefixLookups());
        ci.setParentInterpolator(spec.getParentInterpolator());
        return ci;
    }

    private static String extractVariableName(String strValue) {
        return strValue.substring(VAR_START_LENGTH, strValue.length() - VAR_END_LENGTH);
    }

    public static ConfigurationInterpolator fromSpecification(InterpolatorSpecification spec) {
        if (spec == null) {
            throw new IllegalArgumentException("InterpolatorSpecification must not be null!");
        }
        return spec.getInterpolator() != null ? spec.getInterpolator() : ConfigurationInterpolator.createInterpolator(spec);
    }

    public static Map<String, Lookup> getDefaultPrefixLookups() {
        return DEFAULT_PREFIX_LOOKUPS;
    }

    public static Lookup nullSafeLookup(Lookup lookup) {
        if (lookup == null) {
            lookup = DummyLookup.INSTANCE;
        }
        return lookup;
    }

    public void addDefaultLookup(Lookup defaultLookup) {
        this.defaultLookups.add(defaultLookup);
    }

    public void addDefaultLookups(Collection<? extends Lookup> lookups) {
        if (lookups != null) {
            this.defaultLookups.addAll(lookups);
        }
    }

    public boolean deregisterLookup(String prefix) {
        return this.prefixLookups.remove(prefix) != null;
    }

    protected Lookup fetchLookupForPrefix(String prefix) {
        return ConfigurationInterpolator.nullSafeLookup(this.prefixLookups.get(prefix));
    }

    public List<Lookup> getDefaultLookups() {
        return new ArrayList<Lookup>(this.defaultLookups);
    }

    public Map<String, Lookup> getLookups() {
        return new HashMap<String, Lookup>(this.prefixLookups);
    }

    public ConfigurationInterpolator getParentInterpolator() {
        return this.parentInterpolator;
    }

    private StringSubstitutor initSubstitutor() {
        return new StringSubstitutor(key -> Objects.toString(this.resolve(key), null));
    }

    public Object interpolate(Object value) {
        if (value instanceof String) {
            Object resolvedValue;
            String strValue = (String)value;
            if (this.looksLikeSingleVariable(strValue) && (resolvedValue = this.resolveSingleVariable(strValue)) != null && !(resolvedValue instanceof String)) {
                return resolvedValue;
            }
            return this.substitutor.replace(strValue);
        }
        return value;
    }

    public boolean isEnableSubstitutionInVariables() {
        return this.substitutor.isEnableSubstitutionInVariables();
    }

    private boolean looksLikeSingleVariable(String strValue) {
        return strValue.startsWith(VAR_START) && strValue.endsWith(VAR_END);
    }

    public Set<String> prefixSet() {
        return Collections.unmodifiableSet(this.prefixLookups.keySet());
    }

    public void registerLookup(String prefix, Lookup lookup) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix for lookup object must not be null!");
        }
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup object must not be null!");
        }
        this.prefixLookups.put(prefix, lookup);
    }

    public void registerLookups(Map<String, ? extends Lookup> lookups) {
        if (lookups != null) {
            this.prefixLookups.putAll(lookups);
        }
    }

    public boolean removeDefaultLookup(Lookup lookup) {
        return this.defaultLookups.remove(lookup);
    }

    public Object resolve(String var) {
        Object value;
        if (var == null) {
            return null;
        }
        int prefixPos = var.indexOf(58);
        if (prefixPos >= 0) {
            String prefix = var.substring(0, prefixPos);
            String name = var.substring(prefixPos + 1);
            value = this.fetchLookupForPrefix(prefix).lookup(name);
            if (value != null) {
                return value;
            }
        }
        for (Lookup lookup : this.defaultLookups) {
            value = lookup.lookup(var);
            if (value == null) continue;
            return value;
        }
        ConfigurationInterpolator parent = this.getParentInterpolator();
        if (parent != null) {
            return this.getParentInterpolator().resolve(var);
        }
        return null;
    }

    private Object resolveSingleVariable(String strValue) {
        return this.resolve(ConfigurationInterpolator.extractVariableName(strValue));
    }

    public void setEnableSubstitutionInVariables(boolean f) {
        this.substitutor.setEnableSubstitutionInVariables(f);
    }

    public void setParentInterpolator(ConfigurationInterpolator parentInterpolator) {
        this.parentInterpolator = parentInterpolator;
    }

    static {
        HashMap<String, Lookup> lookups = new HashMap<String, Lookup>();
        for (DefaultLookups defaultLookups : DefaultLookups.values()) {
            lookups.put(defaultLookups.getPrefix(), defaultLookups.getLookup());
        }
        for (Enum enum_ : DefaultStringLookup.values()) {
            lookups.putIfAbsent(((DefaultStringLookup)enum_).getKey(), new StringLookupAdapter(((DefaultStringLookup)enum_).getStringLookup()));
        }
        DEFAULT_PREFIX_LOOKUPS = Collections.unmodifiableMap(lookups);
    }
}

