# Calco: A Powerful Expression Evaluator

![BSD License](https://img.shields.io/github/license/trabdlkarim/pycalco) ![Platforms](https://img.shields.io/powershellgallery/p/DNS.1.1.1.1)
![Python v3.7](https://img.shields.io/github/pipenv/locked/python-version/metabolize/rq-dashboard-on-heroku) ![Build passing](https://img.shields.io/github/workflow/status/actions/toolkit/Main%20workflow)


PyCalco or shortly Calco is a powerful command line interface for arithmetic and algebraic or symbolic expressions evaluation. Its power relies on the **math** module from Python standard library and **SymPy** module, which is a Python library for symbolic mathematics. If you are new to SymPy or symbolic computation, start with their [tutorial](https://docs.sympy.org/latest/tutorial/index.html#tutorial), it is a great place where to start from.

# Why Another Python Calculator?
There are so many Python calculators or expression evaluators out there for evaluating mathematical expressions; why does PyCalco exist?
Well, we acknowledge that question is legitimate, but it is easy to answer: because there is not a single command line utility for expression evaluation in Python out there which ticks the following boxes:

- is simple, interactive and intuitive
- supports both arithemetic and algebraic expressions evaluation
- is highly customizable with the ability to add new scientific modules without too much struggle
- suppports variable assignment
- needs no python import statements to use globally available mathematical functions
- comes with useful common helpers (getting terminal dimensions, ANSI colors, fetching direct keyboard input, screen clearing, command history, various other assignment tools, supporting bang shortcuts, etc.)

PyCalco actually implements its own shell and is designed to be fun and customizable but not overly flexible. To get an understanding of what PyCalco is all about, we strongly recommend looking at the [PyCalco Tutorials](https://gh.trabdlkarim.com/pycalco/).

# Installation

PyCalco is available on the [Python Package Index](https://pypi.org/project/pycalco/), which makes its installation quite easy.
You just need python3 and its package manager pip3 on your plateform, then you are set to install PyCalco.

Run the following command from the terminal for installation:

`pip install pycalco`

If that didn't work, try:

`python3 -m pip install pycalco`

# Usage

After installation to run PyCalco interactively just type, again from the terminal, the following command:

`pycalco launch`

And voilà, you are ready to use PyCalco. You should see the PyCalco shell waiting for you to enter your commands and evaluate expressions. Type `help` to get help on how to use PyCalco. You can also type directly any valid arithmetic and symbolic expression to get it evaluated.


# Documentation

The project documentation is located at <https://docs.trabdlkarim.com/projects/pycalco/en/latest/>. Please note that the documentation is still a work in progress, so improvements to it are welcome.

# Support & Contribution

PyCalco is under BSD 3-Clause Revised License, which means its license is an [Open Source Initiative ](https://opensource.org/) approved license. Being an open source software PyCalco needs your support. Feel free to contribute to this project by forking it and submitting your changes as a pull request. Feel also free to report any bug [here](https://github.com/trabdlkarim/pycalco/issues) that you may find. And we also welcome greatly new feature suggestions. 
So please do not hesitate to send us your feedback.

---

For more detailed informations about PyCalco visit the [project homepage](https://gh.trabdlkarim.com/pycalco/).

Made with :heart: and Python!!!
