# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/05_stats.ipynb (unless otherwise specified).

__all__ = ['icc_description_dict', 'describe_iccs', 'retest_plot', 'jitter', 'analyze_reliability', 'get_psych_iccs']

# Cell
from scipy.stats import pearsonr
import matplotlib.pyplot as plt
import random
import os
import pandas as pd
import seaborn as sns
import numpy as np
from IPython.core.display import display, HTML, Image
import biuR.wrapper

# Cell
def icc_description_dict(iccs):
    """A helper function for formatting icc output.
    """
    format_icc = lambda x: ("%.2f"%x)[1:]
    iccs[0]['description'] = iccs[0]['ICC'].apply(format_icc) + ' (' + iccs[0]['lower bound'].apply(format_icc) + ', ' + iccs[0]['upper bound'].apply(format_icc) + ')'
    return {k:v for k,v in zip(iccs[0].type,iccs[0]['description'])}

def describe_iccs(iccs, description = ""):
    """A helper function for formatting icc output.
    """
    description_dict = icc_description_dict(iccs)
    description_dict['description'] = description
    display(HTML("The ICC(1) for %(description)s was %(ICC1)s.  The ICC(1,k) for %(description)s was %(ICC1k)s."%description_dict))
    display(iccs[0].round(3))
    display(iccs[1].round(3))
    return description_dict

def retest_plot(df, add_jitter):
    #fig, axs = plt.subplots(1,3, figsize = (16,4))
    fig = plt.figure(figsize = (10,8))
    gs = fig.add_gridspec(3,2)
    axs = []
    axs.append(fig.add_subplot(gs[0, 0]))
    axs.append(fig.add_subplot(gs[0, 1]))
    axs.append(fig.add_subplot(gs[1:, :]))
    for i in range(2):
        df.iloc[:,i].hist(ax = axs[i])
        axs[i].title.set_text(df.columns[i])
        axs[i].grid(False)
    if add_jitter:
        df[str(df.columns[0])+'_j'] = jitter(df.iloc[:,0])
        df[str(df.columns[1])+'_j'] = jitter(df.iloc[:,1])
        ax = df.plot.scatter(x=str(df.columns[0])+'_j',y=str(df.columns[1])+'_j', ax = axs[2], alpha = .8)
        ax.grid(False)
    else:
        ax = df.plot.scatter(x=df.columns[0],y=df.columns[1], ax = axs[2])
        ax.grid(False)
    sns.despine()
    return fig

def jitter(arr):
    return arr + np.random.randn(len(arr)) * arr.std()/10

def analyze_reliability(df, dependent, add_jitter = False, title = ''):
    df['_session'] = df.session_number.apply(lambda x: "Session %d"%x)
    ssrt_reg = df.set_index(['participant','_session']).unstack()[dependent].dropna()
    iccs = get_psych_iccs(ssrt_reg)
    describe_iccs(iccs,dependent)
    fig = retest_plot(ssrt_reg, add_jitter)
    title = title if len(title) else "Test-retest reliability: %s"%dependent
    fig.suptitle(title);
    plt.show()
    return {'fig':fig, 'iccs':iccs}


def get_psych_iccs(df):
    """This function calculates ICCs using the psych package.
    """
    R = biuR.wrapper.R()
    R("""
    require(psych)
    options(warn=-1)
    result = psych::ICC(df)
    # Adding the quotes seems to be import because of glitch that leaks python globals into r
    iccs = result$"results"# -o iccs
    lmers = result$"lme"# -o lmers
    """, push = dict(df=df))
    iccs = R("""iccs""")
    lmers = R("""lmers""")

    return iccs,lmers